/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.iox.dao;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessInstanceCache;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.iox.cache.IoXCache;
import com.actionsoft.bpms.commons.iox.model.IoXModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.i18n.I18nDao;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.i18n.model.I18nModel;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class IoXDao
extends DaoObject<IoXModel> {
    @Override
    public int insert(IoXModel model) throws AWSDataAccessException {
        if (!(model.getAdvanceType().equals("IOBD") || model.getAdvanceType().equals("IOC") || model.getAdvanceType().equals("IOR") || model.getAdvanceType().equals("IOS"))) {
            throw new AWSIllegalArgumentException("advanceType", "FORMAT", "\u53ea\u5141\u8bb8\u662fInstanceAdvanceExtendConst\u5e38\u91cf\u5b9a\u4e49\u7684\u7c7b\u578b");
        }
        String sql = "INSERT INTO " + this.entityName() + "(ID,ADVANCETYPE,ORDERINDEX)VALUES(:ID,:ADVANCETYPE,:ORDERINDEX)";
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ID", model.getId());
        paraMap.put("ADVANCETYPE", model.getAdvanceType());
        paraMap.put("ORDERINDEX", model.getOrderIndex());
        int r = DBSql.update(sql, paraMap);
        if (r > 0) {
            IoXCache.putModel(model);
        }
        return r;
    }

    public int delete(Object id, String language) throws AWSDataAccessException {
        int r;
        IoXModel model = IoXCache.getModel((String)id);
        if (model == null) {
            throw new AWSObjectNotFindException("IoXModel\u672a\u627e\u5230\u3002id:" + id);
        }
        String i18L = I18nRes.findValue("com.actionsoft.apps.addons.iox", language, model.getAdvanceType());
        String valueId = (String)id;
        if (model.getAdvanceType().equals("IOBD")) {
            if (SDK.getProcessQueryAPI().IOBD(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getTaskQueryAPI().IOBD(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u6d3b\u52a8\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getHistoryTaskQueryAPI().IOBD(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u5f52\u6863\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
        } else if (model.getAdvanceType().equals("IOC")) {
            if (SDK.getProcessQueryAPI().IOC(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getTaskQueryAPI().IOC(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u6d3b\u52a8\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getHistoryTaskQueryAPI().IOC(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u5f52\u6863\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
        } else if (model.getAdvanceType().equals("IOR")) {
            if (SDK.getProcessQueryAPI().IOR(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getTaskQueryAPI().IOR(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u6d3b\u52a8\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getHistoryTaskQueryAPI().IOR(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u5f52\u6863\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
        } else if (model.getAdvanceType().equals("IOS")) {
            if (SDK.getProcessQueryAPI().IOS(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getTaskQueryAPI().IOS(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u6d3b\u52a8\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
            if (SDK.getHistoryTaskQueryAPI().IOS(valueId).count() > 0L) {
                throw new AWSForbiddenException("\u5728\u4efb\u52a1\u5f52\u6863\u5b9e\u4f8b\u4e2d" + i18L + "\u5df2\u88ab\u5173\u8054\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
            }
        }
        if ((r = super.delete(id)) > 0) {
            IoXCache.removeById((String)id);
        }
        return r;
    }

    @Override
    public int update(IoXModel model) throws AWSDataAccessException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(this.entityName()).append(" SET ");
        sql.append("ID").append("=?,");
        sql.append("ADVANCETYPE").append("=?,");
        sql.append("ORDERINDEX").append("=?");
        sql.append(" WHERE ").append("ID").append("=?");
        int r = DBSql.update(sql.toString(), new Object[]{model.getId(), model.getAdvanceType(), model.getOrderIndex(), model.getId()});
        if (r > 0) {
            IoXCache.putModel(model);
        }
        return r;
    }

    public int merge(IoXModel mainModel, List<IoXModel> deleteList, I18nModel i18nModel) {
        I18nDao i18nDao = new I18nDao();
        File file = new File(String.valueOf(AppsAPIManager.getInstance().getResourceRealpath("com.actionsoft.apps.addons.iox", "i18n")) + "/resource.xml");
        i18nDao.update("com.actionsoft.apps.addons.iox", file, i18nModel);
        Connection conn = null;
        try {
            String sql = "";
            conn = DBSql.open();
            for (IoXModel model : deleteList) {
                HashMap<String, Object> paraMap = new HashMap<String, Object>();
                paraMap.put("mainiox", mainModel.getId());
                paraMap.put("deliox", model.getId());
                if (model.getAdvanceType().equals("IOBD")) {
                    sql = "update WFC_PROCESS set iobd=:mainiox where iobd=:deliox";
                    DBSql.update(conn, sql, paraMap);
                    ProcessInstanceCache.removeAll();
                } else if (model.getAdvanceType().equals("IOR")) {
                    sql = "update WFC_PROCESS set ior=:mainiox where ior=:deliox";
                    DBSql.update(conn, sql, paraMap);
                    ProcessInstanceCache.removeAll();
                } else if (model.getAdvanceType().equals("IOS")) {
                    sql = "update WFC_PROCESS set ios=:mainiox where ios=:deliox";
                    DBSql.update(conn, sql, paraMap);
                    ProcessInstanceCache.removeAll();
                } else if (model.getAdvanceType().equals("IOC")) {
                    sql = "update WFC_PROCESS set ioc=:mainiox where ioc=:deliox";
                    DBSql.update(conn, sql, paraMap);
                    ProcessInstanceCache.removeAll();
                }
                if (model.getAdvanceType().equals("IOBD")) {
                    sql = "update WFC_TASK set iobd=:mainiox where iobd=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOR")) {
                    sql = "update WFC_TASK set ior=:mainiox where ior=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOS")) {
                    sql = "update WFC_TASK set ios=:mainiox where ios=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOC")) {
                    sql = "update WFC_TASK set ioc=:mainiox where ioc=:deliox";
                    DBSql.update(conn, sql, paraMap);
                }
                if (model.getAdvanceType().equals("IOBD")) {
                    sql = "update WFH_TASK set iobd=:mainiox where iobd=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOR")) {
                    sql = "update WFH_TASK set ior=:mainiox where ior=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOS")) {
                    sql = "update WFH_TASK set ios=:mainiox where ios=:deliox";
                    DBSql.update(conn, sql, paraMap);
                } else if (model.getAdvanceType().equals("IOC")) {
                    sql = "update WFH_TASK set ioc=:mainiox where ioc=:deliox";
                    DBSql.update(conn, sql, paraMap);
                }
                i18nDao.delete("com.actionsoft.apps.addons.iox", file, model.getId());
                this.delete(model.getId());
                IoXCache.getCache().remove(model.getId());
            }
            return 1;
        }
        catch (Exception e) {
            throw new AWSDataAccessException(e);
        }
        finally {
            DBSql.close(conn);
        }
    }

    public IoXModel queryUp(String id, int orderIndex, String advancetype) throws AWSDataAccessException {
        String sql = "select * from " + this.entityName() + " where orderindex<? and " + "ADVANCETYPE" + "=? order by orderindex desc";
        IoXModel model = DBSql.getObject(sql, this.rowMapper(), orderIndex, advancetype);
        return model;
    }

    public IoXModel queryDown(String id, int orderIndex, String advancetype) throws AWSDataAccessException {
        String sql = "select * from " + this.entityName() + " where orderindex>? and " + "ADVANCETYPE" + "=? order by orderindex asc";
        IoXModel model = DBSql.getObject(sql, this.rowMapper(), orderIndex, advancetype);
        return model;
    }

    @Override
    public String entityName() {
        return "SYS_IOX";
    }

    @Override
    public RowMapper<IoXModel> rowMapper() {
        return new Mapper();
    }

    public int getMaxIndex(String advanceType) {
        String sql = "SELECT MAX(ORDERINDEX) FROM " + this.entityName() + " WHERE ADVANCETYPE=:ADVANCETYPE";
        Object[] args = new Object[]{advanceType};
        int r = DBSql.getInt(sql, args);
        return r;
    }

    private class Mapper
    implements RowMapper<IoXModel> {
        private Mapper() {
        }

        public IoXModel mapRow(ResultSet rset, int rowNum) throws SQLException {
            IoXModel model = new IoXModel();
            try {
                model.setId(rset.getString("ID"));
                model.setAdvanceType(rset.getString("ADVANCETYPE"));
                model.setOrderIndex(rset.getInt("ORDERINDEX"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return model;
        }
    }
}

