/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.auditing;

import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.log.auditing.dao.LogDao;
import com.actionsoft.bpms.commons.log.auditing.model.AuditConfModel;
import com.actionsoft.bpms.commons.log.auditing.model.AuditModel;
import com.actionsoft.bpms.commons.log.auditing.model.CatalogModel;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.RequestContext;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.ExceptionUtil;
import com.actionsoft.sdk.local.SDK;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class Auditor {
    private static long lastModify;
    private static AuditConfModel lgConf;
    private static Map<String, AuditModel> cmdCache;
    private static Map<String, List<AuditModel>> daoCache;
    private static LogDao dao;
    private static final String TYPE_CMD = "cmd";
    private static final String TYPE_DAO = "dao";
    private static final Pattern PARAM_PATTERN;
    private static final Pattern DAO_PARAM_PATTERN;
    private static final Pattern CACHE_PATTERN;
    private static final String MAT = "$matr(";
    private static final String MAT_1 = "$matrl(";
    private static final String AUDIT_CMD = "dao.audit.off";

    static {
        cmdCache = new HashMap<String, AuditModel>();
        daoCache = new HashMap<String, List<AuditModel>>();
        dao = new LogDao();
        PARAM_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");
        DAO_PARAM_PATTERN = Pattern.compile("\\$arg\\((\\d+,)?(\\w+)?\\)");
        CACHE_PATTERN = Pattern.compile("\\$refCache\\((.+?)\\)");
        Auditor.reload();
    }

    public static String getError(Exception e) {
        return ExceptionUtil.getMessage(e);
    }

    public static boolean changed(File xmlFile) {
        if (!xmlFile.exists()) {
            return false;
        }
        return lastModify != xmlFile.lastModified();
    }

    public static void setLastModify(long lastModify) {
        Auditor.lastModify = lastModify;
    }

    public static AuditConfModel getLgConf() {
        return lgConf;
    }

    public static void setLgConf(final AuditConfModel lgConf) {
        Auditor.lgConf = lgConf;
        cmdCache.clear();
        daoCache.clear();
        for (AuditModel auditModel : lgConf.getAudits()) {
            if (TYPE_CMD.equals(auditModel.getType())) {
                cmdCache.put(auditModel.getId(), auditModel);
                continue;
            }
            if (!TYPE_DAO.equals(auditModel.getType())) continue;
            List<AuditModel> list = daoCache.get(auditModel.getId());
            if (list == null) {
                list = new ArrayList<AuditModel>();
                daoCache.put(auditModel.getId(), list);
            }
            list.add(auditModel);
        }
        List<CatalogModel> cs = lgConf.getCatalogs();
        Collections.sort(cs, new Comparator<CatalogModel>(){

            @Override
            public int compare(CatalogModel o1, CatalogModel o2) {
                if (o1.getChannel().equals(o2.getChannel())) {
                    return 0;
                }
                return lgConf.getChannels().indexOf(o1.getChannel()) - lgConf.getChannels().indexOf(o2.getChannel());
            }
        });
    }

    public static void log(String catalog, String action, String auditObject) {
        Auditor.log(catalog, action, auditObject, null);
    }

    public static void log(String catalog, String action, String auditObject, String info) {
        Auditor.log(null, catalog, action, null, auditObject, info, null, Level.INFO);
    }

    public static void log(String channel, String catalog, String action, String auditSubject, String auditObject, String info, String ip, Level level) {
        LogModel lg = new LogModel();
        lg.setLogChannel(channel);
        lg.setLogCatalog(catalog);
        lg.setOp(action);
        lg.setOpUser(auditSubject);
        lg.setLogObj(auditObject);
        lg.setOpInfo(info);
        lg.setOpIp(ip);
        lg.setOpLevel(level.getLevel());
        Auditor.log(lg);
    }

    public static void log(LogModel lg) {
        if (lgConf.isService()) {
            if (UtilString.isEmpty(lg.getLogChannel())) {
                lg.setLogChannel(lgConf.getChannel(lg.getLogCatalog()));
            }
            dao.insert(lg);
        }
    }

    public static void interceptAfter(LogModel lg, RequestContext rc, String ret) {
        if (lg == null) {
            return;
        }
        AuditModel auditModel = Auditor.getCmdAuditConf(rc.getExchange().getCmd());
        if (!UtilString.isEmpty(auditModel.getWhen()) && !Boolean.parseBoolean(Auditor.parseRule(rc, auditModel.getWhen(), ret))) {
            return;
        }
        lg.setLogCatalog(lg.getLogCatalog());
        lg.setOp(Auditor.parseRule(rc, lg.getOp(), ret));
        lg.setLogObj(Auditor.parseRule(rc, auditModel.getObj(), ret));
        lg.setOpInfo(Auditor.parseRule(rc, auditModel.getInfo(), ret));
        lg.setOpUser(rc.getUserContext().getUID());
        lg.setOpIp(rc.getIp());
    }

    public static LogModel interceptBefore(RequestContext rc) {
        if (!lgConf.isService() || !lgConf.isCmd()) {
            return null;
        }
        AuditModel auditModel = Auditor.getCmdAuditConf(rc.getExchange().getCmd());
        if (auditModel == null) {
            return null;
        }
        rc.getExchange().getParameters().put(AUDIT_CMD, "");
        String ret = null;
        LogModel lg = new LogModel();
        lg.setLogCatalog(auditModel.getCatalog());
        lg.setOp(Auditor.parseRule(rc, auditModel.getOp(), ret));
        lg.setOpUser(rc.getUserContext().getUID());
        lg.setOpIp(rc.getIp());
        return lg;
    }

    public static Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!lgConf.isService() || !lgConf.isDao() || DispatcherRequest.getContext() != null && DispatcherRequest.getContext().getExchange().getParameters().containsKey(AUDIT_CMD)) {
            return proxy.invokeSuper(obj, args);
        }
        AuditModel auditModel = Auditor.getDaoAuditConf(obj.getClass(), method.getDeclaringClass(), method, args);
        if (auditModel == null) {
            return proxy.invokeSuper(obj, args);
        }
        Object r = null;
        boolean hasExec = false;
        if (!auditModel.isCalArgsBeforeExec()) {
            r = proxy.invokeSuper(obj, args);
            hasExec = true;
        }
        LogModel lg = new LogModel();
        lg.setLogCatalog(auditModel.getCatalog());
        lg.setLogObj(auditModel.getId());
        lg.setOp(Auditor.parseRule(auditModel, obj, args, auditModel.getOp()));
        lg.setLogObj(Auditor.parseRule(auditModel, obj, args, auditModel.getObj()));
        lg.setOpInfo(Auditor.parseRule(auditModel, obj, args, auditModel.getInfo()));
        RequestContext rc = DispatcherRequest.getContext();
        if (rc != null) {
            if (rc.getUserContext() != null) {
                lg.setOpUser(rc.getUserContext().getUID());
            }
            lg.setOpIp(rc.getIp());
        }
        if (!hasExec) {
            r = proxy.invokeSuper(obj, args);
        }
        Auditor.log(lg);
        return r;
    }

    private static String parseRule(AuditModel auditModel, Object obj, Object[] args, String s) {
        if (UtilString.isEmpty(s)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = DAO_PARAM_PATTERN.matcher(s);
        while (matcher.find()) {
            String v;
            block10: {
                String g1 = matcher.group(1);
                int index = 0;
                v = matcher.group();
                String name = matcher.group(2);
                if (g1 != null && StringUtils.isNumeric((String)g1.replaceAll(",$", ""))) {
                    index = Integer.parseInt(g1.replaceAll(",$", ""));
                }
                if (StringUtils.isNumeric((String)name)) {
                    index = Integer.parseInt(name);
                    name = null;
                }
                if (!UtilString.isEmpty(name)) {
                    Object o = args[index];
                    try {
                        if (name.startsWith("_")) {
                            Object t = FieldUtils.readField((Object)o, (String)name, (boolean)true);
                            if (t != null) {
                                v = t.toString();
                            }
                            break block10;
                        }
                        v = BeanUtils.getProperty((Object)o, (String)name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    v = String.valueOf(args[index]);
                }
            }
            matcher.appendReplacement(sb, v);
        }
        matcher.appendTail(sb);
        return Auditor.parseRefCache(auditModel, sb, args);
    }

    private static String parseRefCache(AuditModel auditModel, CharSequence s, Object[] args) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = CACHE_PATTERN.matcher(s);
        while (matcher.find()) {
            String[] ss = matcher.group(1).split(",");
            String modelMeta = ss[0];
            String prop = ss[1];
            int index = 0;
            Object argv = null;
            if (ss.length > 2) {
                if (StringUtils.isNumeric((String)ss[2])) {
                    index = Integer.parseInt(ss[2]);
                    argv = args[index];
                } else {
                    argv = ss[2];
                }
            } else if (args != null && args.length > 0) {
                argv = args[0];
            }
            String pv = "";
            String method = "";
            try {
                Method m;
                Object o;
                Cache<?, ?> c = null;
                Object obj = null;
                if (modelMeta.indexOf(35) != -1) {
                    String[] tmp = modelMeta.split("#");
                    CacheManager.getInstance();
                    c = CacheManager.getCache(tmp[0]);
                    try {
                        obj = MethodUtils.invokeMethod(c, (String)tmp[1], (Object[])new Object[]{argv});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    CacheManager.getInstance();
                    c = CacheManager.getCache(modelMeta);
                    obj = c.get((Serializable)argv);
                }
                method = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                if (obj != null && (o = (m = obj.getClass().getDeclaredMethod(method, null)).invoke(obj, null)) != null) {
                    pv = String.valueOf(o);
                }
            }
            catch (Exception e) {
                System.err.println("\u5ba1\u8ba1\u9879\uff1a" + auditModel + "\u901a\u8fc7" + method + "\u6c42\u503c\u51fa\u9519\uff0c" + ExceptionUtil.getMessage(e));
            }
            matcher.appendReplacement(sb, pv);
        }
        matcher.appendTail(sb);
        if (sb.indexOf("@") != -1) {
            return SDK.getRuleAPI().executeAtScript(sb.toString());
        }
        return sb.toString();
    }

    private static String parseRule(RequestContext rc, String s, String ret) {
        if (UtilString.isEmpty(s)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = PARAM_PATTERN.matcher(s);
        while (matcher.find()) {
            String arg = matcher.group(1);
            if (rc.getExchange().getParameters().get(arg) == null) continue;
            matcher.appendReplacement(sb, rc.getExchange().getParameters().get(arg));
        }
        matcher.appendTail(sb);
        String tmp = sb.toString();
        if (ret != null) {
            String t;
            int s2;
            int s1;
            String[] ss;
            int e;
            int b = tmp.indexOf(MAT);
            if (b != -1) {
                e = tmp.indexOf(")", b);
                ss = tmp.substring(b + MAT.length(), e).split(",");
                s1 = ret.indexOf(ss[0]);
                s2 = ret.indexOf(ss[1], s1 + ss[0].length());
                t = ret.substring(s1 + ss[0].length(), s2);
                tmp = String.valueOf(tmp.substring(0, b)) + t + tmp.substring(e + 1);
            }
            if ((b = tmp.indexOf(MAT_1)) != -1) {
                e = tmp.indexOf(")", b);
                ss = tmp.substring(b + MAT_1.length(), e).split(",");
                s1 = ret.indexOf(ss[0]);
                s2 = ret.indexOf(ss[2], s1 + ss[0].length());
                t = ret.substring(s1 + ss[0].length() + Integer.parseInt(ss[1]), s2);
                tmp = String.valueOf(tmp.substring(0, b)) + t + tmp.substring(e + 1);
            }
        }
        if (tmp.indexOf("@") != -1) {
            tmp = SDK.getRuleAPI().executeAtScript(tmp, rc.getUserContext());
        }
        return Auditor.parseRefCache(null, tmp, null);
    }

    private static AuditModel getDaoAuditConf(Class<?> daoImplClass, Class<?> declaringClass, Method method, Object[] args) {
        String sn = daoImplClass.getName();
        List<AuditModel> tmp = daoCache.get(sn.substring(0, sn.indexOf(36)));
        if (UtilString.isEmpty(tmp)) {
            return null;
        }
        for (AuditModel t : tmp) {
            String p = method.getName();
            if (!daoImplClass.getSimpleName().contains(declaringClass.getSimpleName())) {
                p = String.valueOf(declaringClass.getSimpleName()) + "." + p;
            }
            if (t.getMethod().equals(p)) {
                return t;
            }
            if (!t.getMethod().startsWith(String.valueOf(p) + ',')) continue;
            String[] as = t.getMethod().split(",");
            if (as.length > 1 && as[1] != null && as[1].matches("\\d+")) {
                if (args == null || args.length != Integer.parseInt(as[1])) continue;
                return t;
            }
            if (as.length <= 1) continue;
            boolean match = true;
            Class<?>[] cs = method.getParameterTypes();
            if (cs == null) continue;
            int i = 1;
            while (i < as.length - 1) {
                if (!cs[i - 1].getName().contains(as[i])) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            return t;
        }
        return null;
    }

    private static AuditModel getCmdAuditConf(String cmd) {
        return cmdCache.get(cmd);
    }

    public static void reload() {
        File xmlFile = new File("conf/aws-audit.xml");
        if (!xmlFile.exists()) {
            return;
        }
        if (Auditor.changed(xmlFile)) {
            Auditor.setLastModify(xmlFile.lastModified());
            try {
                Auditor.setLgConf(Auditor.load());
                ConsolePrinter.info("\u52a0\u8f7d\u5ba1\u8ba1\u65e5\u5fd7\u914d\u7f6e[conf/aws-audit.xml][\u6210\u529f]");
            }
            catch (Throwable e) {
                ConsolePrinter.err(ExceptionUtil.getMessage(e));
                e.printStackTrace();
            }
        }
    }

    private static AuditConfModel load() throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{AuditConfModel.class});
        AuditConfModel lgConf = (AuditConfModel)ctx.createUnmarshaller().unmarshal(new File("conf/aws-audit.xml"));
        return lgConf;
    }

    public static void main(String[] args) throws JAXBException {
        AuditConfModel m = Auditor.load();
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{AuditConfModel.class});
        ctx.createMarshaller().marshal((Object)m, (OutputStream)System.out);
    }
}

