/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.auditing.dao;

import com.actionsoft.bpms.commons.database.ResultSetHandler;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.database.SqlLobValue;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.ADMINType;
import com.actionsoft.bpms.commons.security.logging.model.Channel;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.sdk.local.SDK;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class LogDao
extends DaoObject<LogModel> {
    public static final String ENTITYNAME = "SYS_AUDIT_LOG";
    private static boolean INFO_CLOB = false;
    private static int INFO_STR_LIN = 2000;

    static {
        try {
            DBSql.query("select OP_INFO from SYS_AUDIT_LOG where id=?", new ResultSetHandler(){

                public void handle(ResultSet rs) throws SQLException {
                    int type = rs.getMetaData().getColumnType(1);
                    INFO_STR_LIN = rs.getMetaData().getPrecision(1);
                    INFO_CLOB = 2005 == type;
                }
            }, "1");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int insert(LogModel model) throws AWSDataAccessException {
        model.setId(UUIDGener.getUUID());
        if (model.getOpTime() == null) {
            model.setOpTime(new Timestamp(new Date().getTime()));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ID", model.getId());
        params.put("LOG_CHANNEL", model.getLogChannel());
        params.put("LOG_CATALOG", model.getLogCatalog());
        params.put("LOG_OBJECT", model.getLogObj());
        params.put("OP", model.getOp());
        if (INFO_CLOB) {
            params.put("OP_INFO", SqlLobValue.getInstance((Object)model.getOpInfo(), (boolean)true));
        } else {
            params.put("OP_INFO", this.trimMax(model.getOpInfo(), INFO_STR_LIN));
        }
        params.put("OP_IP", model.getOpIp());
        params.put("OP_LEVEL", model.getOpLevel());
        params.put("OP_TIME", model.getOpTime());
        params.put("OP_USER", model.getOpUser());
        params.put("EXT1", model.getExt1());
        if (HighSecurity.isON()) {
            String user = null;
            if (DispatcherRequest.getUserContext() != null) {
                user = DispatcherRequest.getUserContext().getUID();
            }
            if (user != null && (Channel.SYSTEM.getId().equals(model.getLogChannel()) || Channel.SECURITY.getId().equals(model.getLogChannel()))) {
                if (HighSecurity.is3PSecAdmin(SDK.getORGAPI().getUserId(user))) {
                    model.setAuditRole(ADMINType.SECADMIN.getType());
                } else if (HighSecurity.is3PAuditor(SDK.getORGAPI().getUserId(user))) {
                    model.setAuditRole(ADMINType.AUDITOR.getType());
                }
            }
        }
        params.put("AUDIT_ROLE", model.getAuditRole());
        String logSummary = String.valueOf(model.getId()) + model.getLogChannel() + model.getLogCatalog() + model.getLogObj() + model.getOp() + model.getOpInfo() + model.getOpIp() + model.getOpLevel() + UtilDate.datetimeFormat(model.getOpTime()) + model.getOpUser() + model.getExt1() + model.getAuditRole();
        params.put("LOG_SUMMARY", MD5.toDigestUTF8(logSummary));
        String sql = DBSql.getInsertStatement(this.entityName(), params);
        try {
            return DBSql.update(sql, params);
        }
        catch (Exception e) {
            System.err.println(e);
            return 0;
        }
    }

    private String trimMax(String s, int len) {
        return s == null ? "" : (s.length() >= len ? String.valueOf(s.substring(0, len - 10)) + "..." : s);
    }

    @Override
    public int update(LogModel model) throws AWSDataAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String entityName() {
        return ENTITYNAME;
    }

    @Override
    public RowMapper<LogModel> rowMapper() {
        return new LogModelMapper();
    }

    private class LogModelMapper
    implements RowMapper<LogModel> {
        private LogModelMapper() {
        }

        public LogModel mapRow(ResultSet rs, int rowNum) throws SQLException {
            LogModel lg = new LogModel();
            lg.setId(rs.getString("ID"));
            lg.setLogChannel(rs.getString("LOG_CHANNEL"));
            lg.setLogCatalog(rs.getString("LOG_CATALOG"));
            lg.setLogObj(rs.getString("LOG_OBJECT"));
            lg.setOp(rs.getString("OP"));
            lg.setOpTime(rs.getTimestamp("OP_TIME"));
            lg.setOpIp(rs.getString("OP_IP"));
            lg.setOpLevel(rs.getInt("OP_LEVEL"));
            lg.setOpUser(rs.getString("OP_USER"));
            lg.setOpInfo(rs.getString("OP_INFO"));
            lg.setExt1(rs.getString("EXT1"));
            lg.setAuditRole(rs.getInt("AUDIT_ROLE"));
            lg.setLogSummary(rs.getString("LOG_SUMMARY"));
            return lg;
        }
    }
}

