/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.console;

import com.actionsoft.apps.lifecycle.log.RoundQueue;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.htmlframework.AlertWindow;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.log.auditing.Auditor;
import com.actionsoft.bpms.commons.log.auditing.constant.AuditConst;
import com.actionsoft.bpms.commons.log.auditing.dao.LogDao;
import com.actionsoft.bpms.commons.log.auditing.model.CatalogModel;
import com.actionsoft.bpms.commons.log.auditing.model.LogModel;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.commons.session.dao.Session;
import com.actionsoft.bpms.commons.session.model.SessionModel;
import com.actionsoft.bpms.form.engine.helper.iae.ImpExpHelper;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.ConfigConst;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.ManagementAPI;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class LogWeb
extends ActionWeb {
    private static int TIME_SEG_TYPE_IN3DAY = 2;
    private static int TIME_SEG_TYPE_INWEEK = 3;
    private static int TIME_SEG_TYPE4_1MONTH = 4;
    private static int TIME_SEG_TYPE4_6MONTH = 5;
    private static int AUDIT_TYPE_AUDIT = 0;
    private static int AUDIT_TYPE_SYS_UPGRADE = 1;
    private static int AUDIT_TYPE_ACCOUNT_LOCK = 2;
    private static int AUDIT_TYPE_ACCESS_UNAUTH = 3;
    private static int AUDIT_TYPE_SESSION = 4;
    private static Map<String, String> OPSTATE = new HashMap<String, String>();

    static {
        OPSTATE.put("downloading", "\u4e0b\u8f7d\u4e2d");
        OPSTATE.put("downloaded", "\u4e0b\u8f7d\u5b8c\u6210");
        OPSTATE.put("planning", "\u51c6\u5907\u5b89\u88c5");
        OPSTATE.put("upgrading", "\u5b89\u88c5\u4e2d");
        OPSTATE.put("upgraded", "\u5df2\u5b89\u88c5");
        OPSTATE.put("deplanning", "\u51c6\u5907\u964d\u7ea7");
        OPSTATE.put("degraded", "\u964d\u7ea7\u5b89\u88c5");
    }

    public LogWeb(UserContext userContext) {
        super(userContext);
    }

    public String genZip() throws Exception {
        DCPluginProfile df = DCProfileManager.getDCProfile("_bpm.platform", "tmp");
        DCContext dc = new DCContext(this.getContext(), df, "_bpm.platform", "logs", UUIDGener.getUUID(), "logs.zip");
        File destZipFile = new File(dc.getFilePath());
        UtilFile.zipCompress(ConfigConst.DIR_LOG_ROOT, destZipFile);
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("url", dc.getDownloadURL());
        return ro.toString();
    }

    public String getWeb() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this.getContext().getSessionId());
        macroLibraries.put("rtLogTypes", this.getRtLogTypes());
        boolean isVisible = true;
        boolean isHighSecurity = false;
        if (HighSecurity.isON()) {
            isHighSecurity = true;
            if (GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || !GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) && !GradeSecurityUtil.isAuditorMaster(this.getContext().getUID())) {
                isVisible = false;
            }
        }
        macroLibraries.put("isVisible", isVisible);
        macroLibraries.put("isHighSecurity", isHighSecurity);
        return this.merge("console.log.main.htm", macroLibraries);
    }

    private String getRtLogTypes() {
        File root = new File(ConfigConst.DIR_LOG_ROOT);
        HashSet<String> types = new HashSet<String>();
        String[] fns = root.list();
        Arrays.sort(fns, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        String[] stringArray = fns;
        int n = fns.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            if (fn.indexOf(".log") != -1) {
                fn = fn.substring(0, fn.indexOf(".log"));
                boolean typeExist = false;
                for (String t : types) {
                    if (!fn.startsWith(t)) continue;
                    typeExist = true;
                }
                if (!typeExist) {
                    types.add(fn);
                }
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (String type : types) {
            sb.append("<li><div id='" + type + "'>" + type + "</div></li>");
        }
        return sb.toString();
    }

    public String getAudit() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        String showCartogramBtn = "";
        if (HighSecurity.isON()) {
            if (GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || !GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) && !GradeSecurityUtil.isAuditorMaster(this.getContext().getUID())) {
                return AlertWindow.getAuthorityMessagePage("\u5185\u5bb9\u6682\u65f6\u65e0\u6cd5\u8bbf\u95ee", "\u6743\u9650\u4e0d\u591f");
            }
            if (GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) || GradeSecurityUtil.isAuditorMaster(this.getContext().getUID())) {
                showCartogramBtn = "<input type='button'  class='button blue' value=\"\u62a5\u8868\" onclick=\"showCartogram();\">";
            }
        }
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("sessionId", this.getContext().getSessionId());
        macroLibraries.put("catalog", this.getCatalogs());
        macroLibraries.put("showCartogramBtn", showCartogramBtn);
        return this.merge("console.log.audit.htm", macroLibraries);
    }

    private String getCatalogs() {
        StringBuilder sb = new StringBuilder();
        sb.append("<option value=''>\u5168\u90e8</option>");
        sb.append("<optgroup label=\"\u2014\u2014\u4e13\u9879\u5ba1\u8ba1\u2014\u2014\"></optgroup>");
        sb.append("<option value='audit-1'>\u5e73\u53f0\u5347\u7ea7</option>");
        sb.append("<option value='audit-2'>\u8d26\u6237\u51bb\u7ed3</option>");
        sb.append("<option value='audit-3'>\u8d8a\u6743\u8bbf\u95ee</option>");
        sb.append("<option value='audit-4'>\u7528\u6237\u767b\u5f55</option>");
        List<CatalogModel> catalogs = Auditor.getLgConf().getCatalogs();
        String group = "";
        for (CatalogModel c : catalogs) {
            String tmp = c.getChannel();
            if (!tmp.equals(group)) {
                String s = AuditConst.getChannelI18N(tmp);
                sb.append("<optgroup label=\"\u2014\u2014" + s + "\u2014\u2014\"></optgroup>");
                group = tmp;
            }
            sb.append("<option value='" + c.getId() + "'>" + AuditConst.getCatalogI18N(c.getId()) + "</option>");
        }
        return sb.toString();
    }

    private ResponseObject getAuditDataResponseObject(String q, String currentPage, String limitStr) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.put("curPage", currentPage);
        int start = Integer.valueOf(currentPage) == 0 ? 1 : Integer.valueOf(currentPage);
        int limit = Integer.valueOf(limitStr);
        start = (start - 1) * limit;
        JSONObject Q = UtilSerialize.parseObject(q);
        this.queryDataByAuditType(Q, start, limit, responseObject);
        return responseObject;
    }

    public String getAuditData(String q, String currentPage, String limitStr) {
        return this.getAuditDataResponseObject(q, currentPage, limitStr).toString();
    }

    public String getAuditDataExport(String q, String currentPage, String limitStr) {
        ResponseObject responseObject = this.getAuditDataResponseObject(q, currentPage, limitStr);
        Object datas = responseObject.get("data");
        if (datas != null) {
            try {
                List dataList = (List)datas;
                SXSSFWorkbook wb = new SXSSFWorkbook(10000);
                Row row = null;
                Object cell = null;
                SXSSFSheet sheet = wb.createSheet();
                XSSFCellStyle headStyle = this.creatHeadStyle(wb, "left");
                XSSFCellStyle headStyleC = this.creatHeadStyle(wb, "center");
                XSSFCellStyle cellStyleC = this.creatCellStyle(wb, "center", "normal");
                XSSFCellStyle cellStyleCB = this.creatCellStyle(wb, "center", "blue");
                XSSFCellStyle cellStyleCY = this.creatCellStyle(wb, "center", "yellow");
                XSSFCellStyle cellStyleCR = this.creatCellStyle(wb, "center", "red");
                XSSFCellStyle cellStyle = this.creatCellStyle(wb, "left", "normal");
                row = sheet.createRow(0);
                row.setHeight((short)500);
                this.createCell((Sheet)sheet, row, 0, headStyleC, 2000, I18nRes.findValue("_bpm.platform", "\u7ea7\u522b"));
                this.createCell((Sheet)sheet, row, 1, headStyle, 8000, I18nRes.findValue("_bpm.platform", "\u4e3b\u4f53"));
                this.createCell((Sheet)sheet, row, 2, headStyleC, 6000, I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u65f6\u95f4"));
                this.createCell((Sheet)sheet, row, 3, headStyle, 5000, I18nRes.findValue("_bpm.platform", "\u5730\u70b9"));
                this.createCell((Sheet)sheet, row, 4, headStyle, 5000, I18nRes.findValue("_bpm.platform", "\u5206\u7c7b"));
                this.createCell((Sheet)sheet, row, 5, headStyle, 7000, I18nRes.findValue("_bpm.platform", "\u5ba2\u4f53"));
                this.createCell((Sheet)sheet, row, 6, headStyle, 5000, I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c"));
                this.createCell((Sheet)sheet, row, 7, headStyle, 20000, I18nRes.findValue("_bpm.platform", "\u4fe1\u606f"));
                int k = 0;
                int sizek = dataList.size();
                while (k < sizek) {
                    Map data = (Map)dataList.get(k);
                    int level = -1;
                    if (!UtilString.isEmpty(data.get("level"))) {
                        level = (Integer)data.get("level");
                    }
                    String source = (String)data.get("source");
                    String sourceTitle = (String)data.get("sourceTitle");
                    String date = (String)data.get("date");
                    String ip = (String)data.get("ip");
                    String auditObject = (String)data.get("auditObject");
                    String info = (String)data.get("info");
                    String catalog = (String)data.get("catalog");
                    String op = (String)data.get("op");
                    row = sheet.createRow(k + 1);
                    row.setHeight((short)375);
                    if (level == -1) {
                        this.createCell(row, 0, cellStyleCB, "");
                    } else if (level == 5) {
                        this.createCell(row, 0, cellStyleCB, I18nRes.findValue("_bpm.platform", "\u666e\u901a"));
                    } else if (level == 7) {
                        this.createCell(row, 0, cellStyleCY, I18nRes.findValue("_bpm.platform", "\u8b66\u544a"));
                    } else if (level == 9) {
                        this.createCell(row, 0, cellStyleCR, I18nRes.findValue("_bpm.platform", "\u9519\u8bef"));
                    }
                    this.createCell(row, 1, cellStyle, UtilString.isEmpty(sourceTitle) ? source : String.valueOf(sourceTitle) + "<" + source + ">");
                    this.createCell(row, 2, cellStyleC, date);
                    this.createCell(row, 3, cellStyle, ip);
                    this.createCell(row, 4, cellStyle, catalog);
                    this.createCell(row, 5, cellStyle, auditObject);
                    this.createCell(row, 6, cellStyle, op);
                    this.createCell(row, 7, cellStyle, info);
                    ++k;
                }
                DCContext dc = ImpExpHelper.createExcel2007TmpFile((SXSSFWorkbook)wb, (String)"_bpm.platform");
                dc.setSession(this.getContext());
                DCPluginProfile dcProfile = SDK.getDCAPI().getDCProfile("_bpm.platform", "tmp");
                if (dcProfile == null) {
                    throw new AWSException("Not Find DCProfile! repositoryName=tmp");
                }
                dc.setDCProfile(dcProfile);
                String auditObject = "\u65e5\u5fd7\u6587\u4ef6\u540d\u79f0\uff1a" + dc.getFileName();
                String logInfo = "\u65e5\u5fd7\u5bfc\u51fa\u8def\u5f84\uff1a" + dc.getFilePath();
                SDK.getLogAPI().auditClient("client", this.getContext().getUID(), AuditConst.getOpI18N("\u5bfc\u51fa"), auditObject, logInfo, this.getContext().getClientIP(), Level.INFO);
                return ResponseObject.newOkResponse(dc.getDownloadURL()).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return ResponseObject.newErrResponse(e.getMessage()).toString();
            }
        }
        return ResponseObject.newErrResponse().toString();
    }

    private void createCell(Row row, int index, XSSFCellStyle style, String value) {
        this.createCell(null, row, index, style, null, value);
    }

    private void createCell(Sheet sheet, Row row, int index, XSSFCellStyle style, Integer w, String value) {
        Cell cell = row.createCell(index);
        if (w != null) {
            sheet.setColumnWidth(index, w.intValue());
        }
        cell.setCellStyle((CellStyle)style);
        cell.setCellValue(value);
    }

    private XSSFCellStyle creatHeadStyle(SXSSFWorkbook wb, String align) {
        XSSFCellStyle cellStyle = this.creatCellStyle(wb, align, "normal");
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font hf = wb.createFont();
        hf.setFontHeightInPoints((short)12);
        hf.setBold(true);
        cellStyle.setFont(hf);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        return cellStyle;
    }

    private XSSFCellStyle creatCellStyle(SXSSFWorkbook wb, String align, String color) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        if ("center".equals(align)) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        } else if ("left".equals(align)) {
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        } else {
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        if ("red".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor((short)10);
            cellStyle.setFont(hf);
        } else if ("blue".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor(HSSFColor.BLUE.index);
            cellStyle.setFont(hf);
        } else if ("yellow".equals(color)) {
            Font hf = wb.createFont();
            hf.setColor(HSSFColor.YELLOW.index);
            cellStyle.setFont(hf);
        }
        return cellStyle;
    }

    private void queryDataByAuditType(JSONObject Q, int start, int limit, ResponseObject responseObject) {
        String sql;
        String c_sql;
        if (HighSecurity.isON() && (GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || !GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) && !GradeSecurityUtil.isAuditorMaster(this.getContext().getUID()))) {
            responseObject.err("\u65e0\u6743\u9650");
            return;
        }
        int audittype = Q.getIntValue("audittype");
        if (audittype == AUDIT_TYPE_AUDIT || audittype == AUDIT_TYPE_ACCOUNT_LOCK || audittype == AUDIT_TYPE_ACCESS_UNAUTH) {
            c_sql = "select count(id) from SYS_AUDIT_LOG";
            Object[] c_params = new Object[]{};
            String sqlWhere = null;
            Object[] ps = null;
            Object[] rets = this.getQuery(Q, audittype);
            List sql2 = (List)rets[0];
            List params = (List)rets[1];
            if (sql2.size() > 0) {
                sqlWhere = UtilString.join(sql2, " AND ");
            }
            if (HighSecurity.isON()) {
                String users = "admin";
                String sqlInStr = " op_user NOT IN( ? ";
                if (HighSecurity.is3PSecAdmin(this.getContext())) {
                    users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSysAdmin();
                    users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSecAdmin();
                } else if (HighSecurity.is3PAuditor(this.getContext())) {
                    users = "";
                    users = String.valueOf(users) + HighSecurity.getSecModel().getSysAdmin();
                    users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSecAdmin();
                    sqlInStr = " op_user IN( ? ";
                }
                if (UtilString.isNotEmpty(users)) {
                    String[] userArray = users.split(" ");
                    boolean needEnd = false;
                    int i = 0;
                    int size_i = userArray.length;
                    while (i < size_i) {
                        String user = userArray[i];
                        if (!UtilString.isEmpty(user)) {
                            if (i == 0) {
                                sqlWhere = UtilString.isEmpty(sqlWhere) ? "" : String.valueOf(sqlWhere) + " AND";
                                sqlWhere = String.valueOf(sqlWhere) + sqlInStr;
                            } else {
                                sqlWhere = String.valueOf(sqlWhere) + ",?";
                            }
                            params.add(user);
                            needEnd = true;
                        }
                        ++i;
                    }
                    if (needEnd) {
                        sqlWhere = String.valueOf(sqlWhere) + ") ";
                    }
                }
            }
            ps = params.toArray();
            if (sqlWhere != null) {
                c_sql = String.valueOf(c_sql) + " where " + sqlWhere;
                c_params = ps;
            }
            int c = DBSql.getInt(c_sql, c_params);
            List list = null;
            list = sqlWhere != null ? new LogDao().query(sqlWhere, ps).orderBy("op_time").desc().list(start, limit) : new LogDao().query().orderBy("op_time").desc().list(start, limit);
            ArrayList<Object> datas = new ArrayList<Object>();
            boolean chkLog = false;
            if (limit != 10) {
                chkLog = true;
            }
            for (LogModel lm : list) {
                datas.add(this.toDisplayModel(lm, audittype, chkLog));
            }
            List<Object> userLogList = new ArrayList();
            String opUsers = "";
            String opUserUnqids = "";
            Calendar cal = Calendar.getInstance();
            Object date = null;
            Object[] paraMap = new Object[]{};
            try {
                int day = cal.get(5);
                cal.set(5, day - 6);
                String string = new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
                paraMap = new Object[]{new SimpleDateFormat("yyyy-MM-dd").parse(string)};
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            String searchStrt = "OP_INFO like '%\u53e3\u4ee4\u6821\u9a8c\u4fe1\u606f\u5339\u914d\u9519\u8bef%' AND OP_TIME>=?";
            userLogList = new LogDao().query(searchStrt, paraMap).orderBy("op_time").desc().list(0, 3);
            for (LogModel logModel : userLogList) {
                opUsers = String.valueOf(opUsers) + "[" + logModel.getOpUser() + "],";
                opUserUnqids = String.valueOf(opUserUnqids) + logModel.getId() + ",";
            }
            if (opUsers.length() > 0) {
                opUsers = opUsers.substring(0, opUsers.length() - 1);
                opUserUnqids = opUserUnqids.substring(0, opUserUnqids.length());
            }
            responseObject.put("opUsers", opUsers);
            responseObject.put("opUserUnqids", opUserUnqids);
            responseObject.put("totalRecords", c);
            responseObject.put("data", datas);
        } else if (audittype == AUDIT_TYPE_SYS_UPGRADE) {
            c_sql = "select count(id) from SYS_PATCH";
            sql = "select * from SYS_PATCH order by OPDATE desc";
            List<RowMap> list = DBSql.getMaps(sql, new Object[0]);
            ArrayList<Object> datas = new ArrayList<Object>();
            for (RowMap lm : list) {
                datas.add(this.toDisplayModel(lm, audittype, true));
            }
            responseObject.put("totalRecords", DBSql.getInt(c_sql, new Object[0]));
            responseObject.put("data", datas);
        } else if (audittype == AUDIT_TYPE_SESSION) {
            c_sql = "select count(sessionid) from " + SessionModel.DATABASE_ENTITY;
            sql = "select * from " + SessionModel.DATABASE_ENTITY + " ";
            Object[] rets = this.getQuery(Q, audittype);
            List wsql = (List)rets[0];
            List params = (List)rets[1];
            Object[] ps = new Object[]{};
            if (wsql.size() > 0) {
                sql = String.valueOf(sql) + " where " + UtilString.join(wsql, " AND ");
                c_sql = String.valueOf(c_sql) + " where " + UtilString.join(wsql, " AND ");
            }
            if (HighSecurity.isON()) {
                String[] userArr;
                String users = "";
                if (HighSecurity.is3PAuditor(this.getContext())) {
                    users = HighSecurity.getSecModel().getSysAdmin();
                    users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSecAdmin();
                }
                if ((userArr = users.split(" ")).length > 0) {
                    if (wsql.size() > 0) {
                        sql = String.valueOf(sql) + " AND USERID IN(";
                        c_sql = String.valueOf(c_sql) + " AND USERID IN(";
                    } else {
                        sql = String.valueOf(sql) + " WHERE USERID IN(";
                        c_sql = String.valueOf(c_sql) + " WHERE USERID IN(";
                    }
                    int k = 0;
                    while (k < userArr.length) {
                        sql = String.valueOf(sql) + "?,";
                        c_sql = String.valueOf(c_sql) + "?,";
                        params.add(userArr[k]);
                        ++k;
                    }
                    sql = String.valueOf(sql.substring(0, sql.length() - 1)) + ")";
                    c_sql = String.valueOf(c_sql.substring(0, c_sql.length() - 1)) + ")";
                }
            }
            ps = params.toArray();
            sql = String.valueOf(sql) + " order by STARTTIME desc ";
            sql = SQLPagination.getPaginitionSQL(sql, start, limit);
            List<SessionModel> list = DBSql.query(sql, new Session.SessionModelMapper(), ps);
            ArrayList<Object> datas = new ArrayList<Object>();
            for (SessionModel lm : list) {
                datas.add(this.toDisplayModel(lm, audittype, true));
            }
            responseObject.put("totalRecords", DBSql.getInt(c_sql, ps));
            responseObject.put("data", datas);
        }
        if (HighSecurity.isON()) {
            String auditObject = "\u5ba1\u8ba1\u65e5\u5fd7";
            String logInfo = String.valueOf(this.getContext().getUserName()) + "\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7";
            SDK.getLogAPI().auditClient("access", this.getContext().getUID(), "access", auditObject, logInfo, this.getContext().getClientIP(), Level.INFO);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void getLogDataByGroup(JSONObject Q, ResponseObject responseObject) {
        String[] legned;
        if (HighSecurity.isON() && (GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || !GradeSecurityUtil.isSecurityMaster(this.getContext().getUID()) && !GradeSecurityUtil.isAuditorMaster(this.getContext().getUID()))) {
            responseObject.err("\u65e0\u6743\u9650");
            return;
        }
        String sessionsql = "select count(sessionid) from SYS_SESSION";
        Object[] srets = this.getQuery(Q, 4);
        List swsql = (List)srets[0];
        List sparams = (List)srets[1];
        if (swsql.size() > 0) {
            sessionsql = String.valueOf(sessionsql) + " where " + UtilString.join(swsql, " AND ");
        }
        if (HighSecurity.isON()) {
            String[] suserArr;
            String susers = "";
            if (HighSecurity.is3PAuditor(this.getContext())) {
                susers = HighSecurity.getSecModel().getSysAdmin();
                susers = String.valueOf(susers) + " " + HighSecurity.getSecModel().getSecAdmin();
            }
            if ((suserArr = susers.split(" ")).length > 0) {
                sessionsql = swsql.size() > 0 ? String.valueOf(sessionsql) + " AND USERID IN(" : String.valueOf(sessionsql) + " WHERE USERID IN(";
                int k = 0;
                while (k < suserArr.length) {
                    sessionsql = String.valueOf(sessionsql) + "?,";
                    sparams.add(suserArr[k]);
                    ++k;
                }
                sessionsql = String.valueOf(sessionsql.substring(0, sessionsql.length() - 1)) + ")";
            }
        }
        List<Map<String, String>> list = this.commonGetData(Q, "");
        String[] lvArr = new String[]{"lv5", "lv7", "lv9"};
        JSONArray lvjsonArr = new JSONArray();
        String[] stringArray = lvArr;
        int n = lvArr.length;
        int n2 = 0;
        while (n2 < n) {
            String lv = stringArray[n2];
            List<Map<String, String>> lvList = this.commonGetData(Q, lv);
            for (Map<String, String> map : lvList) {
                JSONObject lvobj = new JSONObject();
                if ("lv5".equals(lv)) {
                    lvobj.put("name", (Object)"\u666e\u901a\u65e5\u5fd7");
                } else if ("lv7".equals(lv)) {
                    lvobj.put("name", (Object)"\u8b66\u544a\u65e5\u5fd7");
                } else if ("lv9".equals(lv)) {
                    lvobj.put("name", (Object)"\u9519\u8bef\u65e5\u5fd7");
                }
                lvobj.put("value", (Object)Integer.valueOf(map.get(lv)));
                lvjsonArr.add((Object)lvobj);
            }
            ++n2;
        }
        responseObject.put("cartogramLvData", lvjsonArr);
        HashMap<Object, Integer> initMap = new HashMap<Object, Integer>();
        String[] stringArray2 = legned = new String[]{"\u5e73\u53f0\u5347\u7ea7", "\u8d26\u6237\u51bb\u7ed3", "\u8d8a\u6743\u8bbf\u95ee", "\u7528\u6237\u4f1a\u8bdd", "\u7ec4\u7ec7\u670d\u52a1", "\u4e1a\u52a1\u5efa\u6a21", "\u8c03\u5ea6\u670d\u52a1", "\u8fde\u63a5\u670d\u52a1", "\u8fd0\u884c\u7ba1\u7406", "\u5e94\u7528\u7ba1\u7406", "\u5bfc\u822a\u670d\u52a1", "\u5de5\u5177\u9644\u52a0", "\u65e5\u5fd7\u5ba1\u8ba1", "\u9644\u4ef6\u4e0a\u4f20", "\u5de5\u4f5c\u53f0"};
        int lvList = legned.length;
        int n3 = 0;
        while (n3 < lvList) {
            String item = stringArray2[n3];
            initMap.put(item, 0);
            ++n3;
        }
        for (Map<String, String> map3 : list) {
            void var15_44;
            String typeName = map3.get("logcatalog");
            String string = "";
            if ("freeze".equals(typeName)) {
                String string2 = "\u8d26\u6237\u51bb\u7ed3";
            } else if ("unauthorized".equals(typeName)) {
                String string3 = "\u8d8a\u6743\u8bbf\u95ee";
            } else if (typeName.indexOf("org") == 0) {
                String string4 = "\u7ec4\u7ec7\u670d\u52a1";
            } else if ("job".equals(typeName)) {
                String string5 = "\u8c03\u5ea6\u670d\u52a1";
            } else if (typeName.indexOf("model") == 0) {
                String string6 = "\u4e1a\u52a1\u5efa\u6a21";
            } else if (typeName.indexOf("cc") == 0) {
                String string7 = "\u8fde\u63a5\u670d\u52a1";
            } else if (typeName.indexOf("prm") == 0) {
                String string8 = "\u8fd0\u884c\u7ba1\u7406";
            } else if (typeName.indexOf("amc") == 0) {
                String string9 = "\u5e94\u7528\u7ba1\u7406";
            } else if (typeName.indexOf("nav") == 0) {
                String string10 = "\u5bfc\u822a\u670d\u52a1";
            } else if (typeName.indexOf("addnos") == 0) {
                String string11 = "\u5de5\u5177\u9644\u52a0";
            } else if (typeName.indexOf("audit") == 0) {
                String string12 = "\u65e5\u5fd7\u5ba1\u8ba1";
            } else if (typeName.indexOf("security") == 0) {
                String string13 = "security";
            } else if (typeName.indexOf("A10") == 0) {
                String string14 = "\u9644\u4ef6\u4e0a\u4f20";
            } else if (typeName.indexOf("CO1") == 0) {
                String string15 = "\u5de5\u4f5c\u53f0";
            } else {
                String string16 = "\u5176\u4ed6";
            }
            if (initMap.containsKey(var15_44)) {
                int currNum = (Integer)initMap.get(var15_44);
                int newNum = currNum + Integer.valueOf(map3.get("lognum"));
                initMap.put(var15_44, newNum);
                continue;
            }
            initMap.put(var15_44, Integer.valueOf(map3.get("lognum")));
        }
        JSONArray cartoggramData = new JSONArray();
        for (String key : initMap.keySet()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("value", initMap.get(key));
            jSONObject.put("name", (Object)key);
            cartoggramData.add((Object)jSONObject);
        }
        JSONObject patchObj = new JSONObject();
        String patchsql = "select count(id) from SYS_PATCH";
        int n4 = DBSql.getInt(patchsql, new Object[0]);
        patchObj.put("value", (Object)n4);
        patchObj.put("name", (Object)"\u5e73\u53f0\u5347\u7ea7");
        cartoggramData.add((Object)patchObj);
        JSONObject sessionObj = new JSONObject();
        int sessionNum = DBSql.getInt(sessionsql, sparams.toArray());
        sessionObj.put("value", (Object)sessionNum);
        sessionObj.put("name", (Object)"\u7528\u6237\u4f1a\u8bdd");
        cartoggramData.add((Object)sessionObj);
        String currDate = UtilDate.dateFormat(UtilDate.getCalendar().getTime());
        String logtime = "";
        String startTime = Q.getString("startTime");
        String endTime = Q.getString("endTime");
        logtime = UtilString.isEmpty(startTime) ? (UtilString.isEmpty(endTime) ? "\uff08" + currDate + "\u53ca\u4e4b\u524d\uff09" : "\uff08" + endTime + "\u53ca\u4e4b\u524d\uff09") : (UtilString.isEmpty(endTime) ? "\uff08" + startTime + "\u81f3" + currDate + "\uff09" : "\uff08" + startTime + "\u81f3" + endTime + "\uff09");
        responseObject.put("logtime", logtime);
        responseObject.put("cartoggramData", cartoggramData);
    }

    private List<Map<String, String>> commonGetData(JSONObject Q, String type) {
        String c_sql = "select LOG_CATALOG AS logcatalog ,count(id) AS lognum from SYS_AUDIT_LOG";
        if (!UtilString.isEmpty(type)) {
            if ("lv5".equals(type)) {
                Q.put("lv", (Object)"5");
            } else if ("lv7".equals(type)) {
                Q.put("lv", (Object)"7");
            } else if ("lv9".equals(type)) {
                Q.put("lv", (Object)"9");
            }
            c_sql = "select count(id) from SYS_AUDIT_LOG";
        }
        Object[] ps = null;
        String sqlWhere = null;
        Object[] rets = this.getQuery(Q, 0);
        List sql = (List)rets[0];
        List params = (List)rets[1];
        if (sql.size() > 0) {
            sqlWhere = UtilString.join(sql, " AND ");
        }
        if (HighSecurity.isON()) {
            String users = "admin";
            String sqlInStr = " op_user NOT IN( ? ";
            if (HighSecurity.is3PSecAdmin(this.getContext())) {
                users = String.valueOf(users) + " " + this.getContext().getUID();
                users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSysAdmin();
            } else if (HighSecurity.is3PAuditor(this.getContext())) {
                users = "";
                users = String.valueOf(users) + HighSecurity.getSecModel().getSysAdmin();
                users = String.valueOf(users) + " " + HighSecurity.getSecModel().getSecAdmin();
                sqlInStr = " op_user IN( ? ";
            }
            if (UtilString.isNotEmpty(users)) {
                String[] userArray = users.split(" ");
                boolean needEnd = false;
                int i = 0;
                int size_i = userArray.length;
                while (i < size_i) {
                    String user = userArray[i];
                    if (!UtilString.isEmpty(user)) {
                        if (i == 0) {
                            sqlWhere = UtilString.isEmpty(sqlWhere) ? "" : String.valueOf(sqlWhere) + " AND";
                            sqlWhere = String.valueOf(sqlWhere) + sqlInStr;
                        } else {
                            sqlWhere = String.valueOf(sqlWhere) + ",?";
                        }
                        params.add(user);
                        needEnd = true;
                    }
                    ++i;
                }
                if (needEnd) {
                    sqlWhere = String.valueOf(sqlWhere) + ") ";
                }
            }
        }
        ps = params.toArray();
        if (sqlWhere != null) {
            c_sql = String.valueOf(c_sql) + " where " + sqlWhere;
        }
        ArrayList<Map<String, String>> list = new ArrayList();
        if (UtilString.isEmpty(type)) {
            c_sql = String.valueOf(c_sql) + " GROUP BY LOG_CATALOG";
            list = DBSql.query(c_sql, new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int i) throws SQLException {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("logcatalog", rs.getString("logcatalog"));
                    item.put("lognum", String.valueOf(rs.getInt("lognum")));
                    return item;
                }
            }, ps);
        } else {
            int lvNum = DBSql.getInt(c_sql, ps);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(type, String.valueOf(lvNum));
            list.add(map);
        }
        return list;
    }

    private int getMondayPlus() {
        Calendar cd = Calendar.getInstance();
        int dayOfWeek = cd.get(7) - 1;
        if (dayOfWeek == 1) {
            return 0;
        }
        return 1 - dayOfWeek;
    }

    private void setUserTitle(Map m, String opUser) {
        UserModel um;
        if (UtilString.isNotEmpty(opUser) && (um = UserCache.getModel((String)opUser.trim())) != null) {
            m.put("sourceTitle", um.getUserName());
        }
    }

    private Object toDisplayModel(Object tpm, int audittype, boolean chkLog) {
        if (audittype == AUDIT_TYPE_AUDIT || audittype == AUDIT_TYPE_ACCESS_UNAUTH || audittype == AUDIT_TYPE_ACCOUNT_LOCK) {
            LogModel lm = (LogModel)tpm;
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("id", lm.getId());
            m.put("level", lm.getOpLevel());
            m.put("source", lm.getOpUser());
            this.setUserTitle(m, lm.getOpUser());
            m.put("date", UtilDate.datetimeFormat(lm.getOpTime()));
            m.put("ip", lm.getOpIp());
            m.put("auditObject", SDK.getRuleAPI().executeAtScript(lm.getLogObj()));
            m.put("info", lm.getOpInfo());
            m.put("catalog", AuditConst.getCatalogI18N(lm.getLogCatalog()));
            m.put("op", AuditConst.getOpI18N(lm.getOp()));
            if (HighSecurity.isON() && chkLog) {
                if ("org.user".equals(lm.getLogCatalog()) && "reset".equals(lm.getOp())) {
                    m.put("isDistrotLog", true);
                    m.put("warnMsg", "\u7528\u6237[" + lm.getLogObj() + "]\u53e3\u4ee4\u6821\u9a8c\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u6838\u5b9e\u662f\u5426\u672c\u4eba\u64cd\u4f5c");
                } else {
                    m.put("isDistrotLog", lm.checkLogDistort());
                }
            } else {
                m.put("isDistrotLog", false);
            }
            return m;
        }
        if (audittype == AUDIT_TYPE_SYS_UPGRADE) {
            RowMap lm = (RowMap)tpm;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("level", "");
            m.put("source", "");
            m.put("date", UtilDate.datetimeFormat(lm.getDate("OPDATE")));
            m.put("ip", "");
            m.put("auditObject", lm.getString("VERSIONID"));
            m.put("info", "\u64cd\u4f5c\u72b6\u6001\uff1a" + OPSTATE.get(lm.getString("OPSTATE")) + "\uff0c" + (lm.getInt("ISDEGRADE") == 1 ? "\u652f\u6301\u964d\u7ea7" : "\u4e0d\u652f\u6301\u964d\u7ea7") + "\uff0c" + (lm.getInt("RELEASETYPE") == 1 ? "\u6b63\u5f0f\u7248" : "\u9884\u89c8\u7248"));
            m.put("catalog", "\u5e73\u53f0\u5347\u7ea7");
            return m;
        }
        if (audittype == AUDIT_TYPE_SESSION) {
            SessionModel lm = (SessionModel)tpm;
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("level", "");
            m.put("source", lm.getUid());
            this.setUserTitle(m, lm.getUid());
            m.put("date", UtilDate.datetimeFormat(new Date(lm.getStartTime())));
            m.put("ip", lm.getIp());
            m.put("auditObject", "\u4f1a\u8bddID\uff1a" + lm.getSessionId());
            JSONObject jo = new JSONObject();
            if (!lm.isClosed()) {
                jo.put("closed", (Object)lm.isClosed());
            }
            if (lm.isSdk()) {
                jo.put("sdk", (Object)lm.isSdk());
            }
            jo.put("scope", (Object)lm.getSessionScope());
            jo.put("deviceType", (Object)lm.getDeviceType().toUpperCase());
            jo.put("refreshTime", (Object)UtilDate.datetimeFormat(new Date(lm.getRefreshTime())));
            m.put("info", jo.toString());
            m.put("catalog", "\u7528\u6237\u4f1a\u8bdd");
            return m;
        }
        return null;
    }

    private Object[] getQuery(JSONObject Q, int audittype) {
        ArrayList<String> sql = new ArrayList<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        if (Q.getString("startTime") != null || Q.getString("endTime") != null) {
            String startTime = Q.getString("startTime");
            String endTime = Q.getString("endTime");
            if (audittype == AUDIT_TYPE_AUDIT || audittype == AUDIT_TYPE_ACCOUNT_LOCK || audittype == AUDIT_TYPE_ACCESS_UNAUTH) {
                if (!UtilString.isEmpty(startTime)) {
                    try {
                        sql.add("op_time>=? ");
                        params.add(new SimpleDateFormat("yy-MM-dd").parse(startTime));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!UtilString.isEmpty(endTime)) {
                    Calendar c = Calendar.getInstance();
                    Date date = null;
                    try {
                        date = new SimpleDateFormat("yy-MM-dd").parse(endTime);
                        c.setTime(date);
                        int day = c.get(5);
                        c.set(5, day + 1);
                        String dayAfter = new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
                        sql.add("op_time<=? ");
                        params.add(new SimpleDateFormat("yyyy-MM-dd").parse(dayAfter));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                sql.add("LOG_CHANNEL<>? ");
                params.add("APP");
            } else if (audittype == AUDIT_TYPE_SESSION && startTime != null) {
                try {
                    sql.add(" STARTTIME>=? ");
                    params.add(new SimpleDateFormat("yy-MM-dd").parse(startTime));
                }
                catch (ParseException c) {
                    // empty catch block
                }
            }
        }
        if (!UtilString.isEmpty(Q.get((Object)"user"))) {
            if (audittype == AUDIT_TYPE_AUDIT || audittype == AUDIT_TYPE_ACCOUNT_LOCK || audittype == AUDIT_TYPE_ACCESS_UNAUTH) {
                sql.add(" op_user=?  ");
                params.add(Q.getString("user"));
            } else if (audittype == AUDIT_TYPE_SESSION) {
                sql.add(" userid=?  ");
                params.add(Q.getString("user"));
            }
        }
        if (!(UtilString.isEmpty(Q.get((Object)"auditobj")) || audittype != AUDIT_TYPE_AUDIT && audittype != AUDIT_TYPE_ACCOUNT_LOCK && audittype != AUDIT_TYPE_ACCESS_UNAUTH)) {
            sql.add(" log_object like ?  ");
            params.add("%" + Q.getString("auditobj") + "%");
        }
        if (!(UtilString.isEmpty(Q.get((Object)"info")) || audittype != AUDIT_TYPE_AUDIT && audittype != AUDIT_TYPE_ACCOUNT_LOCK && audittype != AUDIT_TYPE_ACCESS_UNAUTH)) {
            sql.add(" op_info like ?  ");
            params.add("%" + Q.getString("info") + "%");
        }
        if (!UtilString.isEmpty(Q.get((Object)"ip"))) {
            if (audittype == AUDIT_TYPE_AUDIT || audittype == AUDIT_TYPE_ACCOUNT_LOCK || audittype == AUDIT_TYPE_ACCESS_UNAUTH) {
                sql.add(" op_ip like ?  ");
                params.add("%" + Q.getString("ip") + "%");
            } else if (audittype == AUDIT_TYPE_SESSION) {
                sql.add(" ip like ?  ");
                params.add("%" + Q.getString("ip") + "%");
            }
        }
        if (!UtilString.isEmpty(Q.get((Object)"catalog"))) {
            if (audittype == AUDIT_TYPE_AUDIT) {
                if ("job".equals(Q.getString("catalog"))) {
                    sql.add(" LOG_CHANNEL=?  ");
                    sql.add(" log_catalog=?  ");
                    params.add("SYSTEM");
                    params.add(Q.getString("catalog"));
                } else {
                    sql.add(" log_catalog like ?  ");
                    params.add(String.valueOf(Q.getString("catalog")) + "%");
                }
            } else if (audittype == AUDIT_TYPE_ACCOUNT_LOCK) {
                sql.add(" LOG_CHANNEL=?  ");
                sql.add(" log_catalog=?  ");
                params.add("SECURITY");
                params.add("freeze");
            } else if (audittype == AUDIT_TYPE_ACCESS_UNAUTH) {
                sql.add(" LOG_CHANNEL=?  ");
                sql.add(" log_catalog=?  ");
                params.add("SECURITY");
                params.add("unauthorized");
            }
        }
        if (!(UtilString.isEmpty(Q.get((Object)"lv")) || audittype != AUDIT_TYPE_AUDIT && audittype != AUDIT_TYPE_ACCOUNT_LOCK && audittype != AUDIT_TYPE_ACCESS_UNAUTH)) {
            String str = Q.getString("lv");
            String[] lvs = str.split(",");
            if (lvs.length == 1) {
                sql.add(" op_level=?  ");
                params.add(Integer.parseInt(lvs[0]));
            } else if (lvs.length == 2) {
                int[] is;
                sql.add(" op_level<>?  ");
                int[] nArray = is = new int[]{5, 7, 9};
                int n = is.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    if (str.indexOf(Integer.toString(i)) == -1) {
                        params.add(i);
                    }
                    ++n2;
                }
            }
        }
        return new Object[]{sql, params};
    }

    private String getTypeDefFile(String type, File[] list) {
        String defFile = null;
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(type)) {
                if (defFile == null) {
                    defFile = file.getName();
                } else if (defFile.length() > file.getName().length()) {
                    defFile = file.getName();
                }
            }
            ++n2;
        }
        return defFile;
    }

    private String listFile(String excludeFile, String type, File[] list) {
        Arrays.sort(list, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                if (o1.getName().length() != o2.getName().length()) {
                    return o1.getName().length() - o2.getName().length();
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append("<select id='logfs'>");
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String dn = f.getName();
            String tt = String.valueOf(dn) + "<b>  (" + UtilNumber.div(f.length(), 1024.0, 2) + "KB)";
            if (dn.equals(excludeFile)) {
                sb.append("<option selected value=\"" + f.getName() + "_" + type + "\">" + tt + "</option>");
            } else {
                sb.append("<option value=\"" + f.getName() + "_" + type + "\">" + tt + "</option>");
            }
            ++n2;
        }
        sb.append("</select>");
        return sb.toString();
    }

    private File[] getListLogs(final String type, final String instId) {
        File root = new File(ConfigConst.DIR_LOG_ROOT);
        final boolean c = SDK.getPlatformAPI().isCluster();
        return root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (c && !UtilString.isEmpty(instId) && name.indexOf(type) == -1) {
                    return false;
                }
                return name.startsWith(type);
            }
        });
    }

    public String getRtLog(String file, String type, String instId) {
        String logFileName;
        if (SDK.getPlatformAPI().isCluster() && UtilString.isEmpty(instId)) {
            instId = AWSServerConf.getInstanceName();
        }
        File[] list = this.getListLogs(type, instId);
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        String string = logFileName = UtilString.isEmpty(file) ? this.getTypeDefFile(type, list) : file;
        if (logFileName == null) {
            logFileName = "";
        }
        String liststr = this.listFile(logFileName, type, list);
        File logFile = new File(ConfigConst.DIR_LOG_ROOT, logFileName);
        long modifyLong = logFile == null ? 0L : logFile.lastModified();
        String modifyTime = logFile == null ? "" : DateFormat.getDateTimeInstance().format(new Date(modifyLong));
        macroLibraries.put("SID_THREAD", "var threadSID='" + super.getContext().getSessionId() + "'");
        macroLibraries.put("src", "./w?sid=" + this.getContext().getSessionId() + "&cmd=CONSOLE_LOG_RT_FILE&type=" + type + "&file=" + Html.encodeURLUtf8(logFileName) + "&sort=asc&pageSize=50");
        macroLibraries.put("modifyDate", modifyTime);
        StringBuilder sb = new StringBuilder();
        if (SDK.getPlatformAPI().isCluster()) {
            sb.append("<select name='instId' onchange='changeInstId();'>");
            if (type != null && type.indexOf("web") != -1) {
                List ws = ClusterAPI.getWEBS();
                for (String w : ws) {
                    sb.append("<option value='" + w + "'" + this.getSelected(w, instId) + ">" + w + "</option>");
                }
            } else {
                sb.append("<option value='" + SDK.getConfAPI().getInstanceName() + "'" + this.getSelected(SDK.getConfAPI().getInstanceName(), instId) + ">" + SDK.getConfAPI().getInstanceName() + "</option>");
                List ss = SDK.getManagementAPI().getServerNodes();
                for (ManagementAPI.ServerNode n : ss) {
                    sb.append("<option value='" + n.getName() + "'" + this.getSelected(n.getName(), instId) + ">" + n.getName() + "</option>");
                }
            }
            sb.append("</select>&nbsp;&nbsp;");
        } else {
            sb.append("<input type='hidden' name='instId' value='" + SDK.getConfAPI().getInstanceName() + "'>");
        }
        sb.append(liststr);
        macroLibraries.put("logFile", liststr);
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("type", type);
        macroLibraries.put("file", logFileName);
        return this.merge("console.log.rt.htm", macroLibraries);
    }

    private String getSelected(String s1, String s2) {
        return s1.equals(s2) ? " SELECTED" : "";
    }

    public String getFileViewer(String logFileName, String sort, int pageSize) {
        StringBuffer content;
        StringBuffer num;
        block22: {
            num = new StringBuffer();
            content = new StringBuffer();
            BufferedReader in = null;
            try {
                try {
                    int j;
                    String line;
                    in = new BufferedReader(new InputStreamReader(new FileInputStream("../logs/" + logFileName)));
                    int totalNumLines = 0;
                    RoundQueue rq = new RoundQueue(pageSize);
                    boolean asc = "asc".equals(sort);
                    while ((line = in.readLine()) != null) {
                        ++totalNumLines;
                        rq.add((Object)line);
                    }
                    in.close();
                    List list = rq.get();
                    if (!asc) {
                        Collections.reverse(list);
                    }
                    if (asc) {
                        j = totalNumLines > pageSize ? totalNumLines - pageSize : 0;
                        while (j < totalNumLines) {
                            num.append("" + j).append("<br>").append("\n");
                            ++j;
                        }
                    } else {
                        j = totalNumLines;
                        while (j > (totalNumLines > pageSize ? totalNumLines - pageSize : 0)) {
                            num.append("<nobr><span>" + j).append("</span></nobr><br>").append("\n");
                            --j;
                        }
                    }
                    if (list != null) {
                        for (String line1 : list) {
                            line1 = line1 == null || line1.trim().length() == 0 ? "&nbsp;" : line1;
                            content.append("<nobr><span class=\"hilite\">").append(line1).append("</span></nobr><br>\n");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace(System.err);
                        }
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("num", num.toString());
        macroLibraries.put("Row", I18nRes.findValue(super.getContext().getLanguage(), "\u884c"));
        macroLibraries.put("content", content.toString());
        return this.merge("console.log.rt.file.htm", macroLibraries);
    }

    private String merge(String template, Map<String, Object> macroLibraries) {
        return HtmlPageTemplate.merge("_bpm.platform", template, macroLibraries);
    }

    public String getAuditShowCartogram(UserContext me, String startTime, String endTime) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            String addrIp = addr.toString();
            macroLibraries.put("instname", hostname);
            macroLibraries.put("addr", addrIp.substring(addrIp.indexOf("/") + 1, addrIp.length()));
            Properties props = System.getProperties();
            macroLibraries.put("osName", props.getProperty("os.name"));
        }
        catch (Exception addr) {
            // empty catch block
        }
        if (HighSecurity.isON()) {
            String auditObject = "\u5ba1\u8ba1\u65e5\u5fd7\u62a5\u8868";
            String logInfo = String.valueOf(this.getContext().getUserName()) + "\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u62a5\u8868";
            SDK.getLogAPI().auditClient("access", this.getContext().getUID(), "access", auditObject, logInfo, this.getContext().getClientIP(), Level.INFO);
        }
        macroLibraries.put("sid", me.getSessionId());
        macroLibraries.put("startTime", startTime);
        macroLibraries.put("endTime", endTime);
        return this.merge("console.log.audit.cartogram.htm", macroLibraries);
    }

    public String getAuditCartogramData(UserContext me, String q) {
        ResponseObject rs = ResponseObject.newOkResponse();
        JSONObject Q = UtilSerialize.parseObject(q);
        this.getLogDataByGroup(Q, rs);
        return rs.toString();
    }
}

