/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.logging;

import com.actionsoft.bpms.commons.log.logging.LoggingOutputStream;
import com.actionsoft.bpms.server.DispatcherRequest;
import java.io.File;
import java.io.PrintStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class AWSLogger {
    private static Logger SQL = LogManager.getLogger((String)"com.actionsoft.sql");
    private static Logger CMD = LogManager.getLogger((String)"com.actionsoft.cmd");
    private static Logger CACHE = LogManager.getLogger((String)"com.actionsoft.cache");
    private static Logger ACCESS = LogManager.getLogger((String)"com.actionsoft");
    private static long lastModify = new File("conf/aws-log4j.xml").lastModified();

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        System.setOut(new PrintStream(new LoggingOutputStream(Level.INFO), true));
        System.setErr(new PrintStream(new LoggingOutputStream(Level.ERROR), true));
    }

    public static void sql2access(boolean sucess, String sql) {
        StringBuilder msg = new StringBuilder();
        msg.append("[Type=LOCAL]");
        if (DispatcherRequest.getContext() != null) {
            msg.append("[WebID=").append(DispatcherRequest.getContext().getExchange().getId()).append("]");
        }
        msg.append("[").append(sucess ? "SUCCESS" : "ERROR").append("]");
        msg.append("[").append(Thread.currentThread().getName()).append("]");
        msg.append("[").append(sql).append("]");
        SQL.info((CharSequence)msg);
    }

    public static void cmd2access(String str) {
        CMD.info(str);
    }

    public static void cache2access(String str) {
        CACHE.info("[Type=CACHE]" + str);
    }

    public static void access(Object obj) {
        ACCESS.info(obj);
    }

    public static void checkChange() {
        File xmlFile = new File("conf/aws-log4j.xml");
        if (!xmlFile.exists()) {
            return;
        }
        if (AWSLogger.changed(xmlFile)) {
            lastModify = xmlFile.lastModified();
            ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure();
        }
    }

    private static boolean changed(File xmlFile) {
        return lastModify != xmlFile.lastModified();
    }

    public static void init() {
    }
}

