/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla;

import com.actionsoft.bpms.commons.log.console.LogWeb;
import com.actionsoft.bpms.commons.log.sla.web.SLAWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.UtilString;
import java.io.IOException;
import org.dom4j.DocumentException;

@Controller
public class SLAController {
    @Mapping(value="CONSOLE_LOG_MAIN")
    public String getLogManager(UserContext uc) {
        return new LogWeb(uc).getWeb();
    }

    @Mapping(value="CONSOLE_LOG_AUDIT")
    public String getAuditWeb(UserContext uc) {
        return new LogWeb(uc).getAudit();
    }

    @Mapping(value="CONSOLE_LOG_AUDIT_DATA")
    public String getAuditData(UserContext uc, String q, String start, String limit) {
        return new LogWeb(uc).getAuditData(q, start, limit);
    }

    @Mapping(value="CONSOLE_LOG_AUDIT_DATA_EXPORT")
    public String getAuditDataExport(UserContext uc, String q, String start, String limit) {
        return new LogWeb(uc).getAuditDataExport(q, start, limit);
    }

    @Mapping(value="CONSOLE_LOG_AUDIT_SHOW_CARTOGRAM")
    public String getAuditShowCartogram(UserContext uc, String startTime, String endTime) {
        return new LogWeb(uc).getAuditShowCartogram(uc, startTime, endTime);
    }

    @Mapping(value="CONSOLE_LOG_AUDIT_SHOW_CARTOGRAM_DATA")
    public String getAuditCartogramData(UserContext uc, String q) {
        return new LogWeb(uc).getAuditCartogramData(uc, q);
    }

    @Mapping(value="CONSOLE_LOG_RT")
    public String getRuntimeLog(UserContext uc, String file, String type, String instId) {
        return new LogWeb(uc).getRtLog(file, type, instId);
    }

    @Mapping(value="CONSOLE_LOG_RT_FILE")
    public String getRuntimeLogFile(UserContext uc, String file, String sort, int pageSize) {
        return new LogWeb(uc).getFileViewer(file, sort, pageSize);
    }

    @Mapping(value="CONSOLE_LOG_GEN_ZIP")
    public String genZip(UserContext uc) throws Exception {
        return new LogWeb(uc).genZip();
    }

    @Mapping(value="CONSOLE_SLA_HOME")
    public String getHome(String menu) {
        return new SLAWeb().getHome(menu);
    }

    @Mapping(value="CONSOLE_SLA_JSON_MVCRESOURCE")
    public String getMVCResource(String type, String params) {
        return new SLAWeb().getData(type, params);
    }

    @Mapping(value="CONSOLE_SLA_JSON_ALARMLOG")
    public String getSLAAlarmLog(String property) {
        return new SLAWeb().getAlermLog(property);
    }

    @Mapping(value="CONSOLE_SLA_METRIC_LIST")
    public String getMetricList(String check, String use) {
        return new SLAWeb().getMetricList(check, use);
    }

    @Mapping(value="CONSOLE_SLA_CACHE_LIST")
    public String getCacheData(String filter) {
        return new SLAWeb().getCacheData(filter);
    }

    @Mapping(value="CONSOLE_SLA_ALARM_CONF")
    public String getAlarmConf(String data, String op) throws DocumentException, IOException {
        return new SLAWeb().confAlarm(data, op);
    }

    @Mapping(value="CONSOLE_SLA_ALARM")
    public String getSLAAlarmById(String id, String type) {
        if (UtilString.isEmpty(id)) {
            return new SLAWeb().getSLAAlarm(type);
        }
        return new SLAWeb().openSLADetail(id);
    }
}

