/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla;

import com.actionsoft.bpms.commons.database.DBPoolsManager;
import com.actionsoft.bpms.commons.database.tomcat.PoolTrackModel;
import com.actionsoft.bpms.commons.log.sla.model.DBTrackModel;
import com.actionsoft.bpms.commons.log.sla.model.ThreadTrackModel;
import com.actionsoft.bpms.server.monitor.ThreadMonit;
import com.actionsoft.bpms.server.monitor.ThreadMonitModel;
import com.actionsoft.bpms.util.ThreadStackTraceInfo;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SLAUtil {
    private static Map<String, Long> rxCurrentMap = new HashMap<String, Long>();
    private static Map<String, List<Long>> rxChangeMap = new HashMap<String, List<Long>>();
    private static Map<String, Long> txCurrentMap = new HashMap<String, Long>();
    private static Map<String, List<Long>> txChangeMap = new HashMap<String, List<Long>>();

    public static Serializable getTrack(String type) {
        if ("database".equals(type)) {
            return (Serializable)((Object)SLAUtil.getDBTrack());
        }
        return (Serializable)((Object)SLAUtil.getThreadTrack());
    }

    public static Long[] getNetMetric() throws SigarException {
        try (Sigar sigar = new Sigar();){
            String[] stringArray = sigar.getNetInterfaceList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ni = stringArray[n2];
                NetInterfaceStat netStat = sigar.getNetInterfaceStat(ni);
                NetInterfaceConfig ifConfig = sigar.getNetInterfaceConfig(ni);
                String hwaddr = null;
                if (!"00:00:00:00:00:00".equals(ifConfig.getHwaddr())) {
                    hwaddr = ifConfig.getHwaddr();
                }
                if (hwaddr != null) {
                    long rxCurrenttmp = netStat.getRxBytes();
                    SLAUtil.saveChange(rxCurrentMap, rxChangeMap, hwaddr, rxCurrenttmp, ni);
                    long txCurrenttmp = netStat.getTxBytes();
                    SLAUtil.saveChange(txCurrentMap, txChangeMap, hwaddr, txCurrenttmp, ni);
                }
                ++n2;
            }
            long totalrx = SLAUtil.getMetricData(rxChangeMap);
            long totaltx = SLAUtil.getMetricData(txChangeMap);
            for (List<Long> l : rxChangeMap.values()) {
                l.clear();
            }
            for (List<Long> l : txChangeMap.values()) {
                l.clear();
            }
            Long[] longArray = new Long[]{totalrx, totaltx};
            return longArray;
        }
    }

    public static int getMonitThreshold() {
        int t = 3;
        try {
            String pro = SDK.getAppAPI().getProperty("_bpm.platform", "monitor.thread.threshold");
            if (!UtilString.isEmpty(pro)) {
                t = Integer.parseInt(pro);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    private static List<ThreadTrackModel> getThreadTrack() {
        ArrayList list = new ArrayList(ThreadMonit.getRuns());
        Collections.sort(list);
        ArrayList<ThreadTrackModel> threadTrackModels = new ArrayList<ThreadTrackModel>();
        for (ThreadMonitModel fastTrackThread : list) {
            if (threadTrackModels.size() >= 5 || System.currentTimeMillis() - fastTrackThread.getStarttime() < (long)(SLAUtil.getMonitThreshold() * 1000)) break;
            if (fastTrackThread.getStarttime() == -1L) continue;
            ThreadTrackModel threadTrackModel = new ThreadTrackModel();
            threadTrackModel.setId(fastTrackThread.getThread().getId());
            threadTrackModel.setName(fastTrackThread.getThread().getName());
            threadTrackModel.setOptime(fastTrackThread.getStarttime());
            threadTrackModel.setState(fastTrackThread.getThread().getState());
            threadTrackModel.setThreadGroup(fastTrackThread.getThread().getThreadGroup().getName());
            threadTrackModel.setStackTraceElements(fastTrackThread.getThread().getState() == Thread.State.TERMINATED ? Collections.singletonList("\u7ebf\u7a0b\u7ed3\u675f") : ThreadStackTraceInfo.getStackArray(fastTrackThread.getThread()));
            threadTrackModels.add(threadTrackModel);
        }
        return threadTrackModels;
    }

    private static List<DBTrackModel> getDBTrack() {
        List poolTrackModels = DBPoolsManager.getInstance().getTrack();
        ArrayList<DBTrackModel> dbTrackModels = new ArrayList<DBTrackModel>();
        for (PoolTrackModel poolTrackModel : poolTrackModels) {
            DBTrackModel dbTrackModel = new DBTrackModel();
            dbTrackModel.setExtra(poolTrackModel.getExtra());
            dbTrackModel.setName(poolTrackModel.getName());
            dbTrackModel.setStack(poolTrackModel.getStack());
            dbTrackModel.setOptime(poolTrackModel.getTime());
            dbTrackModels.add(dbTrackModel);
        }
        return dbTrackModels;
    }

    private static long getMetricData(Map<String, List<Long>> rxChangeMap) {
        long total = 0L;
        for (Map.Entry<String, List<Long>> entry : rxChangeMap.entrySet()) {
            int average = 0;
            for (Long l : entry.getValue()) {
                average = (int)((long)average + l);
            }
            total += (long)(average / entry.getValue().size());
        }
        return total;
    }

    private static void saveChange(Map<String, Long> currentMap, Map<String, List<Long>> changeMap, String hwaddr, long current, String ni) {
        Long oldCurrent = currentMap.get(ni);
        if (oldCurrent != null) {
            List<Long> list = changeMap.get(hwaddr);
            if (list == null) {
                list = new LinkedList<Long>();
                changeMap.put(hwaddr, list);
            }
            list.add(current - oldCurrent);
        }
        currentMap.put(ni, current);
    }
}

