/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.alarm;

import com.actionsoft.bpms.commons.log.sla.alarm.AlarmListener;
import com.actionsoft.bpms.commons.log.sla.alarm.AlarmManager;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLAAlarmEventModel;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.server.conf.sla.SLAAlarm;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.List;

public final class AlarmExec {
    private static AlarmExec alarm = new AlarmExec();

    private AlarmExec() {
    }

    public static AlarmExec getInstance() {
        return alarm;
    }

    public void evaluater(MetricData metricData) {
        List<SLAAlarm> list = this.getAlarms(metricData.getMetric().getId());
        if (!list.isEmpty()) {
            for (SLAAlarm alarm : list) {
                if (!alarm.isService()) continue;
                double alarmValue = 0.0;
                try {
                    alarmValue = Double.valueOf(alarm.getValue());
                    boolean isFire = false;
                    if (alarm.getCondition().equals("is greater than") && metricData.getValue() > alarmValue) {
                        isFire = true;
                    } else if (alarm.getCondition().equals("is less than") && metricData.getValue() < alarmValue) {
                        isFire = true;
                    }
                    if (alarm.getContinuous() > 1) {
                        if (isFire) {
                            alarm.setEvaluateTimes(alarm.getEvaluateTimes() + 1);
                            if (alarm.getEvaluateTimes() < alarm.getContinuous()) {
                                continue;
                            }
                        } else {
                            alarm.setEvaluateTimes(0);
                            continue;
                        }
                    }
                    if (!isFire) continue;
                    SLAAlarmEventModel alarmModel = new SLAAlarmEventModel();
                    alarmModel.setAlarmName(alarm.getName());
                    alarmModel.setAlarmLevel(alarm.getLevel());
                    alarmModel.setTakeDetail(metricData.getDetail());
                    alarmModel.setInstName(metricData.getInstName());
                    alarmModel.setMetricId(metricData.getMetric().getId());
                    alarmModel.setTakeValue(metricData.getValue());
                    alarmModel.setAppId(metricData.getAppId());
                    alarmModel.setResourceId(metricData.getResourceId());
                    SDK.getSLAAPI().throwAlarm(alarm.getName(), metricData.getResourceId(), alarm.getLevel(), metricData.getMetric().getId(), metricData.getAppId(), metricData.getValue(), metricData.getDetail());
                    if (alarm.getLevel() == 2) {
                        ConsolePrinter.err(String.valueOf(metricData.getAppId()) + " SLA Alarm" + alarmModel.toString());
                        if (!UtilString.isEmpty(alarmModel.getTakeDetail())) {
                            ConsolePrinter.err(String.valueOf(metricData.getAppId()) + " " + alarmModel.getTakeDetail());
                        }
                    } else if (alarm.getLevel() == 1) {
                        ConsolePrinter.warn(String.valueOf(metricData.getAppId()) + " SLA Alarm" + alarmModel.toString());
                        if (!UtilString.isEmpty(alarmModel.getTakeDetail())) {
                            ConsolePrinter.warn(String.valueOf(metricData.getAppId()) + " " + alarmModel.getTakeDetail());
                        }
                    } else {
                        ConsolePrinter.info(String.valueOf(metricData.getAppId()) + " SLA Alarm" + alarmModel.toString());
                        if (!UtilString.isEmpty(alarmModel.getTakeDetail())) {
                            ConsolePrinter.info(String.valueOf(metricData.getAppId()) + " " + alarmModel.getTakeDetail());
                        }
                    }
                    try {
                        List<AlarmListener> listeners = AlarmManager.getInstance().getListeners();
                        if (listeners.isEmpty()) continue;
                        for (AlarmListener listener : listeners) {
                            listener.fire(alarmModel);
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private List<SLAAlarm> getAlarms(String metricId) {
        ArrayList<SLAAlarm> list = new ArrayList<SLAAlarm>();
        for (SLAAlarm alarm : AWSSLAConf.getAlarms()) {
            if (!alarm.getWhen().equals(metricId)) continue;
            list.add(alarm);
        }
        return list;
    }
}

