/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.collector;

import com.actionsoft.bpms.commons.log.sla.collection.impl.mvc.CMDMetricCollector;
import com.actionsoft.framework.io.Exchange;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MVCCmdCollector {
    private static CmdAccess FIVESEC = new CmdAccess(12);
    private static CmdAccess ONEMIN = new CmdAccess(12);

    public static void cmdReq(Exchange req, long execTime) {
        MVCCmdCollector.FIVESEC.update(req, execTime);
        MVCCmdCollector.ONEMIN.update(req, execTime);
        CMDMetricCollector.addCounter();
    }

    public static void timeSection(boolean alsoMin) {
        long t = System.currentTimeMillis();
        MVCCmdCollector.FIVESEC.timer(t);
        if (alsoMin) {
            MVCCmdCollector.ONEMIN.timer(t);
        }
    }

    public static Map<Long, Long> getSecondData() {
        return MVCCmdCollector.FIVESEC.getCounter();
    }

    public static Map<Long, Long> getMinuteData() {
        return MVCCmdCollector.ONEMIN.getCounter();
    }

    public static Map<Long, Long> getSecondAvgTime() {
        return MVCCmdCollector.FIVESEC.getAvgExecTime();
    }

    public static Map<Long, Long> getMinuteAvgTime() {
        return MVCCmdCollector.ONEMIN.getAvgExecTime();
    }

    private static class AccessModel {
        private int counter = 0;
        private long execTime = 0L;
        private long starttime = System.currentTimeMillis();

        private AccessModel() {
        }

        public String toString() {
            return String.valueOf(this.counter) + ":" + this.starttime;
        }
    }

    private static class CmdAccess {
        private AccessModel[] sections = null;
        private int cursor = -1;
        private int length;

        private CmdAccess(int length) {
            this.length = length;
            this.sections = new AccessModel[this.length];
        }

        private void timer(long time) {
            this.cursor = (this.cursor + 1) % this.length == 0 ? 0 : ++this.cursor;
            AccessModel am = new AccessModel();
            am.starttime = time;
            this.sections[this.cursor] = am;
        }

        private void update(Exchange req, long execTime) {
            if (this.cursor == -1) {
                return;
            }
            if (this.sections[this.cursor] != null) {
                AccessModel accessModel = this.sections[this.cursor];
                accessModel.counter = accessModel.counter + 1;
                AccessModel accessModel2 = this.sections[this.cursor];
                accessModel2.execTime = accessModel2.execTime + TimeUnit.MILLISECONDS.convert(execTime, TimeUnit.NANOSECONDS);
            }
        }

        private AccessModel[] getModels() {
            int i;
            AccessModel counter = this.sections[(this.cursor + 1) % this.length];
            ArrayList<AccessModel> arr = new ArrayList<AccessModel>();
            if (counter == null) {
                int cur = this.cursor;
                int i2 = 0;
                while (i2 <= cur) {
                    arr.add(this.sections[i2]);
                    ++i2;
                }
                return arr.toArray(new AccessModel[0]);
            }
            int cur = this.cursor;
            if (cur + 1 < this.length) {
                i = cur + 1;
                while (i < this.length) {
                    arr.add(this.sections[i]);
                    ++i;
                }
            }
            i = 0;
            while (i <= cur) {
                arr.add(this.sections[i]);
                ++i;
            }
            return arr.toArray(new AccessModel[0]);
        }

        private Map<Long, Long> getCounter() {
            AccessModel[] ms;
            LinkedHashMap<Long, Long> t = new LinkedHashMap<Long, Long>();
            AccessModel[] accessModelArray = ms = this.getModels();
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                AccessModel m = accessModelArray[n2];
                t.put(m.starttime, Long.valueOf(m.counter));
                ++n2;
            }
            return t;
        }

        private Map<Long, Long> getAvgExecTime() {
            AccessModel[] ms = this.getModels();
            LinkedHashMap<Long, Long> t = new LinkedHashMap<Long, Long>();
            AccessModel[] accessModelArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                AccessModel m = accessModelArray[n2];
                long l = 0L;
                if (m.counter != 0) {
                    l = m.execTime / (long)m.counter;
                }
                t.put(m.starttime, l);
                ++n2;
            }
            return t;
        }
    }
}

