/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.collector;

import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.MVCCmdCollector;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.PullResource;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricWebCollection;
import com.actionsoft.bpms.commons.log.sla.collection.core.processing.MinuteDataProcessing;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.server.conf.sla.ResourceMetric;
import com.actionsoft.bpms.util.ConsolePrinter;

public class PullMetricDataCollector {
    private static boolean start = false;
    private static Thread pullResourceThread = null;

    public static synchronized void start() {
        if (start || !AWSSLAConf.isService()) {
            return;
        }
        pullResourceThread = new Thread(new PullResource());
        start = true;
        pullResourceThread.setName("AWS SLA Metric Data Collection(Pull)");
        pullResourceThread.start();
        Thread pull4SLAWeb = new Thread(new PullResource4SLA());
        pull4SLAWeb.setName("AWS SLA Metric Data Collection(Pull For MVC)");
        pull4SLAWeb.start();
        ConsolePrinter.info("SLA Data Collection Started (interval=" + AWSSLAConf.getPullCollectionInterval() + "s)");
        MinuteDataProcessing.start();
    }

    public static synchronized void stop() {
        if (!start) {
            return;
        }
        start = false;
        pullResourceThread.interrupt();
    }

    public static boolean isStart() {
        return start;
    }

    private static class PullResource4SLA
    implements Runnable {
        private int collectionInterval = 5;
        private static int CYCLE = 0;

        private PullResource4SLA() {
        }

        @Override
        public void run() {
            while (PullMetricDataCollector.isStart()) {
                MVCCmdCollector.timeSection((CYCLE %= 12) == 0);
                for (String metricId : AWSSLAConf.getMetrics().keySet()) {
                    ResourceMetric metric = AWSSLAConf.getMetrics().get(metricId);
                    if (!metric.getResourceName().startsWith("Infrastructure") || metric.getCollector() == null) continue;
                    SLACollectionContext ctx = new SLACollectionContext();
                    ctx.setMetric(metric);
                    try {
                        MetricData metricData = metric.getCollector().collection(ctx);
                        MetricWebCollection.putData(metricData);
                        if ((CYCLE %= 12) != 0) continue;
                        MetricWebCollection.putMinData(metricData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.collectionInterval * 1000);
                }
                catch (Exception e) {
                    break;
                }
                ++CYCLE;
            }
            ConsolePrinter.info("SLA Data Collection For MVC Stopped");
        }
    }
}

