/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.collector;

import com.actionsoft.bpms.commons.log.sla.alarm.AlarmExec;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.PullMetricDataCollector;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricCollectionData;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.commons.log.sla.collection.core.processing.MinuteDataProcessing;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.server.conf.sla.ResourceMetric;
import com.actionsoft.bpms.util.ConsolePrinter;

class PullResource
implements Runnable {
    private int collectionInterval = AWSSLAConf.getPullCollectionInterval();

    PullResource() {
    }

    @Override
    public void run() {
        while (PullMetricDataCollector.isStart()) {
            for (String metricId : AWSSLAConf.getMetrics().keySet()) {
                ResourceMetric metric = AWSSLAConf.getMetrics().get(metricId);
                if (!metric.getCollectionPolicy().equals("pull") || metric.getCollector() == null) continue;
                SLACollectionContext ctx = new SLACollectionContext();
                ctx.setMetric(metric);
                try {
                    MetricData metricData = metric.getCollector().collection(ctx);
                    MetricCollectionData.putData(metricData);
                    AlarmExec.getInstance().evaluater(metricData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.collectionInterval * 1000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConsolePrinter.info("SLA Data Collection Stopped");
        MinuteDataProcessing.stop();
    }
}

