/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.collector;

import com.actionsoft.bpms.commons.log.sla.alarm.AlarmExec;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollector;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.PullMetricDataCollector;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricCollectionData;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.commons.log.sla.collection.impl.push.PushMetricCollector;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.server.conf.sla.ResourceMetric;
import com.actionsoft.bpms.util.ThreadStackTraceInfo;
import com.actionsoft.exception.ExceptionUtil;

public class PushMetricDataCollector {
    private static PushMetricDataCollector push = new PushMetricDataCollector();

    private PushMetricDataCollector() {
    }

    public static PushMetricDataCollector getInstance() {
        return push;
    }

    public SLATimeCollectionContext begin() {
        if (AWSSLAConf.isService() && PullMetricDataCollector.isStart()) {
            SLATimeCollectionContext ctx = new SLATimeCollectionContext();
            ctx.setBeginTimes();
            return ctx;
        }
        return null;
    }

    public void collection(SLACollectionContext ctx, String metricId, String appId, String resourceId, String resourceInfo, Throwable e) {
        if (AWSSLAConf.isService() && PullMetricDataCollector.isStart()) {
            try {
                ResourceMetric metric = AWSSLAConf.getMetrics().get(metricId);
                if (metric != null && metric.getCollectionPolicy().equals("push")) {
                    SLACollector collector;
                    ctx.setMetric(metric);
                    if (resourceInfo != null || e != null) {
                        String detail = "";
                        if (resourceInfo != null) {
                            detail = resourceInfo;
                        }
                        String lineSeparator = System.getProperty("line.separator", "/n");
                        if (e != null) {
                            detail = String.valueOf(detail) + lineSeparator + ExceptionUtil.getMessage(e);
                        }
                        if (e != null) {
                            detail = String.valueOf(detail) + lineSeparator + "***Collection JVM StackTraces***" + lineSeparator + ThreadStackTraceInfo.getCurrentThreadStackTraces(3) + lineSeparator + lineSeparator;
                        }
                        ctx.setParam("detail", detail);
                    }
                    if ((collector = metric.getCollector()) == null) {
                        collector = new PushMetricCollector();
                    }
                    try {
                        MetricData metricData = collector.collection(ctx);
                        metricData.setAppId(appId);
                        metricData.setResourceId(resourceId);
                        MetricCollectionData.putData(metricData);
                        AlarmExec.getInstance().evaluater(metricData);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }
}

