/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.collector.push;

import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.PushMetricDataCollector;
import com.actionsoft.bpms.commons.log.sla.collection.util.CollectionUtil;
import com.actionsoft.bpms.commons.session.cache.SessionCache;
import com.actionsoft.bpms.commons.session.model.SessionModel;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.framework.io.Exchange;
import java.util.HashMap;

public class CmdExecPush {
    private static CmdExecPush push = new CmdExecPush();

    private CmdExecPush() {
    }

    public static CmdExecPush getInstance() {
        return push;
    }

    public SLATimeCollectionContext begin() {
        return PushMetricDataCollector.getInstance().begin();
    }

    public void end(SLACollectionContext ctx, Exchange exchage) {
        if (ctx != null) {
            String metricId = null;
            String appId = CollectionUtil.guessAppId();
            if ("W".equals(exchage.getResponseType())) {
                metricId = "webCmd";
            } else if ("JD".equals(exchage.getResponseType()) || "XD".equals(exchage.getResponseType())) {
                metricId = "dataCmd";
            }
            if (metricId != null) {
                SessionModel session;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("cmd", exchage.getCmd());
                if (DispatcherRequest.getUserContext() != null) {
                    map.put("user", DispatcherRequest.getUserContext().getUID());
                } else if (exchage.getSid() != null && (session = SessionCache.getModel((String)exchage.getSid())) != null) {
                    map.put("user", session.getUid());
                }
                map.put("ip", exchage.getClientIp());
                map.put("params", exchage.getParameters());
                PushMetricDataCollector.getInstance().collection(ctx, "MVCFramework." + metricId, appId, null, ((Object)map).toString(), null);
            }
        }
    }
}

