/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.processing;

import com.actionsoft.bpms.commons.log.sla.collection.core.processing.DayDataProcessing;
import com.actionsoft.bpms.commons.log.sla.collection.util.CollectionUtil;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataDDao;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataHDao;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfDay;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfHour;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLACollectionDataDModel;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.util.UtilNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class DDataProcessor
implements Runnable {
    private int processingInterval = 86400000;
    private boolean isFirstProcessing = true;

    DDataProcessor() {
    }

    @Override
    public void run() {
        this.isFirstProcessing = true;
        while (DayDataProcessing.isStart()) {
            String exclusionKey = CollectionUtil.getDayDataZone(System.currentTimeMillis());
            try {
                if (exclusionKey != null) {
                    this.processing(exclusionKey);
                } else {
                    System.err.println("\u5185\u90e8\u9519\u8bef\uff0cdayDataZone\u83b7\u53d6\u5931\u8d25!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.processingInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processing(String exclusionKey) {
        List<SLACollectionDataOfHour> noProcessingList = new SLACollectionDataHDao().queryNoProcess(AWSServerConf.getInstanceName(), exclusionKey);
        if (noProcessingList != null && !noProcessingList.isEmpty()) {
            ArrayList<String> dimTimes = new ArrayList<String>();
            HashMap tmp1hDatas = new HashMap();
            ArrayList<String> tmpId = new ArrayList<String>();
            for (SLACollectionDataOfHour dataOfHour : noProcessingList) {
                List<SLACollectionDataOfHour> tmpList;
                String tmpKey;
                String vTime = dataOfHour.getvTime();
                if (!dimTimes.contains(vTime = vTime.substring(0, vTime.length() - 2))) {
                    dimTimes.add(vTime);
                }
                if (tmp1hDatas.containsKey(tmpKey = String.valueOf(dataOfHour.getMetricId()) + vTime)) {
                    tmpList = (List)tmp1hDatas.get(tmpKey);
                } else {
                    tmpList = new ArrayList();
                    tmp1hDatas.put(tmpKey, tmpList);
                }
                tmpList.add(dataOfHour);
                tmpId.add(dataOfHour.getId());
            }
            ArrayList<SLACollectionDataOfDay> newDataDModels = new ArrayList<SLACollectionDataOfDay>();
            for (String vTime : dimTimes) {
                for (String metricId : AWSSLAConf.getMetrics().keySet()) {
                    List tmpList = (List)tmp1hDatas.get(String.valueOf(metricId) + vTime);
                    if (tmpList == null || tmpList.isEmpty()) continue;
                    SLACollectionDataDModel dataDModel = new SLACollectionDataDModel();
                    dataDModel.setInstName(AWSServerConf.getInstanceName());
                    dataDModel.setMetricId(metricId);
                    dataDModel.setvTime(vTime);
                    double max = 0.0;
                    double min = -1.0;
                    double sum = 0.0;
                    double avg = 0.0;
                    long count = 0L;
                    for (SLACollectionDataOfHour dataOfHour : tmpList) {
                        if (min == -1.0) {
                            min = dataOfHour.getvMin();
                        }
                        if (min > dataOfHour.getvMin()) {
                            min = dataOfHour.getvMin();
                        }
                        if (max < dataOfHour.getvMax()) {
                            max = dataOfHour.getvMax();
                        }
                        sum += dataOfHour.getvAvg();
                        count += dataOfHour.getvCount();
                    }
                    avg = UtilNumber.fixPoint(sum / (double)tmpList.size(), 4);
                    dataDModel.setvAvg(avg);
                    dataDModel.setvMax(max);
                    dataDModel.setvMin(min);
                    dataDModel.setvCount(count);
                    SLACollectionDataOfDay lastSaveModel = new SLACollectionDataDDao().queryByMetricId(dataDModel.getInstName(), dataDModel.getMetricId(), dataDModel.getvTime());
                    if (lastSaveModel != null) {
                        try {
                            new SLACollectionDataDDao().delete(lastSaveModel.getId());
                            dataDModel.setvAvg(UtilNumber.fixPoint((dataDModel.getvAvg() + lastSaveModel.getvAvg()) / 2.0, 4));
                            dataDModel.setvCount(dataDModel.getvCount() + lastSaveModel.getvCount());
                            dataDModel.setvMax(dataDModel.getvMax() > lastSaveModel.getvMax() ? dataDModel.getvMax() : lastSaveModel.getvMax());
                            dataDModel.setvMin(dataDModel.getvMin() < lastSaveModel.getvMin() ? dataDModel.getvMin() : lastSaveModel.getvMin());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    newDataDModels.add(dataDModel);
                }
            }
            if (!newDataDModels.isEmpty()) {
                try {
                    new SLACollectionDataDDao().insertBatch(newDataDModels);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    new SLACollectionDataHDao().changeTagBatch(tmpId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.isFirstProcessing = false;
            }
            noProcessingList.clear();
            tmp1hDatas.clear();
        }
    }
}

