/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.core.processing;

import com.actionsoft.bpms.commons.log.sla.collection.core.processing.DayDataProcessing;
import com.actionsoft.bpms.commons.log.sla.collection.core.processing.HourDataProcessing;
import com.actionsoft.bpms.commons.log.sla.collection.util.CollectionUtil;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataHDao;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataMDao;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfHour;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfMinute;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLACollectionDataHModel;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.util.UtilNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class HDataProcessor
implements Runnable {
    private int processingInterval = 3600000;
    private boolean isFirstProcessing = true;

    HDataProcessor() {
    }

    @Override
    public void run() {
        this.isFirstProcessing = true;
        while (HourDataProcessing.isStart()) {
            String exclusionKey = CollectionUtil.getHourDataZone(System.currentTimeMillis());
            try {
                if (exclusionKey != null) {
                    this.processing(exclusionKey);
                } else {
                    System.err.println("\u5185\u90e8\u9519\u8bef\uff0cminuteDataZone\u83b7\u53d6\u5931\u8d25!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.processingInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DayDataProcessing.stop();
    }

    public void processing(String exclusionKey) {
        List<SLACollectionDataOfMinute> noProcessingList = new SLACollectionDataMDao().queryNoProcess(AWSServerConf.getInstanceName(), exclusionKey);
        if (noProcessingList != null && !noProcessingList.isEmpty()) {
            ArrayList<String> dimTimes = new ArrayList<String>();
            HashMap tmp5mDatas = new HashMap();
            ArrayList<String> tmpId = new ArrayList<String>();
            for (SLACollectionDataOfMinute dataOfMinute : noProcessingList) {
                List<SLACollectionDataOfMinute> tmpList;
                String tmpKey;
                if (!AWSServerConf.getInstanceName().equals(dataOfMinute.getInstName())) continue;
                String vTime = dataOfMinute.getvTime();
                if (!dimTimes.contains(vTime = vTime.substring(0, vTime.length() - 2))) {
                    dimTimes.add(vTime);
                }
                if (tmp5mDatas.containsKey(tmpKey = String.valueOf(dataOfMinute.getMetricId()) + vTime)) {
                    tmpList = (List)tmp5mDatas.get(tmpKey);
                } else {
                    tmpList = new ArrayList();
                    tmp5mDatas.put(tmpKey, tmpList);
                }
                tmpList.add(dataOfMinute);
                tmpId.add(dataOfMinute.getId());
            }
            ArrayList<SLACollectionDataOfHour> newDataHModels = new ArrayList<SLACollectionDataOfHour>();
            for (String vTime : dimTimes) {
                for (String metricId : AWSSLAConf.getMetrics().keySet()) {
                    List tmpList = (List)tmp5mDatas.get(String.valueOf(metricId) + vTime);
                    if (tmpList == null || tmpList.isEmpty()) continue;
                    SLACollectionDataHModel dataOfHour = new SLACollectionDataHModel();
                    dataOfHour.setInstName(AWSServerConf.getInstanceName());
                    dataOfHour.setMetricId(metricId);
                    dataOfHour.setvTime(vTime);
                    double max = 0.0;
                    double min = -1.0;
                    double sum = 0.0;
                    double avg = 0.0;
                    long count = 0L;
                    for (SLACollectionDataOfMinute dataOfMinute : tmpList) {
                        if (min == -1.0) {
                            min = dataOfMinute.getvMin();
                        }
                        if (min > dataOfMinute.getvMin()) {
                            min = dataOfMinute.getvMin();
                        }
                        if (max < dataOfMinute.getvMax()) {
                            max = dataOfMinute.getvMax();
                        }
                        sum += dataOfMinute.getvAvg();
                        count += dataOfMinute.getvCount();
                    }
                    avg = UtilNumber.fixPoint(sum / (double)tmpList.size(), 4);
                    dataOfHour.setvAvg(avg);
                    dataOfHour.setvMax(max);
                    dataOfHour.setvMin(min);
                    dataOfHour.setvCount(count);
                    SLACollectionDataOfHour lastSaveModel = new SLACollectionDataHDao().queryByMetricId(dataOfHour.getInstName(), dataOfHour.getMetricId(), dataOfHour.getvTime());
                    if (lastSaveModel != null) {
                        try {
                            new SLACollectionDataHDao().delete(lastSaveModel.getId());
                            dataOfHour.setvCount(dataOfHour.getvCount() + lastSaveModel.getvCount());
                            dataOfHour.setvAvg(UtilNumber.fixPoint((dataOfHour.getvAvg() + lastSaveModel.getvAvg()) / 2.0, 4));
                            dataOfHour.setvMax(dataOfHour.getvMax() > lastSaveModel.getvMax() ? dataOfHour.getvMax() : lastSaveModel.getvMax());
                            dataOfHour.setvMin(dataOfHour.getvMin() < lastSaveModel.getvMin() ? dataOfHour.getvMin() : lastSaveModel.getvMin());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    newDataHModels.add(dataOfHour);
                }
            }
            if (!newDataHModels.isEmpty()) {
                try {
                    new SLACollectionDataHDao().insertBatch(newDataHModels);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    new SLACollectionDataMDao().changeTagBatch(tmpId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.isFirstProcessing = false;
            }
            noProcessingList.clear();
            tmp5mDatas.clear();
        }
    }
}

