/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.impl.infrastructure;

import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectorAbst;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.util.UtilNumber;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Sigar;

public class CpuMetricCollector
extends SLACollectorAbst {
    @Override
    public MetricData collection(SLACollectionContext ctx) {
        MetricData metricData = super.collection(ctx);
        try (Sigar sigar = null;){
            sigar = new Sigar();
            CpuPerc[] cpus = null;
            cpus = sigar.getCpuPercList();
            double totalCombined = 0.0;
            int i = 0;
            while (i < cpus.length) {
                CpuPerc cpu = cpus[i];
                double combined = cpu.getCombined();
                totalCombined += combined;
                ++i;
            }
            if (!Double.isNaN(totalCombined)) {
                metricData.setValue(UtilNumber.fixPoint(totalCombined / (double)cpus.length, 4));
            }
            MetricData metricData2 = metricData;
            return metricData2;
        }
    }
}

