/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.collection.impl.push;

import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLACollectorAbst;
import com.actionsoft.bpms.commons.log.sla.collection.core.SLATimeCollectionContext;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.exception.AWSForbiddenException;

public class PushMetricCollector
extends SLACollectorAbst {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MetricData collection(SLACollectionContext ctx) {
        MetricData metricData = super.collection(ctx);
        if (metricData.getMetric().getUnit().equals("times")) {
            metricData.setValue(1.0);
            return metricData;
        } else {
            if (!metricData.getMetric().getUnit().equals("ms")) throw new AWSForbiddenException("\u4e0d\u80fd\u8bc6\u522b\u7684\u6307\u6807\u5355\u4f4d[" + metricData.getMetric().getUnit() + "]");
            if (!(ctx instanceof SLATimeCollectionContext)) throw new AWSForbiddenException("ctx\u7c7b\u578b\u4e0d\u5f53\uff0c\u5e94\u7ed9\u5b9abegin()\u8fd4\u56de\u7684\u4e0a\u4e0b\u6587\u5bf9\u8c61");
            long begin = ((SLATimeCollectionContext)ctx).getBeginTimes();
            if (begin <= 0L) throw new AWSForbiddenException("ctx\u7c7b\u578b\u4e0d\u5f53\uff0c\u5e94\u7ed9\u5b9abegin()\u8fd4\u56de\u7684\u4e0a\u4e0b\u6587\u5bf9\u8c61");
            long end = System.nanoTime();
            double value = Double.valueOf(Long.toString(end - begin)) / 1000000.0;
            metricData.setValue(UtilNumber.fixPoint(value, 4));
        }
        return metricData;
    }
}

