/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.log.sla.model.SLAAlarmEvent;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLAAlarmEventModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class SLAAlarmEventDao
extends DaoObject<SLAAlarmEvent> {
    @Override
    public int insert(SLAAlarmEvent model) throws AWSDataAccessException {
        ((SLAAlarmEventModel)model).setId(UUIDGener.getUUID());
        String sql = "INSERT INTO " + this.entityName() + "(ID,INSTNAME,ALARMNAME,ALARMLEVEL,METRICID,TAKEVALUE,TAKEDETAIL,APPID,RESOURCEID,EVENTTIME,ISREAD)VALUES(:ID,:INSTNAME,:ALARMNAME,:ALARMLEVEL,:METRICID,:TAKEVALUE,:TAKEDETAIL,:APPID,:RESOURCEID,:EVENTTIME,:ISREAD)";
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ID", model.getId());
        paraMap.put("INSTNAME", model.getInstName());
        paraMap.put("ALARMLEVEL", model.getAlarmLevel());
        paraMap.put("ALARMNAME", model.getAlarmName());
        paraMap.put("METRICID", model.getMetricId());
        paraMap.put("TAKEVALUE", model.getTakeValue());
        paraMap.put("TAKEDETAIL", model.getTakeDetail());
        paraMap.put("APPID", model.getAppId());
        paraMap.put("RESOURCEID", model.getResourceId());
        paraMap.put("EVENTTIME", model.getEventTime());
        paraMap.put("ISREAD", model.isRead() ? 1 : 0);
        return DBSql.update(sql, paraMap);
    }

    @Override
    public int update(SLAAlarmEvent model) throws AWSDataAccessException {
        return -1;
    }

    public int tagRead(String id) throws AWSDataAccessException {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ISREAD", 1);
        return this.update(id, paraMap);
    }

    public int countOfNoRead(String instName) {
        return DBSql.getInt("SELECT COUNT(ID) AS C FROM " + this.entityName() + " WHERE INSTNAME='" + instName + "' AND ISREAD=0", "C");
    }

    public List<SLAAlarmEvent> queryByInstName(String instName, int firstRow, int rowCount) {
        return this.query("INSTNAME=? ", instName).orderBy("EVENTTIME").desc().list(firstRow, rowCount);
    }

    public List<SLAAlarmEvent> queryByMetricId(String instName, String metricId, int firstRow, int rowCount) {
        return this.query("INSTNAME=? AND METRICID=?", instName, metricId).orderBy("EVENTTIME").desc().list(firstRow, rowCount);
    }

    public List<SLAAlarmEvent> queryByMetricId(String metricId, int firstRow, int rowCount) {
        return this.query("METRICID=?", metricId).orderBy("EVENTTIME").desc().list(firstRow, rowCount);
    }

    public int count(String metricId) {
        String sql = "select count(id) from " + this.entityName() + " where METRICID=?";
        return DBSql.getInt(sql, new Object[]{metricId});
    }

    public List<SLAAlarmEvent> query(int firstRow, int rowCount) {
        return this.query().orderBy("EVENTTIME").desc().list(firstRow, rowCount);
    }

    public List<SLAAlarmEvent> queryByLevel(int level, int firstRow, int rowCount) {
        return this.query("INSTNAME=? AND ALARMLEVEL=?", AWSServerConf.getInstanceName(), level).orderBy("EVENTTIME").desc().list(firstRow, rowCount);
    }

    @Override
    public String entityName() {
        return "SYS_SLA_ALARM";
    }

    @Override
    public RowMapper<SLAAlarmEvent> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<SLAAlarmEvent> {
        private Mapper() {
        }

        public SLAAlarmEvent mapRow(ResultSet rset, int rowNum) throws SQLException {
            SLAAlarmEventModel model = new SLAAlarmEventModel();
            try {
                model.setId(rset.getString("ID"));
                model.setInstName(rset.getString("INSTNAME"));
                model.setAlarmName(rset.getString("ALARMNAME"));
                model.setAlarmLevel(rset.getInt("ALARMLEVEL"));
                model.setMetricId(rset.getString("METRICID"));
                model.setTakeValue(rset.getDouble("TAKEVALUE"));
                model.setTakeDetail(rset.getString("TAKEDETAIL"));
                model.setAppId(rset.getString("APPID"));
                model.setResourceId(rset.getString("RESOURCEID"));
                model.setEventTime(rset.getTimestamp("EVENTTIME"));
                model.setRead(rset.getInt("ISREAD") == 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return model;
        }
    }
}

