/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.dao;

import com.actionsoft.bpms.commons.database.BatchPreparedStatementSetter;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfDay;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLACollectionDataDModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SLACollectionDataDDao
extends DaoObject<SLACollectionDataOfDay> {
    @Override
    public int insert(SLACollectionDataOfDay model) throws AWSDataAccessException {
        throw new AWSDataAccessException("forbidden insert!");
    }

    public void insertBatch(final List<SLACollectionDataOfDay> models) throws AWSDataAccessException {
        String sql = "INSERT INTO " + this.entityName() + "(ID,INSTNAME,METRICID,VAVG,VMAX,VMIN,VCOUNT,VTIME,ISPROCESSING)VALUES(?,?,?,?,?,?,?,?,0)";
        DBSql.batch(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                SLACollectionDataOfDay model = (SLACollectionDataOfDay)models.get(paramInt);
                pst.setString(1, UUIDGener.getUUID());
                pst.setString(2, model.getInstName());
                pst.setString(3, model.getMetricId());
                pst.setDouble(4, model.getvAvg());
                pst.setDouble(5, model.getvMax());
                pst.setDouble(6, model.getvMin());
                pst.setLong(7, model.getvCount());
                pst.setString(8, model.getvTime());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public void keepRecords() throws AWSDataAccessException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMdd");
        calendar.setTime(new Date());
        calendar.add(1, -1);
        calendar.add(5, -1);
        String vTime = datetimeFormat.format(calendar.getTime());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("VTIME", vTime);
        DBSql.update("DELETE FROM SYS_SLA_DIM_D WHERE VTIME<:VTIME", params);
    }

    @Override
    public int update(SLACollectionDataOfDay model) throws AWSDataAccessException {
        return -1;
    }

    public List<SLACollectionDataOfDay> queryByMetricId(String instName, String metricId) {
        return this.query("INSTNAME=? AND METRICID=?", instName, metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfDay> queryByMetricId(String metricId) {
        return this.query("METRICID=?", metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfDay> queryByTime(String time) {
        return this.query("VTIME=?", time).list();
    }

    public SLACollectionDataOfDay queryByMetricId(String instName, String metricId, String vTime) {
        List list = this.query("INSTNAME=? AND METRICID=? AND VTIME=?", instName, metricId, vTime).list();
        if (list != null && !list.isEmpty()) {
            return (SLACollectionDataOfDay)list.get(0);
        }
        return null;
    }

    @Override
    public String entityName() {
        return "SYS_SLA_DIM_D";
    }

    @Override
    public RowMapper<SLACollectionDataOfDay> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<SLACollectionDataOfDay> {
        private Mapper() {
        }

        public SLACollectionDataOfDay mapRow(ResultSet rset, int rowNum) throws SQLException {
            SLACollectionDataDModel model = new SLACollectionDataDModel();
            try {
                model.setId(rset.getString("ID"));
                model.setInstName(rset.getString("INSTNAME"));
                model.setMetricId(rset.getString("METRICID"));
                model.setvAvg(rset.getDouble("VAVG"));
                model.setvMax(rset.getDouble("VMAX"));
                model.setvMin(rset.getDouble("VMIN"));
                model.setvCount(rset.getLong("VCOUNT"));
                model.setvTime(rset.getString("VTIME"));
                model.setProcessing(rset.getInt("ISPROCESSING") == 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return model;
        }
    }
}

