/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.dao;

import com.actionsoft.bpms.commons.database.BatchPreparedStatementSetter;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfHour;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLACollectionDataHModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SLACollectionDataHDao
extends DaoObject<SLACollectionDataOfHour> {
    @Override
    public int insert(SLACollectionDataOfHour model) throws AWSDataAccessException {
        ((SLACollectionDataHModel)model).setId(UUIDGener.getUUID());
        String sql = "INSERT INTO " + this.entityName() + "(ID,INSTNAME,METRICID,VAVG,VMAX,VMIN,VCOUNT,VTIME,ISPROCESSING)VALUES(:ID,:INSTNAME,:METRICID,:VAVG,:VMAX,:VMIN,:VCOUNT,:VTIME)";
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ID", model.getId());
        paraMap.put("INSTNAME", model.getInstName());
        paraMap.put("METRICID", model.getMetricId());
        paraMap.put("VAVG", model.getvAvg());
        paraMap.put("VMAX", model.getvMax());
        paraMap.put("VMIN", model.getvMin());
        paraMap.put("VCOUNT", model.getvCount());
        paraMap.put("VTIME", model.getvTime());
        paraMap.put("ISPROCESSING", 0);
        return DBSql.update(sql, paraMap);
    }

    public void insertBatch(final List<SLACollectionDataOfHour> models) throws AWSDataAccessException {
        String sql = "INSERT INTO " + this.entityName() + "(ID,INSTNAME,METRICID,VAVG,VMAX,VMIN,VCOUNT,VTIME,ISPROCESSING)VALUES(?,?,?,?,?,?,?,?,0)";
        DBSql.batch(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                SLACollectionDataOfHour model = (SLACollectionDataOfHour)models.get(paramInt);
                pst.setString(1, UUIDGener.getUUID());
                pst.setString(2, model.getInstName());
                pst.setString(3, model.getMetricId());
                pst.setDouble(4, model.getvAvg());
                pst.setDouble(5, model.getvMax());
                pst.setDouble(6, model.getvMin());
                pst.setLong(7, model.getvCount());
                pst.setString(8, model.getvTime());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public void changeTagBatch(final List<String> ids) throws AWSDataAccessException {
        String sql = "UPDATE " + this.entityName() + " SET ISPROCESSING=1 WHERE ID=?";
        DBSql.batch(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                String id = (String)ids.get(paramInt);
                pst.setString(1, id);
            }

            public int getBatchSize() {
                return ids.size();
            }
        });
    }

    public void keepRecords() throws AWSDataAccessException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHH");
        calendar.setTime(new Date());
        calendar.add(5, -15);
        calendar.add(11, -2);
        String vTime = datetimeFormat.format(calendar.getTime());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("VTIME", vTime);
        DBSql.update("DELETE FROM SYS_SLA_DIM_H WHERE VTIME<:VTIME", params);
    }

    @Override
    public int update(SLACollectionDataOfHour model) throws AWSDataAccessException {
        return -1;
    }

    public List<SLACollectionDataOfHour> queryByMetricId(String metricId) {
        return this.query("METRICID=?", metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfHour> queryByMetricId(String instName, String metricId) {
        return this.query("INSTNAME=? AND METRICID=?", instName, metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfHour> queryByTime(String time) {
        return this.query("VTIME=?", time).list();
    }

    public SLACollectionDataOfHour queryByMetricId(String instName, String metricId, String vTime) {
        List list = this.query("INSTNAME=? AND METRICID=? AND VTIME=?", instName, metricId, vTime).list();
        if (list != null && !list.isEmpty()) {
            return (SLACollectionDataOfHour)list.get(0);
        }
        return null;
    }

    public List<SLACollectionDataOfHour> queryNoProcess(String instName, String exclusionKey) {
        return this.query("INSTNAME=? AND ISPROCESSING=0 AND VTIME not like '" + exclusionKey + "%'", instName).orderBy("VTIME").desc().list();
    }

    @Override
    public String entityName() {
        return "SYS_SLA_DIM_H";
    }

    @Override
    public RowMapper<SLACollectionDataOfHour> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<SLACollectionDataOfHour> {
        private Mapper() {
        }

        public SLACollectionDataOfHour mapRow(ResultSet rset, int rowNum) throws SQLException {
            SLACollectionDataHModel model = new SLACollectionDataHModel();
            try {
                model.setId(rset.getString("ID"));
                model.setInstName(rset.getString("INSTNAME"));
                model.setMetricId(rset.getString("METRICID"));
                model.setvAvg(rset.getDouble("VAVG"));
                model.setvMax(rset.getDouble("VMAX"));
                model.setvMin(rset.getDouble("VMIN"));
                model.setvCount(rset.getLong("VCOUNT"));
                model.setvTime(rset.getString("VTIME"));
                model.setProcessing(rset.getInt("ISPROCESSING") == 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return model;
        }
    }
}

