/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.dao;

import com.actionsoft.bpms.commons.database.BatchPreparedStatementSetter;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionDataOfMinute;
import com.actionsoft.bpms.commons.log.sla.model.impl.SLACollectionDataMModel;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SLACollectionDataMDao
extends DaoObject<SLACollectionDataOfMinute> {
    @Override
    public int insert(SLACollectionDataOfMinute model) throws AWSDataAccessException {
        throw new AWSDataAccessException("forbidden insert!");
    }

    public void insertBatch(final List<SLACollectionDataOfMinute> models) throws AWSDataAccessException {
        String sql = "INSERT INTO " + this.entityName() + "(ID,INSTNAME,METRICID,VAVG,VMAX,VMIN,VCOUNT,VTIME,ISPROCESSING)VALUES(?,?,?,?,?,?,?,?,0)";
        DBSql.batch(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                SLACollectionDataOfMinute model = (SLACollectionDataOfMinute)models.get(paramInt);
                pst.setString(1, UUIDGener.getUUID());
                pst.setString(2, model.getInstName());
                pst.setString(3, model.getMetricId());
                pst.setDouble(4, model.getvAvg());
                pst.setDouble(5, model.getvMax());
                pst.setDouble(6, model.getvMin());
                pst.setLong(7, model.getvCount());
                pst.setString(8, model.getvTime());
            }

            public int getBatchSize() {
                return models.size();
            }
        });
    }

    public void changeTagBatch(final List<String> ids) throws AWSDataAccessException {
        String sql = "UPDATE " + this.entityName() + " SET ISPROCESSING=1 WHERE ID=?";
        DBSql.batch(sql.toString(), new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement pst, int paramInt) throws SQLException {
                String id = (String)ids.get(paramInt);
                pst.setString(1, id);
            }

            public int getBatchSize() {
                return ids.size();
            }
        });
    }

    public void keepRecords() throws AWSDataAccessException {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHHmm");
        calendar.setTime(new Date());
        calendar.add(5, -1);
        calendar.add(11, -1);
        String vTime = datetimeFormat.format(calendar.getTime());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("VTIME", vTime);
        DBSql.update("DELETE FROM SYS_SLA_DIM_M WHERE VTIME<:VTIME", params);
    }

    @Override
    public int update(SLACollectionDataOfMinute model) throws AWSDataAccessException {
        return -1;
    }

    public List<SLACollectionDataOfMinute> queryByMetricId(String metricId) {
        return this.query("METRICID=?", metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfMinute> queryByMetricId(String instName, String metricId) {
        return this.query("INSTNAME=? AND METRICID=?", instName, metricId).orderBy("VTIME").desc().list();
    }

    public List<SLACollectionDataOfMinute> queryByTime(String time) {
        return this.query("VTIME=?", time).list();
    }

    public SLACollectionDataOfMinute queryByMetricId(String instName, String metricId, String vTime) {
        List list = this.query("INSTNAME=? AND METRICID=? AND VTIME=?", instName, metricId, vTime).list();
        if (list != null && !list.isEmpty()) {
            return (SLACollectionDataOfMinute)list.get(0);
        }
        return null;
    }

    public List<SLACollectionDataOfMinute> queryNoProcess(String instName, String exclusionKey) {
        return this.query("ISPROCESSING=0 AND VTIME not like ?", String.valueOf(exclusionKey) + "%").orderBy("VTIME").desc().list();
    }

    @Override
    public String entityName() {
        return "SYS_SLA_DIM_M";
    }

    @Override
    public RowMapper<SLACollectionDataOfMinute> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<SLACollectionDataOfMinute> {
        private Mapper() {
        }

        public SLACollectionDataOfMinute mapRow(ResultSet rset, int rowNum) throws SQLException {
            SLACollectionDataMModel model = new SLACollectionDataMModel();
            try {
                model.setId(rset.getString("ID"));
                model.setInstName(rset.getString("INSTNAME"));
                model.setMetricId(rset.getString("METRICID"));
                model.setvAvg(rset.getDouble("VAVG"));
                model.setvMax(rset.getDouble("VMAX"));
                model.setvMin(rset.getDouble("VMIN"));
                model.setvCount(rset.getLong("VCOUNT"));
                model.setvTime(rset.getString("VTIME"));
                model.setProcessing(rset.getInt("ISPROCESSING") == 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return model;
        }
    }
}

