/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.sys;

import com.actionsoft.bpms.commons.log.sla.sys.OSPerformance;
import com.actionsoft.bpms.commons.log.sla.sys.OSPerformanceinfoInterface;
import com.actionsoft.bpms.commons.log.sla.sys.OSProcessPerformance;
import com.actionsoft.bpms.commons.log.sla.sys.PerformanceShellUtil;
import com.actionsoft.bpms.commons.log.sla.sys.PerformanceSortUtil;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.cc.ExecResult;
import java.util.ArrayList;

public class LinuxPerformanceInfoImp
implements OSPerformanceinfoInterface {
    OSPerformance osPerformance = null;
    String[] processValues;

    public LinuxPerformanceInfoImp() {
        this.excute();
        if (this.processValues != null && this.processValues.length > 8) {
            this.osPerformance = new OSPerformance();
            this.parseCPUUsage(this.processValues);
            this.parsePhysicalMemory(this.processValues);
            this.parsePerProcessUsage(this.processValues);
        }
    }

    @Override
    public OSPerformance getOSPerformance() {
        return this.osPerformance;
    }

    private void excute() {
        String[] commands = new String[]{"top -b -n 1"};
        this.processValues = new PerformanceShellUtil().excuteLinuxShell(commands, "LinuxMonitor");
    }

    private void parseCPUUsage(String[] values) {
        String value = values[2];
        value = value.substring(value.indexOf(":") + 1, value.length());
        String[] valueArray = value.split(",");
        String cpuStr = (value = valueArray[3]).trim().split("\\s+")[0];
        if (cpuStr.indexOf(37) != -1) {
            cpuStr = cpuStr.substring(0, cpuStr.indexOf(37));
        }
        cpuStr = cpuStr.trim();
        this.osPerformance.setOSCPUUsage(UtilNumber.fixPoint(100.0 - Double.parseDouble(cpuStr), 2));
    }

    private void parsePhysicalMemory(String[] values) {
        ExecResult r = SDK.getCCAPI().getNativeCallAPI().exec("free");
        ArrayList list = new ArrayList(r.getOutput());
        String totalPhysicalMemory = ((String)list.get(1)).substring(((String)list.get(1)).indexOf(58) + 1).trim().split("\\s+")[0].trim();
        String usagePhysicalMemory = ((String)list.get(2)).substring(((String)list.get(2)).indexOf(58) + 1).trim().split("\\s+")[0].trim();
        this.osPerformance.setOSTotalPhysicalMemory(UtilNumber.fixPoint(Double.parseDouble(totalPhysicalMemory) / 1024.0, 0));
        this.osPerformance.setOSPhysicalMemoryUsage(UtilNumber.fixPoint(Double.parseDouble(usagePhysicalMemory) / 1024.0, 0));
    }

    private void parsePerProcessUsage(String[] values) {
        ArrayList<OSProcessPerformance> processList = new ArrayList<OSProcessPerformance>();
        int pidCursor = -1;
        int memCursor = -1;
        int cmdCursor = -1;
        int cpuCursor = -1;
        int timeCursor = -1;
        if (values.length > 6) {
            String _index = values[6];
            _index = _index.trim();
            String[] _indexArray = _index.split("\\s+");
            int i = 0;
            while (i < _indexArray.length) {
                if (_indexArray[i].equals("PID")) {
                    pidCursor = i;
                } else if (_indexArray[i].equals("%CPU")) {
                    cpuCursor = i;
                } else if (_indexArray[i].equals("%MEM")) {
                    memCursor = i;
                } else if (_indexArray[i].equals("TIME+")) {
                    timeCursor = i;
                } else if (_indexArray[i].equals("COMMAND")) {
                    cmdCursor = i;
                }
                ++i;
            }
        }
        int j = 7;
        while (j < values.length) {
            OSProcessPerformance processPerformance = new OSProcessPerformance();
            String _insexProcess = values[j];
            if ((_insexProcess = _insexProcess.trim()).length() > 0) {
                String tmp;
                String[] _indexProcessArray = _insexProcess.split("\\s+");
                if (pidCursor != -1) {
                    tmp = _indexProcessArray[pidCursor];
                    tmp = tmp.trim();
                    processPerformance.setProcessId(Integer.parseInt(tmp));
                }
                if (memCursor != -1) {
                    tmp = _indexProcessArray[memCursor];
                    tmp = tmp.trim();
                    processPerformance.setProcessMemoryUsage(Double.parseDouble(tmp));
                }
                if (cmdCursor != -1) {
                    tmp = _indexProcessArray[cmdCursor];
                    tmp = tmp.trim();
                    processPerformance.setProcessName(tmp);
                }
                if (cpuCursor != -1) {
                    tmp = _indexProcessArray[cpuCursor];
                    tmp = tmp.trim();
                    processPerformance.setProcessCPUUsage(Double.parseDouble(tmp));
                }
                if (timeCursor != -1) {
                    tmp = _indexProcessArray[timeCursor];
                    tmp = tmp.trim();
                    processPerformance.setPercentProcessorTime(tmp);
                }
                processList.add(processPerformance);
            }
            ++j;
        }
        OSProcessPerformance[] processPerSortCPU = processList.toArray(new OSProcessPerformance[processList.size()]);
        PerformanceSortUtil.sortProcessPerByCPU(processPerSortCPU);
        this.osPerformance.setOSProcessUseageSortCPU(processPerSortCPU);
        OSProcessPerformance[] processPerSortMemory = processList.toArray(new OSProcessPerformance[processList.size()]);
        PerformanceSortUtil.sortProcessPerByMemory(processPerSortMemory);
        this.osPerformance.setOSProcessUseageSortMemory(processPerSortMemory);
    }

    public static void main(String[] args) {
        LinuxPerformanceInfoImp imp = new LinuxPerformanceInfoImp();
        OSPerformance osPerformance = imp.getOSPerformance();
        OSProcessPerformance[] processPerSortCPU = osPerformance.getOSProcessUseageSortCPU();
        int i = 0;
        while (i < processPerSortCPU.length) {
            OSProcessPerformance processPerformance = processPerSortCPU[i];
            System.out.print(" ");
            System.out.print(processPerformance.getPercentProcessorTime());
            System.out.print(" ");
            System.out.print(processPerformance.getProcessCPUUsage());
            System.out.print(" ");
            System.out.print(processPerformance.getProcessId());
            System.out.print(" ");
            System.out.print(processPerformance.getProcessMemoryUsage());
            System.out.print(" ");
            System.out.print(processPerformance.getProcessName());
            System.out.println();
            ++i;
        }
    }
}

