/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.sys;

import com.actionsoft.bpms.commons.log.sla.sys.LinuxPerformanceInfoImp;
import com.actionsoft.bpms.commons.log.sla.sys.OSPerformanceinfoInterface;
import com.actionsoft.bpms.commons.log.sla.sys.WindowsPerformanceInfoImp;

public class OSNow {
    OsType osType;

    public static OsType getSystemOsType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            return OsType.WINDOWS;
        }
        if (osName.indexOf("mac") >= 0) {
            return OsType.MAC;
        }
        if (osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0) {
            return OsType.LINUX;
        }
        if (osName.indexOf("sunos") >= 0) {
            return OsType.SOLARIS;
        }
        return OsType.UNKOWN;
    }

    public static boolean supportOS() {
        if (OSNow.getSystemOsType() == OsType.WINDOWS) {
            return true;
        }
        if (OSNow.getSystemOsType() == OsType.LINUX) {
            return true;
        }
        OSNow.getSystemOsType();
        return false;
    }

    public static OSPerformanceinfoInterface getPerformance() {
        OSPerformanceinfoInterface osPerformance = null;
        if (OSNow.getSystemOsType() == OsType.WINDOWS) {
            osPerformance = new WindowsPerformanceInfoImp();
        } else if (OSNow.getSystemOsType() == OsType.LINUX) {
            osPerformance = new LinuxPerformanceInfoImp();
        } else if (OSNow.getSystemOsType() == OsType.MAC) {
            osPerformance = null;
        }
        return osPerformance;
    }

    public static enum OsType {
        LINUX,
        WINDOWS,
        MAC,
        SOLARIS,
        UNKOWN;

    }
}

