/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.sys;

import com.actionsoft.bpms.commons.log.sla.sys.OSPerformance;
import com.actionsoft.bpms.commons.log.sla.sys.OSPerformanceinfoInterface;
import com.actionsoft.bpms.commons.log.sla.sys.OSProcessPerformance;
import com.actionsoft.bpms.commons.log.sla.sys.PerformanceShellUtil;
import com.actionsoft.bpms.commons.log.sla.sys.PerformanceSortUtil;
import com.actionsoft.bpms.util.UtilNumber;
import java.util.ArrayList;

public class WindowsPerformanceInfoImp
implements OSPerformanceinfoInterface {
    OSPerformance osPerformance = null;
    String[] processValues;

    public WindowsPerformanceInfoImp() {
        this.execute();
        if (this.processValues != null && this.processValues.length > 7) {
            this.osPerformance = new OSPerformance();
            this.parseCPUUsage(this.processValues);
            this.parsePhysicalMemoryUsage(this.processValues);
            this.parseTotalPhysicalMemory(this.processValues);
            this.parsePerProcessUsage(this.processValues);
        }
    }

    @Override
    public OSPerformance getOSPerformance() {
        return this.osPerformance;
    }

    private void execute() {
        String[] commands = new String[]{"strComputer = \".\"", "Set objWMIService = GetObject(\"winmgmts:\" _", "& \"{impersonationLevel=impersonate}!\\\\\" _", "& strComputer & \"\\root\\cimv2\")", "Set OperatingSystemSettings = objWMIService.ExecQuery _", "(\"Select * from Win32_OperatingSystem\")", "For Each objOperatingSystem in OperatingSystemSettings", "Set ComputerSystemSettings = objWMIService.ExecQuery _", "(\"Select * from Win32_ComputerSystem\")", "For Each objComputer in ComputerSystemSettings", "Wscript.Echo Round(objComputer.TotalPhysicalMemory/(1024*1024))", "Wscript.Echo Round((objComputer.TotalPhysicalMemory/(1024*1024)-objOperatingSystem.FreePhysicalMemory/1024))", "Next", "Next", "Set cpuTotalUsageSet1 = objWMIService.Get( _", "\"Win32_PerfRawData_PerfOS_Processor.Name='_Total'\")", "Wscript.Echo \"First Per Process Useage Start\"", "For Each perf_instance1 in objWMIService.ExecQuery(\"Select * from Win32_PerfRawData_PerfProc_Process where IDProcess != 0\")", "Wscript.Echo (perf_instance1.IDProcess&\"   \"&perf_instance1.Name&\"   \"&perf_instance1.WorkingSet/1024&\"   \"&perf_instance1.PercentProcessorTime&\"   \"&perf_instance1.TimeStamp_Sys100NS)", "Next", "Wscript.Echo \"First Per Process Useage End\"", "Wscript.Sleep(500)", "Set cpuTotalUsageSet2 = objWMIService.Get( _", "\"Win32_PerfRawData_PerfOS_Processor.Name='_Total'\")", "PercentProcessorTime = Round((1 - ((cpuTotalUsageSet2.PercentProcessorTime - cpuTotalUsageSet1.PercentProcessorTime)/(cpuTotalUsageSet2.TimeStamp_Sys100NS-cpuTotalUsageSet1.TimeStamp_Sys100NS)))*100,2)", "Wscript.Echo \"Total Percent CPU Useage=\" , PercentProcessorTime", "Wscript.Echo \"Second Per Process Useage Start\"", "For Each perf_instance2 in objWMIService.ExecQuery(\"Select * from Win32_PerfRawData_PerfProc_Process where IDProcess != 0\")", "Wscript.Echo (perf_instance2.IDProcess&\"   \"&perf_instance2.Name&\"   \"&Round(perf_instance2.WorkingSet/1024)&\"   \"&perf_instance2.PercentProcessorTime&\"   \"&perf_instance2.TimeStamp_Sys100NS&perf_instance2.Caption)", "Next", "Wscript.Echo \"Second Per Process Useage End\""};
        this.processValues = new PerformanceShellUtil().excuteVBShell(commands, "WindowsNTMonitor");
    }

    private void parseCPUUsage(String[] values) {
        String indexStr = "Total Percent CPU Useage=";
        int i = 0;
        while (values != null && i < values.length) {
            String tmp = values[i];
            if (tmp.trim().indexOf(indexStr) == 0) {
                String cpuStr = tmp.substring(indexStr.length(), tmp.length());
                this.osPerformance.setOSCPUUsage(Double.parseDouble(cpuStr));
                break;
            }
            ++i;
        }
    }

    private void parseTotalPhysicalMemory(String[] values) {
        String tmp = values[0];
        if (tmp != null && values != null) {
            double totalPhysicalMemory = Double.parseDouble(tmp);
            this.osPerformance.setOSTotalPhysicalMemory(totalPhysicalMemory);
        }
    }

    private void parsePhysicalMemoryUsage(String[] values) {
        String tmp = values[1];
        if (tmp != null && values != null) {
            double totalPhysicalMemoryUsage = Double.parseDouble(tmp);
            this.osPerformance.setOSPhysicalMemoryUsage(totalPhysicalMemoryUsage);
        }
    }

    private void parsePerProcessUsage(String[] values) {
        ArrayList<OSProcessPerformance> processListFirst = new ArrayList<OSProcessPerformance>();
        ArrayList<OSProcessPerformance> processListSecond = new ArrayList<OSProcessPerformance>();
        ArrayList<OSProcessPerformance> processListUseage = new ArrayList<OSProcessPerformance>();
        boolean firstListFlag = false;
        boolean secondListFlag = false;
        int i = 0;
        while (values != null && i < values.length) {
            String[] value;
            OSProcessPerformance processPer;
            String line = values[i];
            if (line.trim().equals("First Per Process Useage Start")) {
                firstListFlag = true;
            } else if (line.trim().equals("First Per Process Useage End")) {
                firstListFlag = false;
            } else if (line.trim().equals("Second Per Process Useage Start")) {
                secondListFlag = true;
            } else if (line.trim().equals("Second Per Process Useage End")) {
                secondListFlag = false;
            }
            if (firstListFlag && !line.trim().equals("First Per Process Useage Start")) {
                processPer = new OSProcessPerformance();
                value = line.split("   ");
                processPer.setProcessId(Integer.parseInt(value[0]));
                processPer.setProcessName(value[1]);
                processPer.setProcessMemoryUsage(Double.parseDouble(value[2]));
                processPer.setPercentProcessorTime(value[3]);
                processPer.setSys100NS(value[4]);
                processListFirst.add(processPer);
            } else if (secondListFlag && !line.trim().equals("Second Per Process Useage Start")) {
                processPer = new OSProcessPerformance();
                value = line.split("   ");
                processPer.setProcessId(Integer.parseInt(value[0]));
                processPer.setProcessName(value[1]);
                processPer.setProcessMemoryUsage(Double.parseDouble(value[2]));
                processPer.setPercentProcessorTime(value[3]);
                processPer.setSys100NS(value[4]);
                processListSecond.add(processPer);
            }
            ++i;
        }
        block1: for (OSProcessPerformance processPerFirst : processListFirst) {
            for (OSProcessPerformance processPerSecond : processListSecond) {
                if (processPerFirst.getProcessId() != processPerSecond.getProcessId()) continue;
                String Nd = UtilNumber.sub(processPerSecond.getPercentProcessorTime(), processPerFirst.getPercentProcessorTime());
                String Dd = UtilNumber.sub(processPerSecond.getSys100NS(), processPerFirst.getSys100NS());
                double tmpD = Double.parseDouble(UtilNumber.div(Nd, Dd, 4));
                tmpD = UtilNumber.fixPoint(tmpD * 100.0, 2);
                processPerSecond.setProcessCPUUsage(tmpD);
                processListUseage.add(processPerSecond);
                continue block1;
            }
        }
        OSProcessPerformance[] processPerSortCPU = processListSecond.toArray(new OSProcessPerformance[processListSecond.size()]);
        PerformanceSortUtil.sortProcessPerByCPU(processPerSortCPU);
        this.osPerformance.setOSProcessUseageSortCPU(processPerSortCPU);
        OSProcessPerformance[] processPerSortMemory = processListSecond.toArray(new OSProcessPerformance[processListSecond.size()]);
        PerformanceSortUtil.sortProcessPerByMemory(processPerSortMemory);
        this.osPerformance.setOSProcessUseageSortMemory(processPerSortMemory);
    }
}

