/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.log.sla.web;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.event.AppEventBus;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.AWSPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.cluster.loadbalancer.NodeModel;
import com.actionsoft.bpms.commons.database.DBUtils;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.echarts.model.BarSeries;
import com.actionsoft.bpms.commons.echarts.model.Legend;
import com.actionsoft.bpms.commons.echarts.model.LineSeries;
import com.actionsoft.bpms.commons.echarts.model.TextStyle;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.log.sla.SLAUtil;
import com.actionsoft.bpms.commons.log.sla.collection.core.collector.MVCCmdCollector;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricData;
import com.actionsoft.bpms.commons.log.sla.collection.core.data.MetricWebCollection;
import com.actionsoft.bpms.commons.log.sla.collection.util.CollectionUtil;
import com.actionsoft.bpms.commons.log.sla.dao.SLAAlarmEventDao;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataDDao;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataHDao;
import com.actionsoft.bpms.commons.log.sla.dao.SLACollectionDataMDao;
import com.actionsoft.bpms.commons.log.sla.model.DBTrackModel;
import com.actionsoft.bpms.commons.log.sla.model.SLAAlarmEvent;
import com.actionsoft.bpms.commons.log.sla.model.SLACollectionData;
import com.actionsoft.bpms.commons.log.sla.model.ThreadTrackModel;
import com.actionsoft.bpms.commons.log.sla.sizeof.SizeOf;
import com.actionsoft.bpms.commons.log.sla.sizeof.SizeOfFilter;
import com.actionsoft.bpms.commons.log.sla.sys.OSNow;
import com.actionsoft.bpms.commons.log.sla.sys.OSPerformanceinfoInterface;
import com.actionsoft.bpms.commons.log.sla.sys.OSProcessPerformance;
import com.actionsoft.bpms.commons.mvc.dao.IDaoQuery;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.conf.sla.AWSSLAConf;
import com.actionsoft.bpms.server.conf.sla.ResourceMetric;
import com.actionsoft.bpms.server.conf.sla.SLAAlarm;
import com.actionsoft.bpms.server.monitor.ThreadMonit;
import com.actionsoft.bpms.server.monitor.ThreadTopModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.ThreadStackTraceInfo;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.framework.io.Exchange;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.SLAAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;

public class SLAWeb
extends ActionWeb {
    private static final int I18N_METRIC = 0;
    private static final int I18N_ALARM = 1;
    private static final int I18N_RESOURCE = 2;
    private static final String MVC_FIVE_SEC = "mvc_five_sec";
    private static final String MVC_ONE_MIN = "mvc_one_min";
    private static final String CPU_FIVE_SEC = "cpu_five_sec";
    private static final String CPU_ONE_MIN = "cpu_one_min";
    private static final String MVC_EXEC_FIVE_SEC = "mvc_exec_five_sec";
    private static final String JVM_FIVE_SEC = "jvm_five_sec";
    private static final String JVM_ONE_MIN = "jvm_one_min";
    private static final String TYPE_METRIC_TREND = "trend";
    private static final String TRACK_THREAD = "thread";
    private static final String TRACK_THREAD_TOPN = "thread-topN";
    private static final String TRACK_THREAD_ALL = "threadAll";
    private static final String TRACK_PROCESS = "process";
    public static final String TRACK_DATABASE = "database";
    private static final String[] WEB_CMDS = new String[]{"MVCFramework.webCmd", "MVCFramework.loginTime", "MVCFramework.dataCmd", "MVCFramework.aslpExecute", "MVCFramework.upfileCmd", "MVCFramework.downfileCmd"};
    private static final String[] DB_CMDS = new String[]{"LocalDatabase.execute", "LocalDatabase.failing", "LocalDatabase.activeSize", "LocalDatabase.idleSize", "LocalDatabase.poolSize"};

    public String getHome(String menu) {
        if (UtilString.isEmpty(menu)) {
            menu = "Realtime";
        }
        switch (menu) {
            case "Realtime": {
                return this.getNav2Realtime();
            }
            case "Infrastructure": {
                return this.getNav2Infrastructure();
            }
            case "MVCFramework": {
                return this.getNav2MVC();
            }
            case "nav_warn": {
                return this.getNav2Alarm();
            }
            case "LocalDatabase": {
                return this.getNav2Database();
            }
            case "Cache": {
                return this.getCache();
            }
            case "AppContainer": {
                return this.getAppContainer();
            }
            case "ProcessEngine": {
                return this.getProcessEngine();
            }
            case "FormEngine": {
                return this.getFormEngine();
            }
            case "CC": {
                return this.getCC();
            }
            case "SecurityRisk": {
                return this.getRisk();
            }
            case "AlarmConf": {
                return this.getAlarmRule();
            }
            case "Trend": {
                return this.getTrend();
            }
            case "Diagnosis": {
                return this.getDiagnosis();
            }
        }
        return "<div style='width:80%' align=center><br/><br/>\u6682\u672a\u5b9e\u73b0</div>";
    }

    public String getData(String type, String params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        if (MVC_EXEC_FIVE_SEC.equals(type)) {
            Map<Long, Long> raw = MVCCmdCollector.getSecondAvgTime();
            this.setMVCValue(ro, raw, 5, true);
        } else if (MVC_FIVE_SEC.equals(type)) {
            Map<Long, Long> raw = MVCCmdCollector.getSecondData();
            this.setMVCValue(ro, raw, 5, false);
        } else if (MVC_ONE_MIN.equals(type)) {
            Map<Long, Long> raw = MVCCmdCollector.getMinuteData();
            this.setMVCValue(ro, raw, 60, false);
        } else if (CPU_FIVE_SEC.equals(type)) {
            MetricData[] datas = MetricWebCollection.getData("cpu", true);
            ro.put("seria", SLAWeb.getCPUValues(datas, 24));
            ro.put("xAxis", SLAWeb.getTimexAxis(datas, 24, 5));
        } else if (CPU_ONE_MIN.equals(type)) {
            MetricData[] datas = MetricWebCollection.getData("cpu", false);
            ro.put("seria", SLAWeb.getCPUValues(datas, 24));
            ro.put("xAxis", SLAWeb.getTimexAxis(datas, 24, 60));
        } else if (JVM_FIVE_SEC.equals(type)) {
            MetricData[] maxJVM = SLAWeb.getMetricData("maxJVMMemory", true);
            MetricData[] maxPhysical = SLAWeb.getMetricData("maxPhysicalMemory", true);
            MetricData[] freePhysical = SLAWeb.getMetricData("freePhysicalMemory", true);
            JSONArray ja = new JSONArray();
            ja.add(SLAWeb.getMemValues(maxPhysical, 24));
            ja.add(SLAWeb.getMemValues(freePhysical, 24));
            ja.add(SLAWeb.getMemValues(maxJVM, 24));
            ro.put("seria", ja);
            ro.put("xAxis", SLAWeb.getTimexAxis(maxJVM, 24, 5));
        } else if (JVM_ONE_MIN.equals(type)) {
            MetricData[] maxJVM = SLAWeb.getMetricData("maxJVMMemory", false);
            MetricData[] maxPhysical = SLAWeb.getMetricData("maxPhysicalMemory", false);
            MetricData[] freePhysical = SLAWeb.getMetricData("freePhysicalMemory", false);
            JSONArray ja = new JSONArray();
            ja.add(SLAWeb.getMemValues(maxPhysical, 24));
            ja.add(SLAWeb.getMemValues(freePhysical, 24));
            ja.add(SLAWeb.getMemValues(maxJVM, 24));
            ro.put("seria", ja);
            ro.put("xAxis", SLAWeb.getTimexAxis(maxJVM, 24, 60));
        } else if (type.startsWith("cpu_swith")) {
            this.getCpuData(ro, type);
        } else if (type.startsWith("mem_swith")) {
            this.getMemData(ro, type);
        } else if (type.startsWith("mvc_swith")) {
            this.getMVCData(ro, type);
        } else if (type.startsWith("throughput_swith")) {
            this.getThroughputData(ro, type);
        } else if (type.startsWith("online_swith")) {
            this.getOnlineData(ro, type);
        } else if (type.startsWith("loginTime_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("webCmd_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("dataCmd_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("aslpExecute_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("upfileCmd_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("downfileCmd_swith")) {
            this.getSlaData(ro, "MVCFramework." + type.substring(0, type.indexOf(95)), type);
        } else if (type.startsWith("db_")) {
            this.getDataOfDB(ro, type.substring(3, type.indexOf(95, 3)), type);
        } else if ("thread-info".equals(type)) {
            ro.put("list", this.getRuntimeMonitor(TRACK_THREAD));
            ro.put("threadCount", ThreadMonit.size());
        } else if (TRACK_THREAD_TOPN.equals(type)) {
            ro.put("list", this.getRuntimeMonitor(TRACK_THREAD_TOPN));
            ro.put("threadCount", ThreadMonit.size());
        } else if (TRACK_THREAD_ALL.equals(type)) {
            ro.put("list", this.getRuntimeMonitor(TRACK_THREAD_ALL));
            ro.put("threadCount", Thread.activeCount());
        } else if ("process-info".equals(type)) {
            ro.put("list", this.getRuntimeMonitor(TRACK_PROCESS));
            ro.put("threadCount", ThreadMonit.size());
        } else if ("database-info".equals(type)) {
            ro.setData(this.getRuntimeMonitor(TRACK_DATABASE));
        } else if (TYPE_METRIC_TREND.equals(type)) {
            this.setMetricTrend(ro, params);
        } else if ("Diagnosis".equals(type)) {
            this.setMetricDiagnosis(ro, params);
        } else if (type.startsWith("container")) {
            String t = type.substring(type.indexOf(95) + 1);
            this.getSlaData(ro, "AppContainer." + t.substring(0, t.indexOf(95)), type);
        } else if (type.startsWith("SecurityRisk")) {
            String t = type;
            this.getSlaData(ro, t.substring(0, t.indexOf(95)), type);
        } else if (type.startsWith("ProcessEngine")) {
            String t = type;
            this.getSlaData(ro, t.substring(0, t.indexOf(95)), type);
        } else if (type.startsWith("FormEngine")) {
            String t = type;
            this.getSlaData(ro, t.substring(0, t.indexOf(95)), type);
        } else if (type.startsWith("alarm_evt_")) {
            ro.setData(this.getAlarmEvts(type));
        } else if (type.equalsIgnoreCase("FreList")) {
            this.setFreList(ro, params);
        }
        return ro.toString();
    }

    private String getAlarmRule() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        List<SLAAlarm> alarms = AWSSLAConf.getAlarms();
        List<ResourceMetric> metrics = AWSSLAConf.getMetricsOfSort();
        ArrayList<String[]> metricStr = new ArrayList<String[]>();
        for (ResourceMetric metric : metrics) {
            metricStr.add(new String[]{metric.getId(), this.getMetricFullName(metric.getId())});
        }
        for (SLAAlarm alarm : alarms) {
            String s = this.getAlarmItem(alarm, metricStr, false);
            sb.append(s);
        }
        String create = this.getAlarmItem(new SLAAlarm(), metricStr, true);
        sb.append(create);
        macroLibraries.put("list", sb);
        macroLibraries.put("isSLA", AWSSLAConf.isService() ? "checked" : "");
        return this.merge("console.sla.rule.htm", macroLibraries);
    }

    private String getAlarmItem(SLAAlarm alarm, List<String[]> metricStr, boolean create) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("isService", alarm.isService() ? "checked" : "");
        vars.put("name", create ? "<input type=\"text\" class=\"txt\"/>" : "<input type=\"hidden\" class=\"txt\" value='" + alarm.getName() + "'/>" + this.getI18N(alarm.getName(), 1));
        String metric = this.getSelect(alarm.getWhen(), (String[][])metricStr.toArray((T[])new String[0][0]), 180);
        vars.put("metric", metric);
        String happen = this.getSelect(alarm.getHappen(), new String[][]{{"realtime", "\u5373\u65f6"}, {"5minute", "5\u5206\u949f"}, {"1hour", "1\u5c0f\u65f6"}, {"1day", "1\u5929"}});
        vars.put("happen", happen);
        String scope = this.getSelect(alarm.getScope(), new String[][]{{"max", "\u6700\u5927\u503c"}, {"avg", "\u5e73\u5747\u503c"}, {"min", "\u6700\u5c0f\u503c"}, {"count", "\u6b21\u6570"}});
        vars.put("scope", scope);
        String condition = this.getSelect(alarm.getCondition(), new String[][]{{"is greater than", "\u5927\u4e8e"}, {"is less than", "\u5c0f\u4e8e"}}, 45);
        vars.put("condition", condition);
        vars.put("continuous", alarm.getContinuous());
        vars.put("value", alarm.getValue());
        String l = alarm.getLevel() == 0 ? "info" : (alarm.getLevel() == 2 ? "err" : "warn");
        String level = this.getSelect(l, new String[][]{{"warn", "warn"}, {"info", "info"}, {"err", "err"}}, 45);
        vars.put("level", level);
        String ops = create ? "<button tid='add' type=\"button\" class=\"button green\">\u6dfb\u52a0</button>" : "<button tid='save' type=\"button\" class=\"button\">\u4fdd\u5b58</button><button tid='delete' type=\"button\" class=\"button red\">\u5220\u9664</button>";
        vars.put("ops", ops);
        String s = this.merge("console.sla.rule.item.htm", vars);
        return s;
    }

    private String getTrend() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        JSONObject jo = new JSONObject();
        List metrics = SDK.getSLAAPI().getMetrics();
        for (ResourceMetric mt : metrics) {
            jo.put(this.getI18N(mt.getId(), 0), (Object)mt.getUnit());
        }
        macroLibraries.put("metricJson", jo);
        return this.merge("console.sla.trend.htm", macroLibraries);
    }

    private String getDiagnosis() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        return this.merge("console.sla.diagnosis.htm", macroLibraries);
    }

    private String getSelect(String v, String[][] ops, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append("<select style=\"width:" + width + "px;\" class=\"awsui-select\">");
        String[][] stringArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            String[] op = stringArray[n2];
            sb.append("<option value=\"" + op[0] + "\"" + (op[0].equals(v) ? " selected" : "") + ">" + op[1] + "</option>");
            ++n2;
        }
        sb.append("</select>");
        return sb.toString();
    }

    private String getSelect(String v, String[][] ops) {
        return this.getSelect(v, ops, 80);
    }

    private String getAppContainer() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        return this.merge("console.sla.container.htm", macroLibraries);
    }

    private String getProcessEngine() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        return this.merge("console.sla.process.htm", macroLibraries);
    }

    private String getFormEngine() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        return this.merge("console.sla.form.htm", macroLibraries);
    }

    private String getCC() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        return this.merge("console.sla.cc.htm", macroLibraries);
    }

    private String getRisk() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        return this.merge("console.sla.risk.htm", macroLibraries);
    }

    private String getCache() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        List<String> nodes = this.getServerNodes();
        JSONArray ja = new JSONArray();
        JSONObject jo = new JSONObject();
        jo.put("value", (Object)AWSServerConf.getInstanceName());
        jo.put("title", (Object)AWSServerConf.getInstanceName());
        ja.add((Object)jo);
        for (String i : nodes) {
            JSONObject t = new JSONObject();
            t.put("value", (Object)i);
            t.put("title", (Object)i);
            ja.add((Object)t);
        }
        macroLibraries.put("insts", ja.toString());
        return this.merge("console.sla.cache.htm", macroLibraries);
    }

    private List<String> getServerNodes() {
        ArrayList<String> s = new ArrayList<String>();
        List list = ClusterAPI.getSERVERS();
        if (list != null) {
            for (NodeModel n : list) {
                if (n.getStatus() != 0) continue;
                s.add(n.getId());
            }
        }
        return s;
    }

    private String getNav2Database() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        int i = 0;
        while (i < DB_CMDS.length) {
            macroLibraries.put("sla_title" + (i + 1), this.getI18N(DB_CMDS[i], 0));
            ++i;
        }
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        this.setClusterNodes(macroLibraries);
        macroLibraries.put("list", this.getRuntimeMonitor(TRACK_DATABASE));
        macroLibraries.put("sid", this.getSIDFlag());
        return this.merge("console.sla.database.htm", macroLibraries);
    }

    private String getNav2Alarm() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONArray jo = new JSONArray();
        List metrics = SDK.getSLAAPI().getMetrics();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < metrics.size()) {
            if (!names.contains(((ResourceMetric)metrics.get(i)).getResourceName())) {
                names.add(((ResourceMetric)metrics.get(i)).getResourceName());
            }
            ++i;
        }
        i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            JSONObject treeNode = new JSONObject();
            treeNode.put("id", (Object)name);
            treeNode.put("name", (Object)name);
            treeNode.put("open", (Object)true);
            jo.add((Object)treeNode);
            int j = 0;
            while (j < metrics.size()) {
                if (((ResourceMetric)metrics.get(j)).getResourceName().equals(name)) {
                    JSONObject met = new JSONObject();
                    met.put("id", (Object)((ResourceMetric)metrics.get(j)).getId());
                    met.put("name", (Object)((ResourceMetric)metrics.get(j)).getName());
                    met.put("pid", (Object)name);
                    met.put("checked", (Object)false);
                    jo.add((Object)met);
                }
                ++j;
            }
            ++i;
        }
        macroLibraries.put("clusterNodes", this.getNodeSelect(true));
        macroLibraries.put("metric_tree_data", jo);
        macroLibraries.put("sid", this.getSIDFlag());
        return this.merge("console.sla.alarm.htm", macroLibraries);
    }

    private String getNav2MVC() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONArray jo = new JSONArray();
        List metrics = SDK.getSLAAPI().getMetrics();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < metrics.size()) {
            if (!names.contains(((ResourceMetric)metrics.get(i)).getResourceName())) {
                names.add(((ResourceMetric)metrics.get(i)).getResourceName());
            }
            ++i;
        }
        i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            JSONObject treeNode = new JSONObject();
            treeNode.put("id", (Object)name);
            treeNode.put("name", (Object)name);
            treeNode.put("open", (Object)true);
            jo.add((Object)treeNode);
            int j = 0;
            while (j < metrics.size()) {
                if (((ResourceMetric)metrics.get(j)).getResourceName().equals(name)) {
                    JSONObject met = new JSONObject();
                    met.put("id", (Object)((ResourceMetric)metrics.get(j)).getId());
                    met.put("name", (Object)((ResourceMetric)metrics.get(j)).getName());
                    met.put("pid", (Object)name);
                    met.put("checked", (Object)false);
                    jo.add((Object)met);
                }
                ++j;
            }
            ++i;
        }
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        macroLibraries.put("metric_tree_data", jo);
        macroLibraries.put("sid", this.getSIDFlag());
        JSONArray cmdNames = new JSONArray();
        int i2 = 0;
        while (i2 < WEB_CMDS.length) {
            cmdNames.add((Object)this.getI18N(WEB_CMDS[i2], 0));
            macroLibraries.put("cmdNames" + (i2 + 1), this.getI18N(WEB_CMDS[i2], 0));
            ++i2;
        }
        macroLibraries.put("cmdNames", cmdNames.toString());
        return this.merge("console.sla.mvc.htm", macroLibraries);
    }

    public String getMetricList(String check, String use) {
        int units = -1;
        String tmp = use;
        if (tmp.indexOf(95) != -1) {
            use = tmp.substring(0, tmp.indexOf(95));
            units = Integer.parseInt(tmp.substring(tmp.indexOf(95) + 1));
        }
        ArrayList jo = new ArrayList();
        List metrics = SDK.getSLAAPI().getMetrics();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < metrics.size()) {
            if (!names.contains(((ResourceMetric)metrics.get(i)).getResourceName())) {
                names.add(((ResourceMetric)metrics.get(i)).getResourceName());
            }
            ++i;
        }
        i = 0;
        while (i < names.size()) {
            block15: {
                String name = (String)names.get(i);
                if (!"ALL".equalsIgnoreCase(use) && !this.isResourceExistAlarm(name)) break block15;
                HashMap<String, Object> treeNode = null;
                int j = 0;
                while (j < metrics.size()) {
                    block16: {
                        block18: {
                            block17: {
                                if (!((ResourceMetric)metrics.get(j)).getResourceName().equals(name)) break block16;
                                if ("ALL".equalsIgnoreCase(use)) break block17;
                                if (this.isMetricAlarm(((ResourceMetric)metrics.get(j)).getId())) break block18;
                                break block16;
                            }
                            boolean ok = false;
                            if (units == 1) {
                                if (!((ResourceMetric)metrics.get(j)).getUnit().equalsIgnoreCase("times")) {
                                    ok = true;
                                }
                            } else if (units == 2 && ((ResourceMetric)metrics.get(j)).getUnit().equalsIgnoreCase("times")) {
                                ok = true;
                            }
                            if (!ok) break block16;
                        }
                        if (treeNode == null) {
                            treeNode = new HashMap<String, Object>();
                            treeNode.put("id", name);
                            treeNode.put("mid", name);
                            treeNode.put("resourceName", true);
                            treeNode.put("name", this.getTitle(name, name, true));
                            treeNode.put("open", false);
                            treeNode.put("checked", check.contains(name));
                            jo.add(treeNode);
                        }
                        HashMap<String, Object> met = new HashMap<String, Object>();
                        met.put("id", UUIDGener.getUUID());
                        met.put("name", this.getTitle(((ResourceMetric)metrics.get(j)).getName(), ((ResourceMetric)metrics.get(j)).getId(), false));
                        met.put("mid", ((ResourceMetric)metrics.get(j)).getId());
                        met.put("pid", name);
                        if (check.contains(((ResourceMetric)metrics.get(j)).getId())) {
                            met.put("checked", true);
                            treeNode.put("open", true);
                        }
                        jo.add(met);
                    }
                    ++j;
                }
            }
            ++i;
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("data", JSONArray.parseArray((String)JSON.toJSONString(jo)));
        macroLibraries.put("sid", this.getSIDFlag());
        return this.merge("console.sla.metrictree.htm", macroLibraries);
    }

    public String getCacheData(String filter) {
        filter = filter.toUpperCase();
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONArray caches = new JSONArray();
        List list = AppsAPIManager.getInstance().getInstalledApps();
        SizeOf sizeof = SizeOf.newInstance(new SizeOfFilter[0]);
        for (AppContext app : list) {
            List pluginProfile;
            if (!AppsAPIManager.getInstance().isActive(app) || (pluginProfile = AppEventBus.getInstance().handlePluginEvent(app)) == null) continue;
            for (AWSPluginProfile p : pluginProfile) {
                String s2;
                if (!(p instanceof CachePluginProfile)) continue;
                CachePluginProfile cp = (CachePluginProfile)p;
                if (!UtilString.isEmpty(filter) && !app.getId().toUpperCase().contains(filter) && !app.getName().toUpperCase().contains(filter) && !cp.getName().toUpperCase().contains(filter)) continue;
                JSONObject jo = new JSONObject();
                jo.put("inst", (Object)AWSServerConf.getInstanceName());
                jo.put("app", (Object)app.getName());
                jo.put("cache", (Object)cp.getName());
                Cache<?, ?> c = CacheManager.getCache(cp.getName());
                jo.put("size", (Object)(c == null ? -1 : c.size()));
                jo.put("sizeof", (Object)(c == null ? -1.0 : UtilNumber.fixPoint(((double)sizeof.deepSizeOf(c) + 0.0) / 1024.0 / 1024.0, 1)));
                long ut = c.getUpdateTime();
                jo.put("lastUpdate", (Object)(ut == -1L ? "" : UtilDate.datetimeFormat(new Date(ut))));
                ArrayList<String> t = new ArrayList<String>();
                List ss = c.getOpsTrace().get();
                for (String s2 : ss) {
                    String[] st = s2.split("\\|");
                    t.add(String.valueOf(st[0]) + ", " + (st[1].equals("add") ? "\u66f4\u65b0" : "\u5220\u9664") + ": " + st[2]);
                }
                Collections.reverse(t);
                s2 = "<button type=\"button\" class=\"button green\" " + Html.toHtmlJSEvent("onclick", "openStactTraceInfo", new Object[]{t}) + " border='0'>\u8be6\u7ec6</button>";
                jo.put("lastOps", (Object)s2);
                caches.add((Object)jo);
            }
        }
        ArrayList tlist = new ArrayList(caches);
        Collections.sort(tlist, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                return o2.getIntValue("size") - o1.getIntValue("size");
            }
        });
        ro.setData(tlist);
        return ro.toString();
    }

    private boolean isResourceExistAlarm(String res) {
        for (SLAAlarm alarm : AWSSLAConf.getAlarms()) {
            if (!alarm.getWhen().startsWith(String.valueOf(res) + ".")) continue;
            return true;
        }
        return false;
    }

    private boolean isMetricAlarm(String metric) {
        for (SLAAlarm alarm : AWSSLAConf.getAlarms()) {
            if (!alarm.getWhen().equals(metric)) continue;
            return true;
        }
        return false;
    }

    private String getNav2Infrastructure() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        macroLibraries.put("sid", this.getSIDFlag());
        this.setClusterNodes(macroLibraries);
        macroLibraries.put("style", OSNow.supportOS() ? "" : "display:none;");
        return this.merge("console.sla.infrastructure.htm", macroLibraries);
    }

    private void setClusterNodes(Map<String, Object> macroLibraries) {
        HashSet<String> instIds = new HashSet<String>();
        instIds.add(AWSServerConf.getInstanceName());
        List<String> list = this.getServerNodes();
        for (String serverNode : list) {
            instIds.add(serverNode);
        }
        macroLibraries.put("cluster_nodes", JSONArray.parseArray((String)JSON.toJSONString(instIds)));
    }

    private String getNav2Realtime() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        JSONArray jo = new JSONArray();
        List metrics = SDK.getSLAAPI().getMetrics();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < metrics.size()) {
            if (!names.contains(((ResourceMetric)metrics.get(i)).getResourceName())) {
                names.add(((ResourceMetric)metrics.get(i)).getResourceName());
            }
            ++i;
        }
        i = 0;
        while (i < names.size()) {
            String name = (String)names.get(i);
            JSONObject treeNode = new JSONObject();
            treeNode.put("id", (Object)name);
            treeNode.put("name", (Object)name);
            treeNode.put("open", (Object)true);
            jo.add((Object)treeNode);
            int j = 0;
            while (j < metrics.size()) {
                if (((ResourceMetric)metrics.get(j)).getResourceName().equals(name)) {
                    JSONObject met = new JSONObject();
                    met.put("id", (Object)((ResourceMetric)metrics.get(j)).getId());
                    met.put("name", (Object)((ResourceMetric)metrics.get(j)).getName());
                    met.put("pid", (Object)name);
                    met.put("checked", (Object)false);
                    jo.add((Object)met);
                }
                ++j;
            }
            ++i;
        }
        macroLibraries.put("clusterNodes", this.getNodeSelect());
        macroLibraries.put("metric_tree_data", jo);
        macroLibraries.put("sid", this.getSIDFlag());
        return this.merge("console.sla.htm", macroLibraries);
    }

    private String getNodeSelect() {
        return this.getNodeSelect(false);
    }

    private String getNodeSelect(boolean selectpls) {
        StringBuilder sb = new StringBuilder();
        if (AWSServerConf.isClusterService()) {
            sb.append("<select id='SEL-InstId' onchange=\"changeCluster(this);return false;\" class='sla-select'>");
            if (!selectpls) {
                sb.append("<option value='" + AWSServerConf.getInstanceName() + "' SELECTED>" + AWSServerConf.getInstanceName() + "</option>");
            } else {
                sb.append("<option value=''>\u8bf7\u9009\u62e9</option>");
                sb.append("<option value='" + AWSServerConf.getInstanceName() + "'>" + AWSServerConf.getInstanceName() + "</option>");
            }
            List<String> nodes = this.getServerNodes();
            if (nodes != null) {
                for (String sn : nodes) {
                    sb.append("<option value='" + sn + "'>" + sn + "</option>");
                }
            }
            sb.append("</select>");
        }
        return sb.toString();
    }

    private void setFreList(ResponseObject ro, String params) {
        List<RowMap> list = null;
        if ("1".equals(params)) {
            list = DBSql.getMaps("select distinct VTIME from " + new SLACollectionDataMDao().entityName(), new Object[0]);
        } else if ("2".equals(params)) {
            list = DBSql.getMaps("select distinct VTIME from " + new SLACollectionDataHDao().entityName(), new Object[0]);
        } else if ("3".equals(params)) {
            list = DBSql.getMaps("select distinct VTIME from " + new SLACollectionDataDDao().entityName(), new Object[0]);
        }
        ArrayList<String> t = new ArrayList<String>();
        if (list != null) {
            for (RowMap r : list) {
                t.add(r.getString("VTIME"));
            }
        }
        Collections.sort(t, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return (int)(Long.parseLong(o2) - Long.parseLong(o1));
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String s : t) {
            sb.append("<option value=\"" + s + "\">" + SLAWeb.ftTime(s) + "</option>");
        }
        ro.put("ops", sb.toString());
    }

    private String getAlarmEvts(String type) {
        String t;
        String level = t = type.substring("alarm_evt_".length());
        String metricGroup = null;
        if (t.indexOf(58) != -1) {
            metricGroup = t.split(":")[0];
            level = t.split(":")[1];
        }
        String inst = AWSServerConf.getInstanceName();
        SLAAlarmEventDao dao = new SLAAlarmEventDao();
        List<Object> evts = new ArrayList();
        String LV = "";
        if ("all".equals(level)) {
            evts = metricGroup != null ? (AWSServerConf.isOracle() ? dao.query("METRICID like ? AND INSTNAME=?", String.valueOf(metricGroup) + "%", inst).orderBy("EVENTTIME").desc().list(0, 5) : dao.query("INSTNAME=? AND METRICID like ?", inst, String.valueOf(metricGroup) + "%").orderBy("EVENTTIME").desc().list(0, 5)) : dao.query("INSTNAME=?", inst).orderBy("EVENTTIME").desc().list(0, 5);
        } else {
            int lv = 2;
            LV = "\u9519\u8bef";
            if (type.indexOf("notify") != -1) {
                lv = 0;
                LV = "\u901a\u77e5";
            } else if (type.indexOf("warn") != -1) {
                lv = 1;
                LV = "\u8b66\u544a";
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(4, -1);
            evts = metricGroup != null ? (AWSServerConf.isOracle() ? dao.query("METRICID like ? AND ALARMLEVEL=? AND INSTNAME=? AND EVENTTIME>?", String.valueOf(metricGroup) + "%", lv, inst, calendar.getTime()).orderBy("EVENTTIME").desc().list(0, 5) : dao.query("INSTNAME=? AND ALARMLEVEL=? AND METRICID like ? AND EVENTTIME>?", inst, lv, String.valueOf(metricGroup) + "%", calendar.getTime()).orderBy("EVENTTIME").desc().list(0, 5)) : dao.query("INSTNAME=? AND ALARMLEVEL=? AND EVENTTIME>?", inst, lv, calendar.getTime()).orderBy("EVENTTIME").desc().list(0, 5);
        }
        HashMap<Integer, String> styles = new HashMap<Integer, String>();
        styles.put(2, "evt-type-err");
        styles.put(0, "evt-type-info");
        styles.put(1, "evt-type-warn");
        StringBuilder sb = new StringBuilder();
        if (UtilString.isEmpty(evts)) {
            sb.append("<tr>");
            sb.append("<td class=\"evt-col-info\">\u8fd1\u4e00\u5468\u6ca1\u6709" + LV + "\u544a\u8b66</td>");
            sb.append("</tr>");
        } else {
            for (SLAAlarmEvent evt : evts) {
                sb.append("<tr onclick='openDetail(\"" + evt.getId() + "\",this);return false;'>");
                String levelName = "\u901a\u77e5";
                if (evt.getAlarmLevel() == 2) {
                    levelName = "\u9519\u8bef";
                } else if (evt.getAlarmLevel() == 1) {
                    levelName = "\u8b66\u544a";
                }
                sb.append("<td class=\"evt-col-info\"><span class=\"evt-type " + (String)styles.get(evt.getAlarmLevel()) + "\">" + levelName + "</span><span" + (evt.isRead() ? "" : " class='noreadStyle'") + ">" + this.getI18N(evt.getAlarmName(), 1) + "</span></td>");
                sb.append("<td class= \"evt-col-date font-style\" align=\"right\">" + UtilDate.datetimeFormat(evt.getEventTime()) + "</td>");
                sb.append("</tr>");
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmm");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -365);
        System.out.println(UtilDate.dateFormat(c.getTime()));
    }

    private void setMVCValue(ResponseObject ro, Map<Long, Long> raw, int intevel, boolean xaxis) {
        ArrayList<String> x = new ArrayList<String>();
        ArrayList<Object> y = new ArrayList<Object>();
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date first = null;
        for (Map.Entry<Long, Long> e : raw.entrySet()) {
            if (first == null) {
                first = new Date(e.getKey());
            }
            x.add(sdf.format(new Date(e.getKey())));
            y.add(e.getValue());
        }
        int nowSize = x.size();
        if (nowSize < 12) {
            Calendar c = Calendar.getInstance();
            int i = 0;
            while (i < 12 - nowSize) {
                c.add(13, -intevel);
                x.add(0, sdf.format(c.getTime()));
                y.add(0, "");
                ++i;
            }
        }
        if (xaxis) {
            ro.put("xAxis", SLAWeb.getTimexAxis(12, 5));
            ro.put("seria", y);
        } else {
            ro.setData(y);
        }
    }

    private void getMVCData(ResponseObject ro, String type) {
        JSONArray seria = new JSONArray();
        List<String> ts = SLAWeb.getSLATimeList(type);
        String[] stringArray = WEB_CMDS;
        int n = WEB_CMDS.length;
        int n2 = 0;
        while (n2 < n) {
            String metricId = stringArray[n2];
            List<Object> value = SLAWeb.queryMetric(ts, metricId, type);
            seria.add(value);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
        ro.put("legend", this.getLegend(WEB_CMDS));
    }

    private List<String> getLegend(String[] metrics) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            String metric = stringArray[n2];
            list.add(this.getI18N(metric, 0));
            ++n2;
        }
        return list;
    }

    private static List<Object> queryMetric(List<String> slaTime, String metricId, String type) {
        List list = SLAWeb.queryMetric(metricId, type);
        ResourceMetric metric = SDK.getSLAAPI().getMetric(metricId);
        HashMap<String, Object> value = new HashMap<String, Object>();
        if (list != null) {
            for (Object obj : list) {
                SLACollectionData sLACollectionDataOfMinute = (SLACollectionData)obj;
                value.put(sLACollectionDataOfMinute.getvTime(), SLAWeb.getUnitValue(sLACollectionDataOfMinute, metric));
            }
        }
        ArrayList<Object> r = new ArrayList<Object>();
        Object o = null;
        for (String s : slaTime) {
            o = value.get(s);
            r.add(o == null ? "" : o);
        }
        return r;
    }

    private static List queryMetric(String metricId, String type) {
        List list = null;
        String inst = AWSServerConf.getInstanceName();
        if (type.endsWith("m")) {
            list = SDK.getSLAAPI().queryMinuteDataByMetricId(inst, metricId);
        } else if (type.endsWith("h")) {
            list = SDK.getSLAAPI().queryHourDataByMetricId(inst, metricId);
        } else if (type.endsWith("d")) {
            list = SDK.getSLAAPI().queryDayDataByMetricId(inst, metricId);
        }
        return list;
    }

    private static Object[] queryMetricValus(List<String> slaTime, String metricId, String type) {
        ResourceMetric metric;
        List list = SLAWeb.queryMetric(metricId, type);
        HashMap<String, SLACollectionData> value = new HashMap<String, SLACollectionData>();
        if (list != null) {
            for (Object obj : list) {
                SLACollectionData sLACollectionDataOfMinute = (SLACollectionData)obj;
                value.put(sLACollectionDataOfMinute.getvTime(), sLACollectionDataOfMinute);
            }
        }
        if ((metric = SDK.getSLAAPI().getMetric(metricId)) != null && metric.getUnit().equals("times")) {
            ArrayList<Object> c = new ArrayList<Object>();
            SLACollectionData o = null;
            for (String s : slaTime) {
                o = (SLACollectionData)value.get(s);
                c.add(o == null ? "" : Double.valueOf(UtilNumber.fixPoint(o.getvCount(), 1)));
            }
            return new Object[]{c};
        }
        ArrayList<Object> max = new ArrayList<Object>();
        ArrayList<Object> avg = new ArrayList<Object>();
        ArrayList<Object> min = new ArrayList<Object>();
        SLACollectionData o = null;
        for (String s : slaTime) {
            o = (SLACollectionData)value.get(s);
            max.add(o == null ? "" : Double.valueOf(UtilNumber.fixPoint(o.getvMax(), 1)));
            avg.add(o == null ? "" : Double.valueOf(UtilNumber.fixPoint(o.getvAvg(), 1)));
            min.add(o == null ? "" : Double.valueOf(UtilNumber.fixPoint(o.getvMin(), 1)));
        }
        return new Object[]{max, avg, min};
    }

    private static List<String> getSLATimeList(String type) {
        String startKey = null;
        SimpleDateFormat sf = null;
        ArrayList<String> s = null;
        int objC = 0;
        if (type.endsWith("m")) {
            startKey = CollectionUtil.getMinuteDataZone(System.currentTimeMillis());
            sf = new SimpleDateFormat("yyyyMMddHHmm");
            objC = 288;
        } else if (type.endsWith("h")) {
            startKey = CollectionUtil.getHourDataZone(System.currentTimeMillis());
            sf = new SimpleDateFormat("yyyyMMddHH");
            objC = 360;
        } else if (type.endsWith("d")) {
            startKey = CollectionUtil.getDayDataZone(System.currentTimeMillis());
            sf = new SimpleDateFormat("yyyyMMdd");
            objC = 365;
        }
        s = new ArrayList<String>(objC);
        s.add(startKey);
        Date d = null;
        try {
            d = sf.parse(startKey);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        int i = 0;
        while (i < objC) {
            if (type.endsWith("m")) {
                c.add(12, -5);
            } else if (type.endsWith("h")) {
                c.add(11, -1);
            } else if (type.endsWith("d")) {
                c.add(5, -1);
            }
            s.add(0, sf.format(c.getTime()));
            ++i;
        }
        return s;
    }

    private void getThroughputData(ResponseObject ro, String type) {
        String[] metrics = new String[]{"MVCFramework.cmd"};
        JSONArray seria = new JSONArray();
        List<String> ts = SLAWeb.getSLATimeList(type);
        String[] stringArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            String metricId = stringArray[n2];
            List<Object> value = SLAWeb.queryMetric(ts, metricId, type);
            seria.add(value);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
        ro.put("legend", this.getLegend(metrics));
    }

    private void getDataOfDB(ResponseObject ro, String id, String type) {
        Object[] list;
        JSONArray seria = new JSONArray();
        String metricId = "LocalDatabase." + id;
        List<String> ts = SLAWeb.getSLATimeList(type);
        Object[] objectArray = list = SLAWeb.queryMetricValus(ts, metricId, type);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            seria.add(o);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
    }

    private void getSlaData(ResponseObject ro, String metricId, String type) {
        Object[] list;
        JSONArray seria = new JSONArray();
        List<String> ts = SLAWeb.getSLATimeList(type);
        Object[] objectArray = list = SLAWeb.queryMetricValus(ts, metricId, type);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            seria.add(o);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
    }

    private void getOnlineData(ResponseObject ro, String type) {
        String[] metrics = new String[]{"MVCFramework.activeUsers", "MVCFramework.activeSesssion"};
        JSONArray seria = new JSONArray();
        List<String> ts = SLAWeb.getSLATimeList(type);
        String[] stringArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            String metricId = stringArray[n2];
            List<Object> list = SLAWeb.queryMetric(ts, metricId, type);
            seria.add(list);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
        ro.put("legend", this.getLegend(metrics));
    }

    private void getMemData(ResponseObject ro, String type) {
        String[] metrics = new String[]{"Infrastructure.maxPhysicalMemory", "Infrastructure.freePhysicalMemory", "Infrastructure.maxJVMMemory", "Infrastructure.freeJVMMemory"};
        JSONArray seria = new JSONArray();
        List<String> ts = SLAWeb.getSLATimeList(type);
        String[] stringArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            String metricId = stringArray[n2];
            List<Object> list = SLAWeb.queryMetric(ts, metricId, type);
            seria.add(list);
            ++n2;
        }
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
    }

    private void getCpuData(ResponseObject ro, String type) {
        String metricId = "Infrastructure.cpu";
        List<String> ts = SLAWeb.getSLATimeList(type);
        List<Object> seria = SLAWeb.queryMetric(ts, metricId, type);
        ro.put("seria", seria);
        ro.put("xAxis", SLAWeb.ftTime(ts));
    }

    private static Object getCPUValues(MetricData[] maxJVM, int length) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (maxJVM != null) {
            MetricData[] metricDataArray = maxJVM;
            int n = maxJVM.length;
            int n2 = 0;
            while (n2 < n) {
                MetricData metricData = metricDataArray[n2];
                if (metricData != null) {
                    list.add(UtilNumber.fixPoint(metricData.getValue() * 100.0, 1));
                } else {
                    list.add("-");
                }
                ++n2;
            }
        }
        SLAWeb.pad(list, length);
        return list;
    }

    private static Object getMemValues(MetricData[] maxJVM, int length) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (maxJVM != null) {
            MetricData[] metricDataArray = maxJVM;
            int n = maxJVM.length;
            int n2 = 0;
            while (n2 < n) {
                MetricData metricData = metricDataArray[n2];
                if (metricData != null) {
                    list.add(UtilNumber.fixPoint(metricData.getValue(), 2));
                } else {
                    list.add("-");
                }
                ++n2;
            }
        }
        SLAWeb.pad(list, length);
        return list;
    }

    private static void pad(List<Object> list, int length) {
        int len = list.size();
        if (len < length) {
            int i = 1;
            while (i <= length - len) {
                list.add(0, "-");
                ++i;
            }
        }
    }

    private static String[] getTimexAxis(MetricData[] maxJVM, int length, int interval) {
        int nowAxisLength;
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ArrayList<String> axis = new ArrayList<String>();
        if (maxJVM != null) {
            MetricData[] metricDataArray = maxJVM;
            int n = maxJVM.length;
            int n2 = 0;
            while (n2 < n) {
                MetricData metricData = metricDataArray[n2];
                if (metricData != null) {
                    axis.add(sdf.format(new Date(metricData.getCollectionTime())));
                }
                ++n2;
            }
        }
        if ((nowAxisLength = axis.size()) < length) {
            Long metricLastTime = null;
            if (maxJVM != null) {
                int i = maxJVM.length;
                while (i > 0) {
                    if (maxJVM[i - 1] != null) {
                        metricLastTime = maxJVM[i - 1].getCollectionTime();
                        break;
                    }
                    --i;
                }
            }
            long start = metricLastTime != null ? metricLastTime : System.currentTimeMillis();
            int i = 1;
            while (i <= length - nowAxisLength) {
                axis.add(0, sdf.format(new Date(start - (long)(i * interval * 1000))));
                ++i;
            }
        }
        return axis.toArray(new String[0]);
    }

    private static String[] getTimexAxis(int length, int interval) {
        String format = "mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        ArrayList<String> axis = new ArrayList<String>();
        int nowAxisLength = axis.size();
        if (nowAxisLength < length) {
            Long metricLastTime = null;
            long start = metricLastTime != null ? metricLastTime : System.currentTimeMillis();
            int i = 1;
            while (i <= length - nowAxisLength) {
                axis.add(0, sdf.format(new Date(start - (long)(i * interval * 1000))));
                ++i;
            }
        }
        return axis.toArray(new String[0]);
    }

    private static MetricData[] getMetricData(String metricName, boolean sec) {
        MetricData[] datas = MetricWebCollection.getData(metricName, sec);
        return datas;
    }

    public String confAlarm(String data, String op) throws DocumentException, IOException {
        ResponseObject ro = ResponseObject.newOkResponse("\u64cd\u4f5c\u6210\u529f");
        if ("SwitchSla".equals(op)) {
            boolean stat = Boolean.parseBoolean(data);
            AWSSLAConf.setSLAService(stat);
        } else if ("SwitchAlarm".equals(op)) {
            JSONObject jo = JSONArray.parseObject((String)data);
            String name = UtilJson.optString(jo, "name");
            boolean stat = jo.getBooleanValue("stat");
            AWSSLAConf.setAlarmService(name, stat);
        } else {
            JSONObject jo = JSONArray.parseObject((String)data);
            String name = UtilJson.optString(jo, "name");
            String when = UtilJson.optString(jo, "metric");
            String happen = UtilJson.optString(jo, "happen");
            String continuous = UtilJson.optString(jo, "continuous");
            String scope = UtilJson.optString(jo, "scope");
            String condition = UtilJson.optString(jo, "condition");
            String value = UtilJson.optString(jo, "value");
            String level = UtilJson.optString(jo, "level");
            String service = UtilJson.optString(jo, "stat");
            if ("delete".equals(op)) {
                AWSSLAConf.removeAlerm(name);
            } else if ("save".equals(op)) {
                AWSSLAConf.addOrUpdateAlarmXML(false, name, level, when, condition, continuous, value, happen, scope, service);
            } else if ("add".equals(op)) {
                if (UtilString.isEmpty(name)) {
                    ro.warn("\u8bf7\u586b\u5199\uff1a\u544a\u8b66\u540d\u79f0");
                    return ro.toString();
                }
                if (UtilString.isEmpty(value)) {
                    ro.warn("\u8bf7\u586b\u5199\uff1a\u544a\u8b66\u503c");
                    return ro.toString();
                }
                List<SLAAlarm> alarms = AWSSLAConf.getAlarms();
                for (SLAAlarm alarm : alarms) {
                    if (alarm.getName().equals(name)) {
                        ro.warn("\u544a\u8b66\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u8bbe");
                        return ro.toString();
                    }
                    if (!alarm.getValue().equals(value) || !alarm.getWhen().equals(when) || !alarm.getCondition().equals(condition) || !alarm.getHappen().equals(happen) || alarm.getContinuous() != Integer.parseInt(continuous) || !alarm.getScope().equals(scope)) continue;
                    ro.warn("\u544a\u8b66\u6307\u6807\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u8bbe");
                    return ro.toString();
                }
                AWSSLAConf.addOrUpdateAlarmXML(true, name, level, when, condition, continuous, value, happen, scope, service);
            }
        }
        return ro.toString();
    }

    private String getThread(String g, long id, String name) {
        return "[" + g + "][" + id + "] " + name;
    }

    private String getRuntimeMonitor(String monitorType) {
        StringBuilder sb;
        block24: {
            String token;
            int index;
            block27: {
                block26: {
                    block25: {
                        block23: {
                            sb = new StringBuilder();
                            index = 0;
                            String string = token = SDK.getPlatformAPI().isCluster() ? "<font>" + AWSServerConf.getInstanceName() + "</font>" + "." : "";
                            if (!TRACK_THREAD_TOPN.equals(monitorType)) break block23;
                            List list = ThreadMonit.getTopN();
                            StringBuilder html = new StringBuilder();
                            int t = SLAUtil.getMonitThreshold();
                            for (ThreadTopModel threadTopModel : list) {
                                long op = threadTopModel.getOptime() / 1000L;
                                if (op < (long)t) continue;
                                html.append("<tr>");
                                html.append("<td>" + token + ++index + "</td>");
                                String title = threadTopModel.getTitle();
                                if (threadTopModel.getType() == 1) {
                                    Exchange ex = (Exchange)threadTopModel.getInfo()[0];
                                    if (ex != null) {
                                        JSONObject json = new JSONObject();
                                        if (!UtilString.isEmpty(ex.getParameters())) {
                                            json.putAll(ex.getParameters());
                                            json.remove((Object)"clientIp");
                                            json.remove((Object)"serverName");
                                        }
                                        if (ex.getHeader() != null && !UtilString.isEmpty(ex.getHeader().get("User-Agent"))) {
                                            json.put("User-Agent", (Object)ex.getHeader().get("User-Agent"));
                                        }
                                        if (!UtilString.isEmpty(ex.getSid())) {
                                            json.put("SID", (Object)ex.getSid());
                                        }
                                        title = String.valueOf(title) + " -> " + json;
                                    }
                                } else if (threadTopModel.getType() == 2) {
                                    title = "JOB -> " + JSONObject.toJSONString((Object)threadTopModel.getInfo());
                                } else if (threadTopModel.getType() == 3) {
                                    Object[] ar = threadTopModel.getInfo();
                                    Object[] rr = new Object[ar.length - 1];
                                    System.arraycopy(ar, 1, rr, 0, ar.length - 1);
                                    title = "SR -> " + JSONObject.toJSONString((Object)rr);
                                }
                                html.append("<td class=\"thread-col\">" + title + "</td>");
                                html.append("<td><button type=\"button\" class=\"button green\"    border='0'>" + op + "</button></td>");
                                html.append("</tr>");
                            }
                            sb.append((CharSequence)html);
                            break block24;
                        }
                        if (!TRACK_THREAD.equals(monitorType)) break block25;
                        List list = (List)((Object)SLAUtil.getTrack(monitorType));
                        StringBuilder html = new StringBuilder();
                        for (ThreadTrackModel threadTrackModel : list) {
                            if (threadTrackModel.getId() == Thread.currentThread().getId()) continue;
                            html.append("<tr>");
                            html.append("<td>" + token + ++index + "</td>");
                            html.append("<td class=\"thread-col\">" + this.getThread(threadTrackModel.getThreadGroup(), threadTrackModel.getId(), threadTrackModel.getName()) + "</td>");
                            long op = threadTrackModel.getOptime() / 1000L;
                            List<String> tmp = threadTrackModel.getStackTraceElements();
                            tmp.add(0, "\u8c03\u7528\u8be5\u7ebf\u7a0b\u7684\u4ee3\u7801\u6808\u5c42\u6b21\uff1a");
                            html.append("<td><button type=\"button\" class=\"button green\" " + Html.toHtmlJSEvent("onclick", "openStactTraceInfo", new Object[]{tmp}) + "   border='0'>" + op + "</button></td>");
                            html.append("<td>" + threadTrackModel.getState().name() + "</td>");
                            html.append("</tr>");
                        }
                        sb.append((CharSequence)html);
                        break block24;
                    }
                    if (!TRACK_THREAD_ALL.equals(monitorType)) break block26;
                    Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
                    ArrayList<Map.Entry<Thread, StackTraceElement[]>> list = new ArrayList<Map.Entry<Thread, StackTraceElement[]>>(all.entrySet());
                    Collections.sort(list, new Comparator<Map.Entry<Thread, StackTraceElement[]>>(){

                        @Override
                        public int compare(Map.Entry<Thread, StackTraceElement[]> o1, Map.Entry<Thread, StackTraceElement[]> o2) {
                            int t = o1.getKey().getState().compareTo(o2.getKey().getState());
                            if (t != 0) {
                                return t;
                            }
                            return o1.getKey().getName().compareTo(o2.getKey().getName());
                        }
                    });
                    StringBuilder html = new StringBuilder();
                    for (Map.Entry entry : list) {
                        if (((Thread)entry.getKey()).getId() == Thread.currentThread().getId()) continue;
                        ++index;
                        Thread t = (Thread)entry.getKey();
                        String bgcolor = "#eeeeee";
                        if (t.getState().name().equals("RUNNABLE")) {
                            bgcolor = "#66B3FF";
                        }
                        if (t.getState().name().equals("BLOCKED")) {
                            bgcolor = "yellow";
                        }
                        html.append("<tr>");
                        html.append("<td>" + token + index + "</td>");
                        html.append("<td class=\"thread-col\">" + this.getThread(t.getThreadGroup().getName(), t.getId(), t.getName()) + "</td>");
                        if (t.getState() == Thread.State.TERMINATED) {
                            html.append("<td></td>");
                        } else {
                            List<String> tmp = ThreadStackTraceInfo.getStackArray(all, t);
                            tmp.add(0, "\u8c03\u7528\u8be5\u7ebf\u7a0b\u7684\u4ee3\u7801\u6808\u5c42\u6b21\uff1a");
                            html.append("<td><button type=\"button\" class=\"button green\" " + Html.toHtmlJSEvent("onclick", "openStactTraceInfo", new Object[]{tmp}) + " border='0'>\u6808</button></td>");
                        }
                        html.append("<td>" + t.getState().name() + "</td>");
                        html.append("</tr>");
                    }
                    sb.append((CharSequence)html);
                    break block24;
                }
                if (!monitorType.startsWith(TRACK_PROCESS)) break block27;
                OSPerformanceinfoInterface osPerformance = OSNow.getPerformance();
                OSProcessPerformance[] array = osPerformance.getOSPerformance().getOSProcessUseageSortCPU();
                if (monitorType.endsWith("_order_mem")) {
                    array = osPerformance.getOSPerformance().getOSProcessUseageSortMemory();
                }
                if (array == null) break block24;
                int i = 0;
                while (i < array.length) {
                    OSProcessPerformance oSProcessPerformance = array[i];
                    sb.append("<tr>");
                    sb.append("<td>" + token + ++index + "</td>");
                    sb.append("<td class='thread-col'>" + oSProcessPerformance.getProcessName() + "</td>");
                    sb.append("<td>" + oSProcessPerformance.getProcessCPUUsage() + "</td>");
                    if (OSNow.getSystemOsType() == OSNow.OsType.WINDOWS) {
                        double musage = oSProcessPerformance.getProcessMemoryUsage() / 1024.0 / osPerformance.getOSPerformance().getOSTotalPhysicalMemory() * 100.0;
                        sb.append("<td>" + UtilNumber.fixPoint(musage, 2) + "</td>");
                        sb.append("<td>" + UtilNumber.div(oSProcessPerformance.getPercentProcessorTime(), "1000000", 0) + "</td>");
                    } else if (OSNow.getSystemOsType() == OSNow.OsType.LINUX) {
                        sb.append("<td>" + oSProcessPerformance.getProcessMemoryUsage() + "</td>");
                        sb.append("<td>" + oSProcessPerformance.getPercentProcessorTime() + "</td>");
                    }
                    sb.append("<td>" + oSProcessPerformance.getProcessId() + "</td>");
                    sb.append("</tr>");
                    ++i;
                }
                break block24;
            }
            List dbTrackModels = (List)((Object)SLAUtil.getTrack(monitorType));
            for (DBTrackModel dbTrackModel : dbTrackModels) {
                sb.append("<tr>");
                sb.append("<td>" + token + ++index + "</td>");
                sb.append("<td>" + dbTrackModel.getName() + "</td>");
                String[] stringArray = dbTrackModel.getStack().split(Pattern.quote(ThreadStackTraceInfo.lineSeparator));
                ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(stringArray));
                if (stringArray != null && stringArray.length > 2) {
                    tmp.add(0, "\u8c03\u7528\u8be5\u7ebf\u7a0b\u7684\u4ee3\u7801\u6808\u5c42\u6b21\uff1a");
                }
                sb.append("<td><button type='button' class='button green' " + Html.toHtmlJSEvent("onclick", "openStactTraceInfo", new Object[]{tmp}) + ">" + dbTrackModel.getOptime() + "</button></td>");
                sb.append("</tr>");
            }
        }
        return sb.toString();
    }

    private void setMetricDiagnosis(ResponseObject ro, String params) {
        JSONObject paJsonObject = JSONArray.parseObject((String)params);
        int fre = paJsonObject.getIntValue("fre");
        int vtype = !paJsonObject.containsKey((Object)"vtype") ? 1 : paJsonObject.getIntValue("vtype");
        String vtime = UtilJson.optString(paJsonObject, "vtime");
        String field = "VAVG";
        if (vtype == 2) {
            field = "VMAX";
        } else if (vtype == 3) {
            field = "VMIN";
        }
        List<RowMap> tmp = null;
        if (fre == 1) {
            tmp = DBSql.getMaps("select  INSTNAME,METRICID," + field + " from " + new SLACollectionDataMDao().entityName() + " where VTIME=?", vtime);
        } else if (fre == 2) {
            tmp = DBSql.getMaps("select  INSTNAME,METRICID," + field + " from " + new SLACollectionDataHDao().entityName() + " where VTIME=?", vtime);
        } else if (fre == 3) {
            tmp = DBSql.getMaps("select  INSTNAME,METRICID," + field + " from " + new SLACollectionDataDDao().entityName() + " where VTIME=?", vtime);
        }
        HashMap<String, HashMap<Object, Double>> list = new HashMap<String, HashMap<Object, Double>>();
        if (tmp != null) {
            for (RowMap t : tmp) {
                String inst = t.getString("INSTNAME");
                String metric = t.getString("METRICID");
                double v = t.getDouble(field);
                HashMap<Object, Double> tl = (HashMap<Object, Double>)list.get(inst);
                if (tl == null) {
                    tl = new HashMap<Object, Double>();
                    list.put(inst, tl);
                }
                tl.put(metric, v);
            }
        }
        ArrayList<String> mts = new ArrayList<String>();
        List<ResourceMetric> ms = AWSSLAConf.getMetricsOfSort();
        for (ResourceMetric m : ms) {
            if (!"ms".equals(m.getUnit())) continue;
            mts.add(m.getId());
        }
        ArrayList<Map<String, Object>> sers = new ArrayList<Map<String, Object>>();
        Legend lg = new Legend();
        lg.setX("center");
        lg.setY("bottom");
        TextStyle ts = new TextStyle();
        ts.setFontSize(14);
        ts.setColor("white");
        lg.setTextStyle(ts);
        boolean hasSort = false;
        if (!UtilString.isEmpty(list)) {
            ArrayList insts = new ArrayList(list.keySet());
            Collections.sort(insts);
            for (String inst : insts) {
                final Map tl = (Map)list.get(inst);
                if (tl == null) continue;
                if (!hasSort) {
                    Collections.sort(mts, new Comparator<String>(){

                        @Override
                        public int compare(String o2, String o1) {
                            Double oo1 = (Double)tl.get(o1);
                            Double oo2 = (Double)tl.get(o2);
                            if (oo1 == null) {
                                oo1 = 0.0;
                            }
                            if (oo2 == null) {
                                oo2 = 0.0;
                            }
                            return oo2 > oo1 ? 1 : (oo2 == oo1 ? 0 : -1);
                        }
                    });
                    hasSort = true;
                }
                ArrayList<Object> datas = new ArrayList<Object>();
                for (String t : mts) {
                    Double o = (Double)tl.get(t);
                    datas.add(o == null ? "" : SLAWeb.getUnitValue("ms", o));
                }
                BarSeries ser = new BarSeries();
                ser.setName(inst);
                ser.setData(datas);
                sers.add(ser.getJson());
                lg.getData().add((Object)inst);
            }
        }
        ro.put("yAxis", this.getMetricNameList(mts));
        ro.put("series", sers);
        ro.put("legend", lg.getJson());
    }

    private List<String> getMetricNameList(List<String> ids) {
        ArrayList<String> t = new ArrayList<String>();
        for (String id : ids) {
            t.add(this.getMetricFullName(id));
        }
        return t;
    }

    private void setMetricTrend(ResponseObject ro, String params) {
        JSONObject paJsonObject = JSONArray.parseObject((String)params);
        int fre = paJsonObject.getIntValue("fre");
        int vtype = !paJsonObject.containsKey((Object)"vtype") ? 1 : paJsonObject.getIntValue("vtype");
        String metrics = UtilJson.optString(paJsonObject, "metrics");
        String[] ms = new String[]{"Infrastructure.cpu"};
        if (!UtilString.isEmpty(metrics)) {
            ms = metrics.split(",");
        }
        List list = SLAWeb.getSLACollectionData(ms, fre);
        HashMap<String, HashMap<String, Double>> md = new HashMap<String, HashMap<String, Double>>();
        ArrayList<String> vtimes = new ArrayList();
        for (Object o : list) {
            SLACollectionData cd = (SLACollectionData)o;
            HashMap<String, Double> tmp = (HashMap<String, Double>)md.get(cd.getMetricId());
            if (tmp == null) {
                tmp = new HashMap<String, Double>();
                md.put(cd.getMetricId(), tmp);
            }
            tmp.put(cd.getvTime(), SLAWeb.getSLACollectionDataVal(cd, vtype));
            if (vtimes.contains(cd.getvTime())) continue;
            vtimes.add(cd.getvTime());
        }
        vtimes = SLAWeb.getSLATimeList(fre == 1 ? "m" : (fre == 2 ? "h" : "d"));
        ArrayList<Map<String, Object>> sers = new ArrayList<Map<String, Object>>();
        ArrayList<String> lg = new ArrayList<String>();
        if (ms != null) {
            String[] stringArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Map mdata = (Map)md.get(s);
                String unit = SDK.getSLAAPI().getMetric(s).getUnit();
                ArrayList<Object> datas = new ArrayList<Object>();
                for (String vtime : vtimes) {
                    datas.add(mdata == null ? "" : SLAWeb.getUnitValue(unit, (Double)mdata.get(vtime)));
                }
                LineSeries ser = new LineSeries();
                String name = this.getI18N(s, 0);
                ser.setName(name);
                ser.setData(datas);
                lg.add(name);
                Map<String, Object> json = ser.getJson();
                if (this.isMetricAlarm(s)) {
                    json.put("metricId", s);
                }
                sers.add(json);
                ++n2;
            }
        }
        ro.put("legend", lg);
        ro.put("xAxis", SLAWeb.ftTime(vtimes));
        ro.put("series", sers);
    }

    private static Object getUnitValue(SLACollectionData sLACollectionDataOfMinute, ResourceMetric metric) {
        boolean vcount;
        boolean bl = vcount = metric != null && metric.getUnit().equals("times");
        return vcount ? Long.valueOf(sLACollectionDataOfMinute.getvCount()) : SLAWeb.getUnitValue(metric == null ? null : metric.getUnit(), sLACollectionDataOfMinute.getvAvg());
    }

    private static Object getUnitValue(String unit, Double v) {
        if (v == null || UtilString.isEmpty(unit)) {
            return "";
        }
        if (unit.equals("%")) {
            v = UtilNumber.fixPoint(v * 100.0, 2);
        } else if (unit.equals("g")) {
            v = UtilNumber.fixPoint(v, 2);
        } else if (unit.equals("ms")) {
            v = UtilNumber.fixPoint(v, 0);
        }
        return v;
    }

    private static List<String> ftTime(List<String> list) {
        ArrayList<String> t = new ArrayList<String>();
        for (String vtime : list) {
            t.add(SLAWeb.ftTime(vtime));
        }
        return t;
    }

    private static String ftTime(String vtime) {
        int t = -1;
        if (vtime.length() == 8) {
            t = 1;
        } else if (vtime.length() == 10) {
            t = 2;
        } else if (vtime.length() == 12) {
            t = 3;
        }
        String ft = null;
        String tft = null;
        if (t == 1) {
            tft = "yyyyMMdd";
            ft = "yyyy/MM/dd";
        } else if (t == 2) {
            tft = "yyyyMMddHH";
            ft = "yyyy/MM/dd HH";
        } else if (t == 3) {
            tft = "yyyyMMddHHmm";
            ft = "yyyy/MM/dd HH:mm";
        }
        return UtilDate.datetimeFormat(UtilDate.parse(vtime, tft), ft);
    }

    private static List getSLACollectionData(String[] ms, int fre) {
        ArrayList<String> st = new ArrayList<String>();
        int i = 0;
        while (i < ms.length) {
            st.add("?");
            ++i;
        }
        String where = "METRICID in(" + UtilString.join(st, ",") + ")";
        if (fre == 1) {
            return new SLACollectionDataMDao().query(where, ms).list();
        }
        if (fre == 2) {
            return new SLACollectionDataHDao().query(where, ms).list();
        }
        return new SLACollectionDataDDao().query(where, ms).list();
    }

    private static double getSLACollectionDataVal(SLACollectionData cd, int t) {
        ResourceMetric m = SDK.getSLAAPI().getMetric(cd.getMetricId());
        if (m != null && "times".equals(m.getUnit())) {
            return cd.getvCount();
        }
        if (t == 2) {
            return cd.getvMax();
        }
        if (t == 3) {
            return cd.getvMin();
        }
        return cd.getvAvg();
    }

    private String merge(String template, Map<String, Object> macroLibraries) {
        macroLibraries.put("sessionId", this.getContext().getSessionId());
        macroLibraries.put("sid", this.getSIDFlag());
        macroLibraries.put("navtree", HtmlPageTemplate.merge("_bpm.platform", "console.sla.nav.htm", new HashMap<String, Object>()));
        return HtmlPageTemplate.merge("_bpm.platform", template, macroLibraries);
    }

    private String getTitle(String p, String s, boolean resource) {
        String t = resource ? "SLA-RESOURCE:" + s : s;
        String title = this.getI18N(t, 0);
        return title.contains(t) ? s : String.valueOf(title) + "-" + s;
    }

    private String getMetricFullName(String metricId) {
        String i18nMetric = this.getI18N(metricId, 0);
        return i18nMetric.contains(metricId) ? metricId : String.valueOf(i18nMetric) + "-" + metricId;
    }

    public String openSLADetail(String id) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        SLAAlarmEventDao dao = new SLAAlarmEventDao();
        SLAAlarmEvent sla = (SLAAlarmEvent)dao.queryById(id);
        if (!sla.isRead()) {
            dao.tagRead(id);
        }
        StringBuffer content = new StringBuffer();
        content.append(String.valueOf(sla.getInstName()) + " - ").append(String.valueOf(this.getI18N(sla.getAlarmName(), 1)) + " - ");
        String levelImg = "../apps/_bpm.platform/img/sla/\u8b66\u544a\u4fe1\u606f-\u901a\u77e5.png";
        if (sla.getAlarmLevel() == 0) {
            content.append("\u901a\u77e51\u6b21");
        } else if (sla.getAlarmLevel() == 1) {
            content.append("\u544a\u8b661\u6b21");
            levelImg = "../apps/_bpm.platform/img/sla/\u8b66\u544a\u4fe1\u606f-\u544a\u8b66.png";
        } else if (sla.getAlarmLevel() == 2) {
            content.append("\u9519\u8bef1\u6b21");
            levelImg = "../apps/_bpm.platform/img/sla/\u8b66\u544a\u4fe1\u606f-\u9519\u8bef.png";
        }
        ResourceMetric metric = SDK.getSLAAPI().getMetric(sla.getMetricId());
        StringBuilder alarmRule = new StringBuilder();
        SLAAlarm sLAAlarm = this.getAlarms(sla.getAlarmName());
        if (sLAAlarm != null) {
            alarmRule.append("<tr height='28'>");
            alarmRule.append("<td>\u89c4\u5219\u8bf4\u660e</td>");
            String i18nMetric = this.getI18N(sLAAlarm.getWhen(), 0);
            String i18nCondition = this.getI18N(sLAAlarm.getCondition(), 0);
            StringBuilder str = new StringBuilder();
            str.append(String.valueOf(i18nMetric) + i18nCondition + sLAAlarm.getValue());
            if (metric == null) {
                str.append("\u3002\u5f53\u524d\uff1a<span style='font-weight:bold;'>" + sla.getTakeValue() + "</span>");
            } else if ("times".equals(metric.getUnit())) {
                String t = Double.toString(sla.getTakeValue());
                str.append("\u6b21\u3002\u5f53\u524d\uff1a<span style='font-weight:bold;'>" + (t.endsWith(".0") ? t.substring(0, t.length() - 2) : t) + "</span>\u6b21");
            } else if ("ms".equals(metric.getUnit())) {
                str.append("\u6beb\u79d2\u3002\u5f53\u524d\uff1a<span style='font-weight:bold;'>" + sla.getTakeValue() + "</span>\u6beb\u79d2");
            }
            alarmRule.append("<td>" + str + "</td>");
            alarmRule.append("</tr>");
        }
        String evtTime = UtilDate.datetimeFormat(sla.getEventTime());
        List evts = null;
        Calendar c = Calendar.getInstance();
        c.setTime(sla.getEventTime());
        c.add(4, -1);
        String sql = "SELECT * FROM " + new SLAAlarmEventDao().entityName() + " WHERE EVENTTIME<? AND EVENTTIME>? AND METRICID = ? order by EVENTTIME desc";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            try {
                conn = DBSql.open();
                ps = DBUtils.createPreparedStatement((Connection)conn, (String)sql, (Object[])new Object[]{sla.getEventTime(), c.getTime(), sla.getMetricId()});
                ps.setMaxRows(1);
                ps.setFetchSize(1);
            }
            catch (SQLException e) {
                throw new AWSException(e);
            }
        }
        catch (Throwable throwable) {
            DBSql.close(conn, ps, null);
            throw throwable;
        }
        DBSql.close(conn, ps, null);
        if (!UtilString.isEmpty(evts)) {
            evtTime = String.valueOf(evtTime) + "<span style='margin-left:36px;margin-right:24px;'>\u4e0a\u6b21\u65f6\u95f4</span>" + UtilDate.datetimeFormat(((SLAAlarmEvent)evts.get(0)).getEventTime());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -90);
        HashMap days90 = new HashMap();
        JSONObject ro = new JSONObject();
        ArrayList list = new ArrayList(days90.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, AtomicInteger>>(){

            @Override
            public int compare(Map.Entry<String, AtomicInteger> o1, Map.Entry<String, AtomicInteger> o2) {
                return Integer.parseInt(o1.getKey().replaceAll("-", "")) - Integer.parseInt(o2.getKey().replaceAll("-", ""));
            }
        });
        ArrayList<String> axis = new ArrayList<String>();
        ArrayList<Integer> counter = new ArrayList<Integer>();
        if (!UtilString.isEmpty(days90)) {
            for (Map.Entry entry : list) {
                axis.add((String)entry.getKey());
                counter.add(((AtomicInteger)entry.getValue()).get());
            }
        }
        ro.put("xAxis", axis);
        ro.put("seria", counter);
        macroLibraries.put("levelImg", levelImg);
        macroLibraries.put("metricHis", ro);
        AppContext appContext = SDK.getAppAPI().getAppContext(sla.getAppId());
        if (appContext != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<tr height=\"28\">");
            sb.append("<td>\u5e94\u7528ID</td>");
            sb.append("<td>" + sla.getAppId() + "(" + appContext.getName() + ")" + "</td>");
            sb.append("</tr>");
            macroLibraries.put("app", sb);
        } else {
            macroLibraries.put("app", "");
        }
        macroLibraries.put("alarmrule", alarmRule.toString());
        macroLibraries.put("content", content.toString());
        macroLibraries.put("eventTime", evtTime);
        macroLibraries.put("takeDetail", "".equals(sla.getTakeDetail()) ? "\u65e0" : sla.getTakeDetail());
        macroLibraries.put("takeValue", sla.getTakeValue());
        macroLibraries.put("sid", super.getSIDFlag());
        return HtmlPageTemplate.merge("_bpm.platform", "console.dashboard.sla.detail.htm", macroLibraries);
    }

    private SLAAlarm getAlarms(String name) {
        for (SLAAlarm alarm : AWSSLAConf.getAlarms()) {
            if (!alarm.getName().equals(name)) continue;
            return alarm;
        }
        return null;
    }

    public String getSLAAlarm(String type) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String alarmHTML = "";
        SLAAPI slaapi = SDK.getSLAAPI();
        List slaAlarmEvents = slaapi.queryAlarmData(AWSServerConf.getInstanceName(), 0, 5);
        for (SLAAlarmEvent sla : slaAlarmEvents) {
            String fontStyle = "";
            String levelName = "";
            if (sla.getAlarmLevel() == 0) {
                fontStyle = "fontInfoStyle";
                levelName = "\u901a\u77e5";
            } else if (1 == sla.getAlarmLevel()) {
                fontStyle = "fontWarnStyle";
                levelName = "\u8b66\u544a";
            } else if (2 == sla.getAlarmLevel()) {
                fontStyle = "fontErrStyle";
                levelName = "\u9519\u8bef";
            }
            if (!sla.isRead()) {
                fontStyle = String.valueOf(fontStyle) + " noreadStyle";
            }
            String[] time = sla.getEventTime().toString().substring(0, 19).split(" ");
            String name = this.getI18N(sla.getAlarmName(), 1);
            alarmHTML = String.valueOf(alarmHTML) + "<section><span class='point-time point-color'></span><aside><div class='timeRight' id='slaDiv'><span class='fontStyle " + fontStyle + "' title='[" + levelName + "]" + name + "' onclick=openDetail('" + sla.getId() + "');>";
            alarmHTML = String.valueOf(alarmHTML) + "[" + levelName + "]" + name + "</span><span class='timeStyle'><span>" + time[0] + "</span></br><span>" + time[1] + "</span></span><div></aside></section>";
        }
        ro.setData(alarmHTML);
        return ro.toString();
    }

    private String getI18N(String metricId, int i18n_w) {
        String t = metricId;
        if (i18n_w == 1) {
            t = "SLA-ALARM:" + metricId;
        } else if (i18n_w == 2) {
            t = "SLA-RESOURCE:" + metricId;
        }
        String s = SDK.getSLAAPI().getMetricName(t, this.getContext().getLanguage());
        return s.equals(t) ? metricId : s;
    }

    private void addQ(StringBuilder sb, String q) {
        if (sb.length() > 0) {
            sb.append(" AND " + q);
        } else {
            sb.append(q);
        }
    }

    public String getAlermLog(String property) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject params = !UtilString.isEmpty(property) ? JSONArray.parseObject((String)property) : new JSONObject();
        String evtLevel = UtilJson.optString(params, "evtLevel");
        String instId = UtilJson.optString(params, "instId");
        String q = UtilJson.optString(params, "searchAlarmName");
        String searchMtricId = UtilJson.optString(params, "searchMtricId");
        int timeType = params.getIntValue("timeType");
        StringBuilder where = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        if (!UtilString.isEmpty(q)) {
            where.append("(TAKEDETAIL like ? OR APPID like ?)");
            args.add("%" + q + "%");
            args.add("%" + q + "%");
        }
        if (!UtilString.isEmpty(instId)) {
            this.addQ(where, "INSTNAME =?");
            args.add(instId);
        }
        if (!UtilString.isEmpty(evtLevel)) {
            this.addQ(where, "ALARMLEVEL =?");
            args.add(Integer.parseInt(evtLevel));
        }
        if (!UtilString.isEmpty(timeType)) {
            Calendar c = Calendar.getInstance();
            if (timeType == 1) {
                c.add(4, -1);
            } else if (timeType == 2) {
                c.add(2, -1);
            } else if (timeType == 3) {
                c.add(2, -3);
            } else if (timeType == 4) {
                c.add(1, -1);
            }
            this.addQ(where, "EVENTTIME >?");
            args.add(c.getTime());
        }
        if (!UtilString.isEmpty(searchMtricId)) {
            String[] mids = searchMtricId.split(",");
            ArrayList<String> qin = new ArrayList<String>();
            String[] stringArray = mids;
            int n = mids.length;
            int n2 = 0;
            while (n2 < n) {
                String mid = stringArray[n2];
                qin.add("?");
                args.add(mid);
                ++n2;
            }
            this.addQ(where, "METRICID in(" + UtilString.join(qin, ",") + ")");
        }
        int start = 0;
        int limit = 20;
        String startstr = UtilJson.optString(params, "start");
        String limitstr = UtilJson.optString(params, "limit");
        if (!UtilString.isEmpty(startstr)) {
            start = Integer.parseInt(startstr);
        }
        if (!UtilString.isEmpty(limitstr)) {
            limit = Integer.parseInt(limitstr);
        }
        IDaoQuery dao = new SLAAlarmEventDao().query(where.toString(), args.toArray());
        int count = DBSql.getInt("select count(*) from SYS_SLA_ALARM where " + where, args.toArray());
        List newSlaAlarmEvents = dao.orderBy("EVENTTIME").desc().list(start, limit);
        HashMap<Integer, String> styles = new HashMap<Integer, String>();
        styles.put(2, "evt-type-err");
        styles.put(0, "evt-type-info");
        styles.put(1, "evt-type-warn");
        JSONArray data = new JSONArray();
        DecimalFormat f = new DecimalFormat("0");
        int i = 0;
        while (i < newSlaAlarmEvents.size()) {
            JSONObject slaObject = new JSONObject();
            SLAAlarmEvent evt = (SLAAlarmEvent)newSlaAlarmEvents.get(i);
            StringBuilder sb = new StringBuilder();
            String levelName = "\u901a\u77e5";
            if (evt.getAlarmLevel() == 2) {
                levelName = "\u9519\u8bef";
            } else if (evt.getAlarmLevel() == 1) {
                levelName = "\u8b66\u544a";
            }
            sb.append("<span class=\"evt-type " + (String)styles.get(evt.getAlarmLevel()) + "\">" + levelName + "</span><span" + (evt.isRead() ? "" : " class='noreadStyle'") + ">" + this.getI18N(evt.getAlarmName(), 1) + "</span></td>");
            slaObject.put("id", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getId());
            slaObject.put("alarmName", (Object)sb.toString());
            slaObject.put("metric", (Object)this.getI18N(((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getMetricId(), 0));
            slaObject.put("instName", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getInstName());
            slaObject.put("metricId", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getMetricId());
            slaObject.put("takeDetail", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getTakeDetail());
            slaObject.put("appId", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getAppId());
            slaObject.put("takeValue", (Object)f.format(((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getTakeValue()));
            slaObject.put("eventTime", (Object)((SLAAlarmEvent)newSlaAlarmEvents.get(i)).getEventTime().toString().substring(0, 19));
            data.add((Object)slaObject);
            ++i;
        }
        ro.put("data", data);
        ro.put("count", count);
        return ro.toString();
    }

    public String getConsoleAlarm() {
        ResponseObject ro = ResponseObject.newOkResponse();
        SLAAlarmEventDao dao = new SLAAlarmEventDao();
        Calendar calendar = Calendar.getInstance();
        calendar.add(4, -1);
        String sql = "SELECT * FROM SYS_SLA_ALARM WHERE EVENTTIME>? ORDER BY EVENTTIME DESC";
        List slaList = Collections.EMPTY_LIST;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            try {
                conn = DBSql.open();
                ps = DBUtils.createPreparedStatement((Connection)conn, (String)sql, (Object[])new Object[]{calendar.getTime()});
                ps.setMaxRows(8);
                ps.setFetchSize(8);
                slaList = DBUtils.query((PreparedStatement)ps, dao.rowMapper());
            }
            catch (SQLException e) {
                throw new AWSException(e);
            }
        }
        catch (Throwable throwable) {
            DBSql.close(conn, ps, null);
            throw throwable;
        }
        DBSql.close(conn, ps, null);
        StringBuffer slaHtml = new StringBuffer();
        for (SLAAlarmEvent sla : slaList) {
            String fontStyle = "";
            String name = this.getI18N(sla.getAlarmName(), 1);
            if (sla.getAlarmLevel() == 0) {
                fontStyle = "fontInfoStyle";
                name = "[\u901a\u77e5]" + name;
            } else if (1 == sla.getAlarmLevel()) {
                fontStyle = "fontWarnStyle";
                name = "[\u8b66\u544a]" + name;
            } else if (2 == sla.getAlarmLevel()) {
                fontStyle = "fontErrStyle";
                name = "[\u9519\u8bef]" + name;
            }
            if (!sla.isRead()) {
                fontStyle = String.valueOf(fontStyle) + " noreadStyle";
            }
            slaHtml.append("<section><span class='point-time point-color'></span><aside><div class='timeRight' id='slaDiv'><span class='fontStyle " + fontStyle + "' id='S" + sla.getId() + "' title='" + name + "' onclick=openDetail('" + sla.getId() + "');>" + "[" + sla.getInstName() + "]" + name + "</span><span class='timeStyle'>" + UtilDate.getAliasDate(sla.getEventTime().toString()) + "</span><div></aside></section>");
        }
        ro.put("slaHtml", slaHtml.toString());
        return ro.toString();
    }
}

