/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mail;

import com.actionsoft.bpms.bpmn.engine.core.delegate.ProcessExecutionContext;
import com.actionsoft.bpms.bpmn.engine.core.delegate.TaskBehaviorContext;
import com.actionsoft.bpms.bpmn.engine.dao.ProcessRuntimeDaoFactory;
import com.actionsoft.bpms.bpmn.engine.model.def.MonitoringModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.engine.model.def.UserTaskModel;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.form.engine.FormEngineHelper;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TempleteMailHelper {
    private static TempleteMailHelper templeteMailHelper;

    private TempleteMailHelper() {
    }

    public static TempleteMailHelper getInstance() {
        if (templeteMailHelper == null) {
            templeteMailHelper = new TempleteMailHelper();
        }
        return templeteMailHelper;
    }

    public void taskRemind(UserContext user, ProcessInstance processInst) {
        ResponseObject responseObject;
        if (processInst == null) {
            throw new AWSIllegalArgumentException("processInst", "NULL");
        }
        ProcessDefinition processDef = SDK.getRepositoryAPI().getProcessDefinition(processInst.getProcessDefId());
        if (processDef == null) {
            throw new AWSObjectNotFindException("\u6d41\u7a0b\u5b9a\u4e49(" + processInst.getProcessDefId() + ")\u672a\u627e\u5230");
        }
        if (processInst.isEnd()) {
            return;
        }
        ProcessRuntimeDaoFactory.createProcessInstance().setRemind(processInst.getId());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("PROCESSINSTID", processInst.getId());
        DBSql.update("UPDATE WFC_TASK SET REMINDTIMES=REMINDTIMES+1 WHERE PROCESSINSTID=:PROCESSINSTID AND TASKSTATE=1", param);
        String mailTemplateId = processDef.getMailNotifyTemplate();
        String mailTemplateJS = null;
        if (mailTemplateId != null && !mailTemplateId.trim().equals("") && (responseObject = SDK.getNotificationAPI().getEmailTemplate(mailTemplateId)) != null) {
            if (responseObject.isOk()) {
                mailTemplateJS = responseObject.toDataString();
            } else {
                responseObject.isWarn();
            }
        }
        if (!UtilString.isEmpty(mailTemplateJS)) {
            JSONObject mailTemplateJO = JSONObject.parseObject(mailTemplateJS);
            List taskList = ProcessRuntimeDaoFactory.createTaskInstance().getActiveUserTasksByProcess(processInst.getId());
            for (TaskInstance taskInst : taskList) {
                UserModel u;
                if (!taskInst.getControlState().equals("active") || taskInst.getState() != 1 || (u = UserCache.getModel((String)taskInst.getTarget())) == null || u.isClosed() || UtilString.isEmpty(u.getEmail())) continue;
                String to = u.getEmail();
                String cc = mailTemplateJO.getString("copyto");
                String title = mailTemplateJO.getString("email_title");
                String content = mailTemplateJO.getString("email_content");
                cc = SDK.getRuleAPI().executeAtScript(cc, user, processInst, taskInst, null);
                title = SDK.getRuleAPI().executeAtScript(title, user, processInst, taskInst, null);
                content = SDK.getRuleAPI().executeAtScript(content, user, processInst, taskInst, null);
                SDK.getNotificationAPI().sendEMailAsync("", to, cc, title, content);
            }
        }
    }

    public void taskReceivedNotification(UserContext user, ProcessInstance processInst, TaskInstance taskInst, UserTaskModel userTaskModel, String tokenId) {
        ResponseObject responseObject;
        String emailNotifyTemplateId;
        if (processInst == null) {
            throw new AWSIllegalArgumentException("processInst", "NULL");
        }
        if (taskInst == null) {
            throw new AWSIllegalArgumentException("taskInst", "NULL");
        }
        if (userTaskModel == null) {
            throw new AWSIllegalArgumentException("userTaskModel", "NULL");
        }
        List delegateTaskUser = FormEngineHelper.getInstance().getDelegateTaskUser(user, taskInst);
        if (taskInst.getTarget().equals(user.getUID()) && delegateTaskUser.size() == 0) {
            return;
        }
        int emailNotifyType = userTaskModel.getEmailNotifyType();
        if ((emailNotifyType == 2 || emailNotifyType == 3) && !UtilString.isEmpty(emailNotifyTemplateId = userTaskModel.getEmailNotifyTemplate()) && (responseObject = SDK.getNotificationAPI().getEmailTemplate(emailNotifyTemplateId)) != null && responseObject.isOk()) {
            JSONObject mailTemplateJO = JSONObject.parseObject((String)responseObject.toDataString());
            ArrayList<UserModel> allUsers = new ArrayList<UserModel>();
            if (!taskInst.getTarget().equals(user.getUID())) {
                UserModel um = UserCache.getModel((String)taskInst.getTarget());
                allUsers.add(um);
            }
            for (String s : delegateTaskUser) {
                allUsers.add(UserCache.getModel((String)s));
            }
            for (UserModel userModel : allUsers) {
                if (userModel == null || userModel.isClosed() || UtilString.isEmpty(userModel.getEmail())) continue;
                String to = userModel.getEmail();
                String cc = mailTemplateJO.getString("copyto");
                String title = mailTemplateJO.getString("email_title");
                String content = mailTemplateJO.getString("email_content");
                cc = SDK.getRuleAPI().executeAtScript(cc, user, processInst, taskInst, null);
                title = SDK.getRuleAPI().executeAtScript(title, user, processInst, taskInst, null);
                content = SDK.getRuleAPI().executeAtScript(content, user, processInst, taskInst, null);
                String host = SDK.getConfAPI().getPortalUrl();
                String taskUrl = String.valueOf(host) + "/r/w?cmd=CLIENT_BPM_WORKLIST_TASK_PORTAL_ENV&tokenId=" + tokenId;
                content = content.replaceAll("%TASK_LINK%", taskUrl);
                SDK.getNotificationAPI().sendEMailAsync("", to, cc, title, content);
            }
        }
    }

    public void taskTimeoutNotification(ProcessInstance processInst, TaskInstance taskInst, MonitoringModel policy) throws Exception {
        ResponseObject responseObject;
        if (processInst == null) {
            processInst = SDK.getProcessAPI().getInstanceById(taskInst.getProcessInstId());
        }
        if ((responseObject = SDK.getNotificationAPI().getEmailTemplate(policy.getMailTemplate())) != null && responseObject.isOk()) {
            JSONObject mailTemplateJO = JSONObject.parseObject((String)responseObject.toDataString());
            String to = "";
            UserModel user = SDK.getORGAPI().getUser(taskInst.getTarget());
            if (user != null && !user.isClosed()) {
                to = user.getEmail();
            }
            String cc = mailTemplateJO.getString("copyto");
            cc = SDK.getRuleAPI().executeAtScript(cc, null, processInst, taskInst, null);
            if (UtilString.isEmpty(to) && UtilString.isEmpty(cc)) {
                return;
            }
            String subject = mailTemplateJO.getString("email_title");
            subject = SDK.getRuleAPI().executeAtScript(subject, null, processInst, taskInst, null);
            String content = mailTemplateJO.getString("email_content");
            content = SDK.getRuleAPI().executeAtScript(content, null, processInst, taskInst, null);
            SDK.getNotificationAPI().sendEMailAsync("", to, cc, subject, content);
        }
    }

    public void taskCompleteNotification(TaskBehaviorContext taskContext, String templateId, String toUIDs) {
        ResponseObject responseObject = SDK.getNotificationAPI().getEmailTemplate(templateId);
        if (responseObject != null && responseObject.isOk()) {
            JSONObject mailTemplateJO = JSONObject.parseObject((String)responseObject.toDataString());
            List<String> ids = new UtilString(toUIDs).split(" ");
            String to = "";
            for (String uid : ids) {
                if (UtilString.isEmpty(uid)) continue;
                if (uid.indexOf("@") == -1) {
                    UserModel user = SDK.getORGAPI().getUser(uid);
                    if (user == null || UtilString.isEmpty(user.getEmail())) continue;
                    to = String.valueOf(to) + user.getEmail() + ";";
                    continue;
                }
                to = String.valueOf(to) + uid + ";";
            }
            if (to.length() > 0) {
                to = to.substring(0, to.length() - 1);
            }
            String cc = mailTemplateJO.getString("copyto");
            cc = SDK.getRuleAPI().executeAtScript(cc, (ProcessExecutionContext)taskContext);
            if (UtilString.isEmpty(to) && UtilString.isEmpty(cc)) {
                return;
            }
            String subject = mailTemplateJO.getString("email_title");
            subject = SDK.getRuleAPI().executeAtScript(subject, (ProcessExecutionContext)taskContext);
            String content = mailTemplateJO.getString("email_content");
            content = SDK.getRuleAPI().executeAtScript(content, (ProcessExecutionContext)taskContext);
            SDK.getNotificationAPI().sendEMailAsync("", to, cc, subject, content);
        }
    }
}

