/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mobile.push;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.PushPluginProfile;
import com.actionsoft.bpms.commons.mobile.push.PushListener;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.emm.mdm.model.DeviceModel;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PushPluginManager {
    private static List<PushPluginProfile> _list = new ArrayList<PushPluginProfile>();
    private static Map<String, PushListener> listeners = new ConcurrentHashMap<String, PushListener>();

    public static boolean registerPlugin(AppContext app, PushPluginProfile plugin) {
        plugin.setAppContext(app);
        _list.add(plugin);
        try {
            listeners.put(app.getId(), PushPluginManager.getObj(plugin));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static boolean destoryPlugin(AppContext app, PushPluginProfile plugin) {
        plugin.setAppContext(app);
        _list.remove(plugin);
        listeners.remove(app.getId());
        return true;
    }

    public static boolean pushMessageToSingle(String message, DeviceModel deviceModel) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                boolean result = listener.pushMessageToSingle(message, deviceModel);
                if (!result) continue;
                return result;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    public static void pushMessageToAll(int osType, String message) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                if (listener.supportOSType() != osType) continue;
                listener.pushMessageToAll(message);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void pushMessageToTag(int osType, String message, String ... tags) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                if (listener.supportOSType() != osType) continue;
                listener.pushMessageToTag(message, tags);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void pushNotificationToAll(int osType, String title, String content, Map<String, String> extras) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                if (listener.supportOSType() != osType) continue;
                listener.pushNotificationToAll(title, content, extras);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static boolean pushNotificationToSingle(String title, String content, Map<String, String> extras, DeviceModel deviceModel) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                boolean result = listener.pushNotificationToSingle(title, content, extras, deviceModel);
                if (!result) continue;
                return result;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return false;
    }

    public static void pushNotificationToTag(int osType, String title, String content, Map<String, String> extras, String ... tags) {
        ArrayList<PushListener> listenersCopy = new ArrayList<PushListener>();
        listenersCopy.addAll(listeners.values());
        for (PushListener listener : listenersCopy) {
            try {
                if (listener.supportOSType() != osType) continue;
                listener.pushNotificationToTag(title, content, extras, tags);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static PushListener getObj(PushPluginProfile profile) throws Exception {
        AppContext targetApp = profile.getAppContext();
        String serviceClassName = profile.getClazzName();
        Constructor cons = null;
        cons = ClassReflect.getConstructor(serviceClassName.trim(), null, targetApp);
        Object obj = cons.newInstance(new Object[0]);
        PushListener service = (PushListener)obj;
        return service;
    }
}

