/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mvc.dao;

import com.actionsoft.bpms.commons.mvc.dao.DaoQuery;
import com.actionsoft.bpms.commons.mvc.dao.IDaoObject;
import com.actionsoft.bpms.commons.mvc.dao.IDaoQuery;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.Connection;
import java.util.Map;

public abstract class DaoObject<M>
implements IDaoObject<M> {
    @Override
    public String pkFieldName() {
        return "ID";
    }

    @Override
    public int update(Object id, Map<String, Object> fields) throws AWSDataAccessException {
        return this.update(null, id, fields);
    }

    public int update(Connection conn, Object id, Map<String, Object> fields) throws AWSDataAccessException {
        if (fields == null) {
            throw new AWSDataAccessException(" 'fields' Does Not Allow Empty!");
        }
        StringBuilder sets = new StringBuilder();
        for (String field : fields.keySet()) {
            sets.append(field.toUpperCase()).append("=:").append(field.toUpperCase()).append(",");
        }
        sets.setLength(sets.length() - 1);
        String sql = "UPDATE " + this.entityName() + " SET " + sets.toString() + " WHERE " + this.pkFieldName() + "=:" + this.pkFieldName();
        fields.put(this.pkFieldName(), id);
        if (conn == null) {
            return DBSql.update(sql, fields);
        }
        return DBSql.update(conn, sql, fields);
    }

    @Override
    public int delete(Object id) throws AWSDataAccessException {
        return this.delete(null, id);
    }

    public int delete(Connection conn, Object id) throws AWSDataAccessException {
        String sql = "DELETE FROM " + this.entityName() + " WHERE " + this.pkFieldName() + "=?";
        if (conn == null) {
            return DBSql.update(sql, new Object[]{id});
        }
        return DBSql.update(conn, sql, new Object[]{id});
    }

    @Override
    public M queryById(Object id) {
        return this.queryById(null, id);
    }

    public M queryById(Connection conn, Object id) {
        String whereClause = String.valueOf(this.pkFieldName()) + "=?";
        String sql = "SELECT * FROM " + this.entityName() + " WHERE " + whereClause;
        return DBSql.getObject(conn, sql, this.rowMapper(), id);
    }

    @Override
    public M queryBy(String whereClause, Object ... args) {
        return this.queryBy(null, whereClause, args);
    }

    public M queryBy(Connection conn, String whereClause, Object ... args) {
        String sql = "SELECT * FROM " + this.entityName() + " WHERE " + whereClause;
        return DBSql.getObject(conn, sql, this.rowMapper(), args);
    }

    @Override
    public IDaoQuery<M> query() {
        return this.query(null, new Object[0]);
    }

    @Override
    public IDaoQuery<M> query(String whereClause, Object ... args) {
        return this.query(null, whereClause, args);
    }

    public IDaoQuery<M> query(Connection conn, String whereClause, Object ... args) {
        String sql = null;
        sql = UtilString.isEmpty(whereClause) ? "SELECT * FROM " + this.entityName() : "SELECT * FROM " + this.entityName() + " WHERE " + whereClause;
        return new DaoQuery(sql, this.rowMapper(), args);
    }
}

