/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mvc.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoOrderBy;
import com.actionsoft.bpms.commons.mvc.dao.IDaoQuery;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.util.DBSql;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DaoQuery<M>
implements IDaoQuery<M> {
    private Connection connection = null;
    private String sql;
    private Object[] args;
    private RowMapper<M> mapper;
    private List<DaoOrderBy> orderBy = new ArrayList<DaoOrderBy>();
    private Map<String, Object> paraMap = null;

    public DaoQuery(String sql, RowMapper<M> mapper, Object[] args) {
        this.sql = sql;
        this.mapper = mapper;
        this.args = args;
    }

    public DaoQuery(String sql, Map<String, Object> paraMap, RowMapper<M> mapper) {
        this.sql = sql;
        this.mapper = mapper;
        this.paraMap = paraMap;
    }

    public DaoQuery(Connection connection, String sql, Map<String, Object> paraMap, RowMapper<M> mapper) {
        this.connection = connection;
        this.sql = sql;
        this.mapper = mapper;
        this.paraMap = paraMap;
    }

    @Override
    public DaoOrderBy orderBy(String fieldName) {
        DaoOrderBy order = new DaoOrderBy(this, fieldName);
        this.orderBy.add(order);
        return order;
    }

    @Override
    public List<M> list() {
        StringBuilder orderBySql = new StringBuilder();
        if (this.orderBy.size() > 0) {
            orderBySql.append(" ORDER BY ");
            for (DaoOrderBy order : this.orderBy) {
                orderBySql.append(" ").append(order.getFieldName()).append(" ").append(order.getOrder()).append(",");
            }
            orderBySql.setLength(orderBySql.length() - 1);
        }
        List<M> list = null;
        if (this.paraMap != null) {
            list = DBSql.query(this.connection, String.valueOf(this.sql) + orderBySql.toString(), this.paraMap, this.mapper);
            return list;
        }
        if (this.args == null) {
            list = DBSql.query(this.connection, String.valueOf(this.sql) + orderBySql.toString(), this.mapper, new Object[0]);
            return list;
        }
        list = DBSql.query(this.connection, String.valueOf(this.sql) + orderBySql.toString(), this.mapper, this.args);
        return list;
    }

    @Override
    public List<M> list(int firstRow, int rowCount) {
        StringBuilder orderBySql = new StringBuilder();
        if (this.orderBy.size() > 0) {
            orderBySql.append(" ORDER BY ");
            for (DaoOrderBy order : this.orderBy) {
                orderBySql.append(" ").append(order.getFieldName()).append(" ").append(order.getOrder()).append(",");
            }
            orderBySql.setLength(orderBySql.length() - 1);
        }
        String paginitionSql = SQLPagination.getPaginitionSQL(String.valueOf(this.sql) + orderBySql.toString(), firstRow, rowCount);
        if (this.paraMap != null) {
            return DBSql.query(this.connection, paginitionSql, this.paraMap, this.mapper);
        }
        if (this.args == null) {
            return DBSql.query(this.connection, paginitionSql, this.mapper, new Object[0]);
        }
        return DBSql.query(this.connection, paginitionSql, this.mapper, this.args);
    }
}

