/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mvc.dao;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppsResource;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelBean;
import com.actionsoft.bpms.commons.xmetadata.XFileVersionUtil;
import com.actionsoft.bpms.server.DeveloperKey;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.exception.AWSDataAccessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XDaoObject {
    private String modelType;

    public XDaoObject(String resourceBundle) {
        this.modelType = resourceBundle;
    }

    private String getResourceType() {
        return this.modelType.split("/")[1].toUpperCase();
    }

    public static String getResourceRealPath(AppContext app, String modelType) {
        return AppsAPIManager.getInstance().getResourceRealpath(app, modelType);
    }

    public static String getResourceRealPath(String appId, String modelType) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        return XDaoObject.getResourceRealPath(app, modelType);
    }

    private File getModelFolder(AppContext app, String id) {
        return new File(XDaoObject.getResourceRealPath(app, this.modelType), "_" + id);
    }

    private File getModelFolder(String appId, String id) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        return this.getModelFolder(app, id);
    }

    public File getModelFile(AppContext app, String id) {
        return new File(this.getModelFolder(app, id), String.valueOf(id) + ".xml");
    }

    public File getModelFile(String appId, String id) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        return this.getModelFile(app, id);
    }

    protected <T extends PlatformXMetaModelBean> void saveModel(String appId, T jaxbObject, Class<T> jaxbElementClass) throws AWSDataAccessException {
        this.saveModel(appId, jaxbObject, jaxbElementClass, true);
    }

    protected <T extends PlatformXMetaModelBean> void saveModel(String appId, T jaxbObject, Class<T> jaxbElementClass, boolean bakup) throws AWSDataAccessException {
        File folder;
        if (jaxbObject.getSignature() == null) {
            String sign = DeveloperKey.signature((String)jaxbObject.getId());
            jaxbObject.setSignature(sign);
        }
        if (!(folder = this.getModelFolder(appId, jaxbObject.getId())).exists()) {
            folder.mkdirs();
        }
        File file = this.getModelFile(appId, jaxbObject.getId());
        try {
            XFileVersionUtil.backup(file, jaxbObject.getId(), folder, bakup);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbElementClass});
            Marshaller mar = jaxbContext.createMarshaller();
            mar.setProperty("jaxb.formatted.output", (Object)true);
            mar.setProperty("jaxb.encoding", (Object)"UTF-8");
            mar.marshal(jaxbObject, file);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            folder.delete();
            throw new AWSDataAccessException("\u751f\u6210\u6a21\u578b\u6587\u4ef6\u65f6\u53d1\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public <T extends PlatformXMetaModelBean> T loadModel(File file, Class<T> jaxbElementClass) throws JAXBException {
        if (file.exists()) {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{jaxbElementClass});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader xsr = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                xsr = xif.createXMLStreamReader(fis);
                Object jaxb = ctx.createUnmarshaller().unmarshal(xsr);
                PlatformXMetaModelBean platformXMetaModelBean = (PlatformXMetaModelBean)jaxbElementClass.cast(jaxb);
                return (T)platformXMetaModelBean;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                if (xsr != null) {
                    try {
                        xsr.close();
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
            }
        }
        return null;
    }

    protected <T extends PlatformXMetaModelBean> T loadModel(String appId, String id, Class<T> jaxbElementClass) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        return this.loadModel(app, id, jaxbElementClass);
    }

    protected <T extends PlatformXMetaModelBean> T loadModel(AppContext app, String id, Class<T> jaxbElementClass) {
        File file = this.getModelFile(app, id);
        PlatformXMetaModelBean model = null;
        if (!file.exists()) {
            AppsLogger.warn((AppContext)app, (String)(String.valueOf(this.getResourceType()) + "\u6a21\u578b\u5e93\u4e2d\u4e0d\u5b58\u5728\u53ef\u7528\u6a21\u578b\u6587\u4ef6[" + file.getName() + "]"));
        } else {
            block5: {
                try {
                    model = (PlatformXMetaModelBean)this.loadModel(file, jaxbElementClass);
                    if (id.equals(model.getId())) break block5;
                    AppsLogger.warn((AppContext)app, (String)(String.valueOf(this.getResourceType()) + "[" + file.getName() + "]\u6587\u4ef6\u540d\u4e0e\u5185\u90e8id\u5c5e\u6027\u4e0d\u4e00\u81f4"));
                }
                catch (JAXBException e) {
                    e.printStackTrace(System.err);
                    AppsLogger.warn((AppContext)app, (String)(String.valueOf(this.getResourceType()) + "[" + file.getName() + "]\u4e0d\u662f\u6807\u51c6\u7684\u6a21\u578b\u6587\u4ef6[" + e.toString() + "]"), (String)"\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7");
                    return null;
                }
                return null;
            }
            if (model != null) {
                model.setAppId(app.getId());
            }
        }
        return (T)model;
    }

    protected <T extends PlatformXMetaModelBean> Map<String, T> loadAllByAppId(String appId, Class<T> jaxbElementClass) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        return this.loadAllByAppId(app, jaxbElementClass);
    }

    protected <T extends PlatformXMetaModelBean> Map<String, T> loadAllByAppId(AppContext app, Class<T> jaxbElementClass) {
        ConcurrentHashMap<String, T> map = new ConcurrentHashMap<String, T>();
        File[] fs = new File(XDaoObject.getResourceRealPath(app, this.modelType)).listFiles();
        if (fs != null) {
            try {
                int success = 0;
                int fail = 0;
                File[] fileArray = fs;
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String id = file.getName();
                    if (id.indexOf(95) == 0) {
                        T result = this.loadModel(app, id.substring(1), jaxbElementClass);
                        if (result != null) {
                            map.put(id.substring(1), result);
                            ++success;
                        } else {
                            ++fail;
                        }
                    } else if (!AppsResource.isIgnoreResource((File)file)) {
                        AppsLogger.warn((AppContext)app, (String)("\u5b58\u5728\u4e0d\u5408\u6807\u51c6\u7684\u6a21\u578b\u6587\u4ef6\u76ee\u5f55[" + id + "]"));
                    }
                    ++n2;
                }
                if (success > 0) {
                    AppsLogger.info((AppContext)app, (String)("\u52a0\u8f7d" + this.getResourceType() + "\u6a21\u578b[" + success + "\u4e2a][\u6210\u529f]"));
                    ConsolePrinter.info("[" + app.getName() + "]\u52a0\u8f7d" + this.getResourceType() + "\u6a21\u578b[" + success + "\u4e2a][\u6210\u529f]");
                }
                if (fail > 0) {
                    AppsLogger.err((AppContext)app, (String)("\u52a0\u8f7d" + this.getResourceType() + "\u6a21\u578b[" + fail + "\u4e2a][\u5931\u8d25]"), (String)"\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new AWSDataAccessException(AppsLogger.err((AppContext)app, (String)("\u52a0\u8f7d" + this.getResourceType() + "\u6a21\u578b[" + app.getName() + "]\u5f02\u5e38"), (String)"\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7", (Exception)e));
            }
        }
        return map;
    }

    protected boolean remove(String appId, String id) throws AWSDataAccessException {
        File folder = this.getModelFolder(appId, id);
        if (!folder.exists()) {
            AppsLogger.info((AppContext)AppsAPIManager.getInstance().getAppContext(appId), (String)("\u5e94\u7528" + appId + "\u4e2d\u627e\u4e0d\u5230" + this.getResourceType() + "\u6a21\u578b\u76ee\u5f55[_" + id + "]"));
            return true;
        }
        return UtilFile.removeFile(folder);
    }
}

