/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mvc.model;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.bundler.BOModelResourceBundler;
import com.actionsoft.apps.resource.bundler.DWModelResourceBundler;
import com.actionsoft.apps.resource.bundler.FormModelResourceBundler;
import com.actionsoft.bpms.bo.design.dao.BODaoFactory;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.bpmn.engine.cache.util.ProcessDefUtil;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.bpmn.modeler.designer.ProcessBPMNDesignerWeb;
import com.actionsoft.bpms.bpmn.modeler.io.BPMNIO;
import com.actionsoft.bpms.bpmn.modeler.io.helper.BPMNFile;
import com.actionsoft.bpms.bpmn.modeler.model.Definitions;
import com.actionsoft.bpms.bpmn.modeler.model.Process;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.dictionary.model.DictModel;
import com.actionsoft.bpms.commons.dictionary.util.Xml2DictUtil;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelBean;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.dw.design.dao.AWSDWDaoFactory;
import com.actionsoft.bpms.dw.design.model.DWModel;
import com.actionsoft.bpms.form.design.dao.FormDaoFactory;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilSerialize;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.ArrayUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PlatformXMetaModelHelper {
    public static boolean isAdministrator(String appId, String uid, String admStr) {
        if (GradeSecurityUtil.isSuperMaster(uid)) {
            return true;
        }
        if (GradeSecurityUtil.isGlobalMaster(uid)) {
            return true;
        }
        boolean result = false;
        if (!UtilString.isEmpty(appId)) {
            AppContext app = SDK.getAppAPI().getAppContext(appId);
            String appAdmin = app.getModelAdministrator();
            if (AMCAPIManager.isManagementApp(appId, uid) || AMCAPIManager.isDevelopApp(appId, uid)) {
                return true;
            }
            result = PlatformXMetaModelHelper.isAdministrator(appAdmin, uid);
            if (result) {
                return true;
            }
        }
        if (!UtilString.isEmpty(admStr)) {
            result = PlatformXMetaModelHelper.isAdministrator(admStr, uid);
        }
        return result;
    }

    public static boolean isAdministrator(String admStr, String uid) {
        UserModel me = UserCache.getModel((String)uid);
        if (!UtilString.isEmpty(admStr)) {
            if ((" " + admStr.trim() + " ").contains(" " + uid + " ")) {
                return true;
            }
            String[] manager = admStr.split(" ");
            int j = 1;
            while (j < manager.length) {
                RoleModel role;
                if (manager[j].length() == 36 && (role = RoleCache.getModel((String)manager[j])) != null && role.getId().equals(me.getRoleId())) {
                    return true;
                }
                ++j;
            }
            List roleList = UserMapCache.getMapListOfUser((String)uid);
            for (UserMapModel umm : roleList) {
                if (!admStr.contains(umm.getRoleId())) continue;
                return true;
            }
        }
        return false;
    }

    public static ResponseObject migrateCatetory(PlatformXMetaModelBean model, String newCategory) {
        if (model instanceof BOModel) {
            BOModel boModel = (BOModel)model;
            boModel.setCategoryName(newCategory);
            BODaoFactory.createBO((BOModel)boModel).store(boModel);
        }
        if (model instanceof FormModel) {
            FormModel formModel = (FormModel)model;
            formModel.setCategoryName(newCategory);
            FormDaoFactory.createForm().store(formModel);
        }
        if (model instanceof DWModel) {
            DWModel dwModel = (DWModel)model;
            dwModel.setCategoryName(newCategory);
            AWSDWDaoFactory.createAwsDw().store(dwModel);
        }
        return null;
    }

    public static ResponseObject migrateCatetory(DictModel model, String newCategory) {
        model.setCategoryName(newCategory);
        JSONObject json = new JSONObject();
        json.put("categoryName", (Object)newCategory);
        return null;
    }

    public static void addAdministrator(PlatformXMetaModelBean model, String admStr) {
        String admin;
        if (model instanceof BOModel) {
            BOModel boModel = (BOModel)model;
            admin = boModel.getAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            boModel.setAdministrator(admin.trim());
            BODaoFactory.createBO((BOModel)boModel).store(boModel);
        }
        if (model instanceof FormModel) {
            FormModel formModel = (FormModel)model;
            admin = formModel.getAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            formModel.setAdministrator(admin.trim());
            FormDaoFactory.createForm().store(formModel);
        }
        if (model instanceof DWModel) {
            DWModel dwModel = (DWModel)model;
            admin = dwModel.getProcessAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            dwModel.setProcessAdministrator(admin.trim());
            AWSDWDaoFactory.createAwsDw().store(dwModel);
        }
    }

    public static void addAdministrator(ProcessDefinition model, String admStr) {
        String admin = model.getProcessAdministrator();
        admin = PlatformXMetaModelHelper.union(admin, admStr);
        String appId = model.getAppId();
        Definitions definitions = BPMNIO.getDefinitions((String)appId, (String)model.getId());
        Process proces = (Process)definitions.getProcesses().get(0);
        JSONObject pp = JSONArray.parseObject((String)proces.getProperties());
        pp.put("processAdministrator", (Object)admin.trim());
        proces.setProperties(pp.toString());
        BPMNFile.getInstance((String)appId, (String)model.getId()).saveBPMN(appId, definitions);
    }

    public static void addAdministrator(DictModel model, String appId, String fileName, boolean isDict, String admStr) {
        String admin = model.getAdministrator();
        admin = PlatformXMetaModelHelper.union(admin, admStr);
        JSONObject json = new JSONObject();
        json.put("administrator", (Object)admin);
        try {
            Xml2DictUtil.setXmlProperty((String)appId, (String)fileName, (boolean)isDict, (JSONObject)json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String union(String s1, String s2) {
        String temp = " " + s1 + " ";
        String[] array = s2.split(" ");
        int i = 0;
        while (i < array.length) {
            String item = array[i];
            if (!UtilString.isEmpty(item) && !temp.contains(" " + item + " ")) {
                s1 = String.valueOf(s1) + " " + item;
            }
            ++i;
        }
        return s1.trim();
    }

    public static void transfer(String _me, PlatformXMetaModelBean model, String admStr) {
        String admin;
        if (model instanceof BOModel) {
            BOModel boModel = (BOModel)model;
            admin = boModel.getAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            admin = (" " + admin + " ").replace(" " + _me + " ", " ");
            boModel.setAdministrator(admin.trim());
            BODaoFactory.createBO((BOModel)boModel).store(boModel);
        }
        if (model instanceof FormModel) {
            FormModel formModel = (FormModel)model;
            admin = formModel.getAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            admin = (" " + admin + " ").replace(" " + _me + " ", " ");
            formModel.setAdministrator(admin.trim());
            FormDaoFactory.createForm().store(formModel);
        }
        if (model instanceof DWModel) {
            DWModel dwModel = (DWModel)model;
            admin = dwModel.getProcessAdministrator();
            admin = PlatformXMetaModelHelper.union(admin, admStr);
            admin = (" " + admin + " ").replace(" " + _me + " ", " ");
            dwModel.setProcessAdministrator(admin.trim());
            AWSDWDaoFactory.createAwsDw().store(dwModel);
        }
    }

    public static void transfer(String _me, ProcessDefinition model, String admStr) {
        String admin = model.getProcessAdministrator();
        admin = PlatformXMetaModelHelper.union(admin, admStr);
        admin = (" " + admin + " ").replace(" " + _me + " ", " ");
        String appId = model.getAppId();
        HashMap<String, String> pp = new HashMap<String, String>();
        pp.put("processAdministrator", admin.trim());
        ProcessDefUtil.updateProcessDefinition((String)appId, (String)model.getId(), pp);
    }

    public static void transfer(String _me, DictModel model, String appId, String fileName, boolean isDict, String admStr) {
        String admin = model.getAdministrator();
        admin = PlatformXMetaModelHelper.union(admin, admStr);
        admin = (" " + admin + " ").replace(" " + _me + " ", " ");
        JSONObject json = new JSONObject();
        json.put("administrator", (Object)admin.trim());
        try {
            Xml2DictUtil.setXmlProperty((String)appId, (String)fileName, (boolean)isDict, (JSONObject)json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getModelOpHistory(UserContext userContext, AppContext app, String defId, String modelType) {
        File[] pathList;
        BOModelResourceBundler bundler = new BOModelResourceBundler(app);
        String path = "";
        JSONArray dataArr = new JSONArray();
        if ("process".equals(modelType)) {
            ProcessBPMNDesignerWeb web = new ProcessBPMNDesignerWeb(userContext);
            Map map = web.getHistoryVersions(app.getId(), defId);
            JSONArray versions = (JSONArray)map.get("versions");
            if (UtilString.isEmpty(versions)) return dataArr.toString();
            int len = versions.size();
            int i = len - 1;
            while (i > 0) {
                JSONObject item = UtilSerialize.parseObject(versions.get(i).toString());
                Integer verId = Integer.valueOf(item.getString("versionId"));
                if (verId > 0) {
                    JSONObject obj = new JSONObject();
                    JSONArray user = JSONArray.parseArray((String)item.getString("userIds"));
                    obj.put("updateUser", (Object)user.getString(0));
                    obj.put("updateTime", (Object)item.getString("updateTime"));
                    obj.put("title", (Object)((ProcessDefinition)ProcessDefCache.getInstance().getModel(defId)).getName());
                    dataArr.add((Object)obj);
                }
                --i;
            }
            return dataArr.toString();
        }
        if ("form".equals(modelType)) {
            bundler = new FormModelResourceBundler(app);
        } else if ("dw".equals(modelType)) {
            bundler = new DWModelResourceBundler(app);
        }
        path = String.valueOf(path) + bundler.getRealpath() + "/_" + defId;
        File file = new File(path);
        if (UtilString.isEmpty(file) || UtilString.isEmpty(pathList = file.listFiles())) return dataArr.toString();
        int len = pathList.length;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            SAXReader saxReader = new SAXReader();
            DocumentBuilder db = dbf.newDocumentBuilder();
            if (len <= 0) return dataArr.toString();
            int i = 0;
            while (i < len - 1) {
                String xmlPath = String.valueOf(path) + "/" + defId + "_" + (i + 1) + ".xml";
                File f = new File(xmlPath);
                if (f.exists()) {
                    try {
                        Document document = saxReader.read(xmlPath);
                        Element employees = document.getRootElement();
                        String user = employees.elementText("updateUser");
                        if (UtilString.isEmpty(user)) {
                            user = employees.elementText("createUser");
                        }
                        String time = employees.elementText("updateTime");
                        String title = "";
                        title = "dw".equals(modelType) ? employees.element("title").attributeValue("label") : employees.elementText("title");
                        JSONObject obj = new JSONObject();
                        obj.put("updateUser", (Object)user);
                        obj.put("updateTime", (Object)time);
                        obj.put("title", (Object)title);
                        dataArr.add((Object)obj);
                    }
                    catch (DocumentException documentException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return dataArr.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataArr.toString();
    }

    public static boolean isTemplateApp(String appId) {
        String templateApp = SDK.getAppAPI().getProperty("_bpm.platform", "templateApp");
        Object[] array = templateApp.trim().split(",");
        return ArrayUtils.contains((Object[])array, (Object)appId);
    }
}

