/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.mvc.view;

import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.ExceptionUtil;
import com.actionsoft.framework.io.Exchange;
import com.actionsoft.i18n.I18nRes;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public final class ResponseObject {
    public static final String SUCCESS = "ok";
    public static final String WARNING = "warning";
    public static final String ERROR = "error";
    private String result = "ok";
    private String errorCode = "";
    private String msg = "";
    private Object data = null;
    private Object pointer = null;
    private Object pointer2 = null;
    private String id = ":RO;";

    public ResponseObject errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static ResponseObject newOkResponse() {
        ResponseObject ro = new ResponseObject(SUCCESS);
        return ro;
    }

    public static ResponseObject newOkResponse(String msg) {
        ResponseObject ro = new ResponseObject(SUCCESS);
        return ro.ok(msg);
    }

    public static ResponseObject newWarnResponse() {
        ResponseObject ro = new ResponseObject(WARNING);
        return ro;
    }

    public static ResponseObject newWarnResponse(String msg) {
        ResponseObject ro = new ResponseObject(WARNING);
        return ro.warn(msg);
    }

    public static ResponseObject newErrResponse() {
        ResponseObject ro = new ResponseObject(ERROR);
        return ro;
    }

    public static ResponseObject newErrResponse(String msg) {
        ResponseObject ro = new ResponseObject(ERROR);
        return ro.err(msg);
    }

    public static ResponseObject parse(String str) {
        ResponseObject r = ResponseObject.newOkResponse();
        com.alibaba.fastjson.JSONObject jsonObject = com.alibaba.fastjson.JSONObject.parseObject((String)str);
        r.result = jsonObject.getString("result");
        r.errorCode = jsonObject.getString("errorCode");
        r.msg = jsonObject.getString("msg");
        r.data = jsonObject.get((Object)"data");
        return r;
    }

    private ResponseObject(String result) {
        this.result = result;
    }

    public ResponseObject ok() {
        this.result = SUCCESS;
        return this;
    }

    public ResponseObject warn() {
        this.result = WARNING;
        return this;
    }

    public ResponseObject err() {
        this.result = ERROR;
        return this;
    }

    public boolean isOk() {
        return this.result.equals(SUCCESS);
    }

    public boolean isWarn() {
        return this.result.equals(WARNING);
    }

    public boolean isErr() {
        return this.result.equals(ERROR);
    }

    public String getMsg() {
        return this.msg;
    }

    public ResponseObject ok(String msg) {
        this.ok();
        this.msg(msg);
        return this;
    }

    public ResponseObject warn(String msg) {
        this.warn();
        this.msg(msg);
        return this;
    }

    public ResponseObject err(String msg) {
        this.err();
        this.msg(msg);
        return this;
    }

    public ResponseObject err(Throwable t) {
        this.err();
        this.msg(ExceptionUtil.getMessage(t));
        return this;
    }

    public ResponseObject msg(String msg) {
        if (!UtilString.isEmpty(msg)) {
            String lang = I18nRes.getUserLanguage();
            String appId = "_bpm.portal";
            if (DispatcherRequest.getContext() != null && DispatcherRequest.getContext().getExchange() != null) {
                Exchange exchange = DispatcherRequest.getContext().getExchange();
                Map<String, String> parameters = exchange.getParameters();
                if (parameters != null && parameters.containsKey("lang")) {
                    lang = parameters.get("lang");
                }
                if (parameters != null && parameters.containsKey("appId")) {
                    appId = parameters.get("appId");
                }
                if (UtilString.isEmpty(appId) && DispatcherRequest.getContext().getAppContext() != null) {
                    appId = DispatcherRequest.getContext().getAppContext().getId();
                }
                if (UtilString.isEmpty(appId)) {
                    appId = "_bpm.portal";
                }
            }
            msg = I18nRes.findValue(appId, lang, msg);
        }
        this.msg = msg;
        return this;
    }

    public Object get(String key) {
        if (this.pointer == null) {
            return null;
        }
        return ((Map)this.pointer).get(key);
    }

    public boolean containsKey(String key) {
        if (this.pointer == null) {
            return false;
        }
        return ((Map)this.pointer).containsKey(key);
    }

    public ResponseObject put(String key, Object value) {
        if (this.pointer == null && this.data == null) {
            this.data = new HashMap();
            this.pointer = this.data;
        }
        if ("desc".equals(key) && !UtilString.isEmpty(value)) {
            value = I18nRes.findValue("_bpm.platform", value.toString());
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                if (str.startsWith("{")) {
                    com.alibaba.fastjson.JSONObject valueJson = JSON.parseObject((String)str);
                    ((Map)this.pointer).put(key, valueJson);
                    return this;
                }
            }
            catch (Exception valueJson) {
                // empty catch block
            }
            try {
                if (str.startsWith("[")) {
                    JSONArray valueArr = JSON.parseArray((String)((String)value));
                    ((Map)this.pointer).put(key, valueArr);
                    return this;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ((Map)this.pointer).put(key, value);
        return this;
    }

    public ResponseObject put(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.put(key, map.get(key));
            }
        }
        return this;
    }

    public ResponseObject addObject() {
        if (this.data == null) {
            this.data = new ArrayList();
            this.pointer2 = this.data;
        }
        HashMap jo = new HashMap();
        ((List)this.pointer2).add(jo);
        this.pointer = jo;
        return this;
    }

    public ResponseObject addArray() {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        ArrayList jo = new ArrayList();
        ((List)this.data).add(jo);
        this.pointer2 = jo;
        return this;
    }

    public ResponseObject end() {
        this.pointer2 = this.data;
        return this;
    }

    public void setData(Object data) {
        if (data instanceof String) {
            String str = (String)data;
            try {
                if (str.startsWith("{")) {
                    com.alibaba.fastjson.JSONObject valueJson = JSON.parseObject((String)str);
                    this.data = valueJson;
                    return;
                }
            }
            catch (Exception valueJson) {
                // empty catch block
            }
            try {
                if (str.startsWith("[")) {
                    JSONArray valueArr = JSON.parseArray((String)str);
                    this.data = valueArr;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public <T> T getData(Class<T> t) {
        return t.cast(this.data);
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"data", this.data);
        jsonObject.put((Object)"msg", (Object)this.msg);
        jsonObject.put((Object)"id", (Object)this.id);
        if (!UtilString.isEmpty(this.errorCode)) {
            jsonObject.put((Object)"errorCode", (Object)this.errorCode);
        }
        jsonObject.put((Object)"result", (Object)this.result);
        return jsonObject;
    }

    public com.alibaba.fastjson.JSONObject toJSONObject() {
        com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
        obj.put("data", this.data);
        obj.put("msg", (Object)this.msg);
        obj.put("id", (Object)this.id);
        if (!UtilString.isEmpty(this.errorCode)) {
            obj.put("errorCode", (Object)this.errorCode);
        }
        obj.put("result", (Object)this.result);
        return obj;
    }

    public String toDataString() {
        if (this.data == null) {
            return "{}";
        }
        if (JSONObject.class.isAssignableFrom(this.data.getClass())) {
            return ((JSONObject)this.data).toString();
        }
        if (net.sf.json.JSONArray.class.isAssignableFrom(this.data.getClass())) {
            return ((net.sf.json.JSONArray)this.data).toString();
        }
        if (String.class.isAssignableFrom(this.data.getClass())) {
            return (String)this.data;
        }
        return JSON.toJSONString((Object)this.data);
    }

    public String toXML() {
        return "<result id=\"" + this.id + "\" type=\"" + this.result + "\" errorCode=\"" + this.errorCode + "\" msg=\"" + this.msg + "\" />";
    }
}

