/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.oauth;

import com.actionsoft.bpms.commons.oauth.IOauth;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractOauth
implements IOauth {
    private Map<String, String> cookies = null;

    @Override
    public abstract boolean hasOauthPage();

    @Override
    public abstract String getOauthPage(RequestParams var1);

    @Override
    public abstract String validate(RequestParams var1) throws IOException;

    @Override
    public String getSuccessRedirectUrl(RequestParams params) {
        String originalCmd;
        String cmd = originalCmd = params.get("originalCmd");
        if (originalCmd == null) {
            cmd = "CLIENT_USER_HOME";
        }
        StringBuilder redriectUrl = new StringBuilder();
        redriectUrl.append("../r/or?");
        redriectUrl.append("cmd=").append(cmd);
        if (originalCmd != null) {
            Map map = params.asMap();
            for (String key : map.keySet()) {
                if (key.equals("cmd") || key.equals("originalCmd") || key.equals("responseType") || key.equals("state") || key.equals("code") || key.equals("clientIp") || key.equals("serverName")) continue;
                try {
                    redriectUrl.append("&").append(key).append("=").append(URLEncoder.encode((String)map.get(key), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return redriectUrl.toString();
    }

    @Override
    public String getFailRedirectUrl(RequestParams params) {
        return null;
    }

    @Override
    public long getCookieTime(UserModel user) {
        return -1L;
    }

    @Override
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public void addCookie(String key, String value) {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, String>();
        }
        this.cookies.put(key, value);
    }

    @Override
    public String getDeviceType(UserContext context) {
        String deviceType = "pc";
        if (DispatcherRequest.getContext() != null && DispatcherRequest.getContext().getUserAgent() != null) {
            String userAgent = DispatcherRequest.getContext().getUserAgent().toLowerCase();
            if (userAgent.contains("wxwork") || userAgent.contains("micromessenger")) {
                deviceType = "weixin";
                if (userAgent.contains("windowswechat") || userAgent.contains("macintosh")) {
                    deviceType = "pc";
                }
            } else if (userAgent.contains("android") || userAgent.contains("iphone") || userAgent.contains("ipad")) {
                deviceType = "mobileweb";
            }
        }
        return deviceType;
    }
}

