/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.oauth;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.OauthPluginProfile;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.oauth.IOauth;
import com.actionsoft.bpms.commons.oauth.OauthProfileManager;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.SSOUtil;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class OauthWeb {
    public String getOauthPage(UserContext context, RequestParams params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String oauthName = params.get("oauthName");
        IOauth oauth = this.getIOauthByName(oauthName);
        if (oauth != null) {
            if (oauth.hasOauthPage()) {
                ro.put("oauthPage", oauth.getOauthPage(params));
            } else {
                String redirectUrl;
                String lang = params.get("lang");
                String userIp = params.get("clientIp");
                try {
                    String uid = oauth.validate(params);
                    if (uid == null) {
                        ro.err("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25!");
                    } else {
                        String sessionId = new SSOUtil().registerClientSessionNoPassword(uid, lang, userIp, oauth.getDeviceType(context));
                        if (!UtilString.isEmpty(sessionId)) {
                            ro.put("sid", sessionId);
                            UserModel userModel = UserCache.getModel((String)uid);
                            ro.put("sessionTime", oauth.getCookieTime(userModel));
                            String redirectUrl2 = oauth.getSuccessRedirectUrl(params);
                            if (redirectUrl2 == null || redirectUrl2.length() == 0) {
                                throw new AWSException("redirectUrl\u672a\u6b63\u786e\u8fd4\u56de");
                            }
                            if (oauth.getCookies() != null) {
                                ro.put("cookies", oauth.getCookies());
                            }
                            ro.put("redirectUrl", redirectUrl2);
                        } else {
                            ro.err("\u521b\u5efaSession id\u5931\u8d25, oauthName=" + oauthName + ", uid=" + uid);
                        }
                    }
                }
                catch (IOException e) {
                    ro.err("\u4ece\u4e09\u65b9\u7cfb\u7edf\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u73b0\u7f51\u7edc\u5f02\u5e38, oauthName=" + oauthName + ", " + e.getMessage());
                    e.printStackTrace(System.err);
                }
                if (ro.isErr() && (redirectUrl = oauth.getFailRedirectUrl(params)) != null && redirectUrl.length() > 0) {
                    ro.put("redirectUrl", redirectUrl);
                }
            }
        } else {
            ro.err("\u627e\u4e0d\u5230Oauth Name" + oauthName + "\u5bf9\u5e94\u7684\u5904\u7406\u7c7b\uff0c \u8bf7\u68c0\u67e5\u662f\u5426\u6ce8\u518c\u4e86\u5bf9\u5e94\u7684\u7c7b");
        }
        return ro.toString();
    }

    public String validate(UserContext context, RequestParams params) {
        String redirectUrl;
        ResponseObject ro = ResponseObject.newOkResponse();
        String oauthName = params.get("oauthName");
        IOauth oauth = this.getIOauthByName(oauthName);
        String lang = params.get("lang");
        String userIp = params.get("clientIp");
        try {
            String uid = oauth.validate(params);
            if (uid == null) {
                ro.err("\u7528\u6237\u8ba4\u8bc1\u5931\u8d25!");
            } else {
                String sessionId = new SSOUtil().registerClientSessionNoPassword(uid, lang, userIp, oauth.getDeviceType(context));
                if (!UtilString.isEmpty(sessionId)) {
                    ro.put("sid", sessionId);
                    UserModel userModel = UserCache.getModel((String)uid);
                    ro.put("sessionTime", oauth.getCookieTime(userModel));
                    String redirectUrl2 = oauth.getSuccessRedirectUrl(params);
                    if (redirectUrl2 == null || redirectUrl2.length() == 0) {
                        throw new AWSException("redirectUrl\u672a\u6b63\u786e\u8fd4\u56de");
                    }
                    ro.put("redirectUrl", redirectUrl2);
                    if (oauth.getCookies() != null) {
                        ro.put("cookies", oauth.getCookies());
                    }
                } else {
                    ro.err("\u521b\u5efaSession id\u5931\u8d25, oauthName=" + oauthName + ", uid=" + uid);
                }
            }
        }
        catch (IOException e) {
            ro.err("\u4ece\u4e09\u65b9\u7cfb\u7edf\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u73b0\u7f51\u7edc\u5f02\u5e38, oauthName=" + oauthName + ", " + e.getMessage());
            e.printStackTrace(System.err);
        }
        if (ro.isErr() && (redirectUrl = oauth.getFailRedirectUrl(params)) != null && redirectUrl.length() > 0) {
            ro.put("redirectUrl", redirectUrl);
        }
        return ro.toString();
    }

    private IOauth getIOauthByName(String oauthName) {
        OauthPluginProfile profile = OauthProfileManager.getProfile(oauthName);
        if (profile != null) {
            AppContext targetApp = profile.getAppContext();
            String serviceClassName = profile.getClazzName();
            try {
                return this.getObj(targetApp, serviceClassName);
            }
            catch (Exception e) {
                throw new AWSException(e);
            }
        }
        return null;
    }

    private IOauth getObj(AppContext targetApp, String serviceClassName) throws Exception {
        Constructor cons = null;
        cons = ClassReflect.getConstructor(serviceClassName.trim(), null, targetApp);
        Object obj = cons.newInstance(new Object[0]);
        IOauth service = (IOauth)obj;
        return service;
    }
}

