/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.pagination;

import com.actionsoft.bpms.cc.Adapter;
import com.actionsoft.bpms.commons.database.RowCallbackHandler;
import com.actionsoft.bpms.commons.pagination.impl.DB2Pagination;
import com.actionsoft.bpms.commons.pagination.impl.MySQLPagination;
import com.actionsoft.bpms.commons.pagination.impl.Oracle9iPagination;
import com.actionsoft.bpms.commons.pagination.impl.OraclePagination;
import com.actionsoft.bpms.commons.pagination.impl.SQLServer2005Pagination;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.DBSql;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLPagination {
    public static String getPaginitionSQL(String sql, int start, int limit) {
        String dbSupply = AWSServerConf.getDatabaseProvider();
        return SQLPagination.getPaginitionSQL(dbSupply, sql, start, limit);
    }

    public static String getPaginitionSQL(Connection conn, String sql, int start, int limit) {
        String dbSupply = AWSServerConf.getDatabaseProvider();
        return SQLPagination.getPaginitionSQL(conn, dbSupply, sql, start, limit);
    }

    public static String getPaginitionSQL(String dbSupply, String sql, int start, int limit) {
        return SQLPagination.getPaginitionSQL(null, dbSupply, sql, start, limit);
    }

    public static String getPaginitionSQL(Connection conn, String dbSupply, String sql, int start, int limit) {
        boolean connFlag = false;
        if (conn == null) {
            connFlag = true;
            conn = DBSql.open();
        }
        try {
            if (limit > 1) {
                int n = start = start == 1 ? 0 : start;
                if (start % limit == 1) {
                    --start;
                }
            }
            if (dbSupply.equalsIgnoreCase("dm")) {
                String string = String.valueOf(sql) + " LIMIT " + start + "," + limit;
                return string;
            }
            if (dbSupply.toLowerCase().equals("oracle")) {
                DatabaseMetaData databaseMetaData = conn.getMetaData();
                int databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
                switch (databaseMajorVersion) {
                    case 9: {
                        String string = new Oracle9iPagination().getLimitString(sql, start, limit);
                        return string;
                    }
                }
                String string = new OraclePagination().getLimitString(sql, start, limit);
                return string;
            }
            if (dbSupply.equalsIgnoreCase("access")) {
                String string = Adapter.DB.buildPagingSQL((String)dbSupply, (String)sql, (int)start, (int)limit);
                return string;
            }
            if (dbSupply.toLowerCase().equals("sqlserver")) {
                String string = new SQLServer2005Pagination().getLimitString(sql, start, limit);
                return string;
            }
            if (dbSupply.toLowerCase().equals("mysql")) {
                String string = new MySQLPagination().getLimitString(sql, start, limit);
                return string;
            }
            if (dbSupply.toLowerCase().equals("db2")) {
                String string = new DB2Pagination().getLimitString(sql, start, limit);
                return string;
            }
            if (dbSupply.toLowerCase().equals("oscar")) {
                String string = "select * from (" + sql + ") limit " + limit + " OFFSET " + start;
                return string;
            }
            if (dbSupply.toLowerCase().equals(AWSServerConf.DB_PROVIDER_POSTGRESQL)) {
                String string = "select * from (" + sql + ") t limit " + limit + " OFFSET " + start;
                return string;
            }
            if (dbSupply.toLowerCase().equals("informix")) {
                String string = "SELECT skip " + start + " first " + limit + " * FROM (" + sql + ")";
                return string;
            }
            start = start == 0 ? 1 : start;
            start = start >= 1 ? start : 0;
            String statmentTmp = sql;
            String orderby = "";
            if (sql.toUpperCase().indexOf("ORDER BY") > 0) {
                statmentTmp = sql.substring(0, sql.toUpperCase().indexOf("ORDER BY")).trim();
                orderby = sql.substring(sql.toUpperCase().indexOf("ORDER BY"));
            }
            String tsql = "select top " + start + " id from (" + statmentTmp + ") t " + orderby;
            final StringBuilder s = new StringBuilder();
            DBSql.query(conn, tsql, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    s.append(rs.getInt("id")).append(',');
                }
            }, new Object[0]);
            if (s.length() == 0) {
                tsql = "select top " + limit + " * from (" + statmentTmp + ")t " + orderby;
            } else {
                tsql = s.toString();
                tsql = "select top " + limit + " * from (" + statmentTmp + ")t where t.id not in(" + tsql.substring(0, tsql.length() - 1) + ") " + orderby;
            }
            String string = tsql;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connFlag) {
                DBSql.close(conn);
            }
        }
        return sql;
    }
}

