/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.pagination.impl;

import com.actionsoft.bpms.commons.pagination.Paginition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLServer2005Pagination
implements Paginition {
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String DISTINCT = "distinct";
    private static final Pattern ALIAS_PATTERN = Pattern.compile("\\sas[^,]+(,?)");

    @Override
    public String getLimitString(String sql, int start, int limit) {
        String orderby;
        StringBuilder sb = new StringBuilder(sql.trim());
        int orderByIndex = sb.toString().toLowerCase().indexOf("order by");
        CharSequence charSequence = orderby = orderByIndex > 0 ? sb.subSequence(orderByIndex, sb.length()) : "ORDER BY CURRENT_TIMESTAMP";
        if (orderByIndex > 0) {
            sb.delete(orderByIndex, orderByIndex + orderby.length());
        }
        SQLServer2005Pagination.replaceDistinctWithGroupBy(sb);
        SQLServer2005Pagination.insertRowNumberFunction(sb, orderby);
        sb.insert(0, "WITH query AS (").append(") SELECT * FROM query ");
        sb.append("WHERE row_nr > " + start + " AND row_nr <= " + (start + limit));
        return sb.toString();
    }

    protected static void replaceDistinctWithGroupBy(StringBuilder sql) {
        int distinctIndex = sql.toString().toLowerCase().indexOf(DISTINCT);
        if (distinctIndex > 0) {
            sql.delete(distinctIndex, distinctIndex + DISTINCT.length() + 1);
            sql.append(" group by").append(SQLServer2005Pagination.getSelectFieldsWithoutAliases(sql));
        }
    }

    protected static CharSequence getSelectFieldsWithoutAliases(StringBuilder sql) {
        String select = sql.substring(sql.toString().toLowerCase().indexOf(SELECT) + SELECT.length(), sql.toString().toLowerCase().indexOf(FROM));
        Matcher matcher = ALIAS_PATTERN.matcher(select);
        return matcher.replaceAll("$1");
    }

    protected static void insertRowNumberFunction(StringBuilder sql, CharSequence orderby) {
        int selectEndIndex = sql.toString().toLowerCase().indexOf(FROM);
        sql.insert(selectEndIndex - 1, ", ROW_NUMBER() OVER (" + orderby + ") as row_nr");
    }
}

