/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.patch.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.patch.model.VersionModel;
import com.actionsoft.bpms.commons.patch.model.VersionPatchModel;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class VersionPatchDao
extends DaoObject<VersionModel> {
    @Override
    public int insert(VersionModel model) throws AWSDataAccessException {
        if (UtilString.isEmpty(model.getId())) {
            ((VersionPatchModel)model).setId(UUIDGener.getUUID());
            ((VersionPatchModel)model).setOpdate(new Timestamp(new Date().getTime()));
        }
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("ID", model.getId());
        paraMap.put("DOWNLOADID", model.getDownloadid());
        paraMap.put("VERSIONID", model.getVersionid());
        paraMap.put("OPSTATE", model.getOpstate());
        paraMap.put("OPDATE", model.getOpdate());
        paraMap.put("MD5DIGEST", model.getMd5digest());
        paraMap.put("ISDEGRADE", Short.parseShort(model.getIsdegrade()));
        paraMap.put("RELEASETYPE", Short.parseShort(model.getReleasetype()));
        String sql = DBSql.getInsertStatement(this.entityName(), paraMap);
        return DBSql.update(sql, paraMap);
    }

    @Override
    public int update(VersionModel model) throws AWSDataAccessException {
        throw new AWSDataAccessException("Not Support Update!");
    }

    public List<VersionModel> queryByVersionid(String versionid) {
        return this.query(" VERSIONID=? and OPSTATE!='degraded' ", versionid).orderBy("OPDATE").desc().list();
    }

    public List<VersionModel> getPlanningList() {
        return this.query(" OPSTATE=? or OPSTATE =?", "planning", "deplanning").orderBy("OPDATE").desc().list();
    }

    public String getOpState(String versionid) {
        return DBSql.getString("select OPSTATE from SYS_PATCH where VERSIONID=? and OPSTATE!='degraded'", new Object[]{versionid});
    }

    public String getOpDate(String versionid) {
        return DBSql.getString("select OPDATE from SYS_PATCH where VERSIONID=? and OPSTATE!='degraded'", new Object[]{versionid});
    }

    public String getDownloadid(String versionid) {
        return DBSql.getString("select DOWNLOADID from SYS_PATCH where VERSIONID=? and OPSTATE!='degraded'", new Object[]{versionid});
    }

    public int updateVersionDownloadId(String versionid, String downloadid) {
        return DBSql.update("update SYS_PATCH set DOWNLOADID='" + downloadid + "' where VERSIONID='" + versionid + "' and OPSTATE!='degraded'");
    }

    public int updateVersionState(String id, String state, Date date) {
        date = date == null ? new Date() : date;
        String sql = "UPDATE " + this.entityName() + " SET OPDATE=:OPDATE,OPSTATE=:OPSTATE  WHERE ID =:ID and OPSTATE!='degraded'";
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("OPDATE", new Timestamp(date.getTime()));
        fields.put("OPSTATE", state);
        fields.put("ID", id);
        return DBSql.update(sql, fields);
    }

    @Override
    public String entityName() {
        return "SYS_PATCH";
    }

    @Override
    public RowMapper<VersionModel> rowMapper() {
        return new Mapper();
    }

    private class Mapper
    implements RowMapper<VersionModel> {
        private Mapper() {
        }

        public VersionPatchModel mapRow(ResultSet rset, int rowNum) throws SQLException {
            VersionPatchModel model = new VersionPatchModel();
            model.setId(rset.getString("ID"));
            model.setDownloadid(rset.getString("DOWNLOADID"));
            model.setVersionid(rset.getString("VERSIONID"));
            model.setOpstate(rset.getString("OPSTATE"));
            model.setOpdate(rset.getTimestamp("OPDATE"));
            model.setMd5digest(rset.getString("MD5DIGEST"));
            model.setIsdegrade(rset.getString("ISDEGRADE"));
            model.setReleasetype(rset.getString("RELEASETYPE"));
            return model;
        }
    }
}

