/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.patch.web;

import com.actionsoft.bpms.commons.appstore.util.FileMD5Util;
import com.actionsoft.bpms.commons.cache.iae.IAECache;
import com.actionsoft.bpms.commons.cache.iae.model.IAEModel;
import com.actionsoft.bpms.commons.patch.dao.VersionPatchDao;
import com.actionsoft.bpms.commons.patch.model.VersionPatchModel;
import com.actionsoft.bpms.commons.patch.web.AbstractVersionThread;
import com.actionsoft.bpms.commons.patch.web.VersionWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilJson;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class DownloadVersion
extends AbstractVersionThread {
    public DownloadVersion(UserContext me, String versionid, String filesize, String url, String md5digest, String isdegrade, String releasetype) {
        super(me, versionid, filesize, url, md5digest, isdegrade, releasetype);
    }

    @Override
    public void download(String versionid) {
        IAEModel model = IAECache.getValue((String)versionid);
        VersionPatchDao dao = new VersionPatchDao();
        VersionPatchModel pModel = new VersionPatchModel();
        pModel.setIsdegrade(this.getIsdegrade());
        pModel.setMd5digest(this.getMd5digest());
        pModel.setVersionid(this.getVersionid());
        pModel.setReleasetype(this.getReleasetype());
        int bytesum = 0;
        int byteread = 0;
        InputStream inStream = null;
        FileOutputStream fs = null;
        String state = "2";
        try {
            try {
                URL url = new URL(model.getFileName());
                URLConnection conn = url.openConnection();
                long fileLength = conn.getContentLength();
                model.setTotal(Long.valueOf(fileLength));
                inStream = conn.getInputStream();
                fs = new FileOutputStream("../upgrade/" + versionid + ".upgrade");
                byte[] buffer = new byte[1024];
                while ((byteread = inStream.read(buffer)) != -1) {
                    model.setComplete(true);
                    bytesum += byteread;
                    fs.write(buffer, 0, byteread);
                    if ("stop".equals(model.getOrder())) {
                        state = "0";
                        break;
                    }
                    model.setNowNum(Integer.valueOf(bytesum));
                }
                File file = new File("../upgrade/" + versionid + ".upgrade");
                String md5 = FileMD5Util.getMD5(file).toLowerCase();
                model.setTitle(md5);
                model.setState("success");
                if (this.getMd5digest().toLowerCase().equals(md5)) {
                    pModel.setOpstate("downloaded");
                    state = "1";
                } else {
                    if (!"stop".equals(model.getOrder())) {
                        state = "2";
                    }
                    file.delete();
                }
                VersionWeb web = new VersionWeb(this.getUserContext());
                JSONObject objJson = web.getPaasCloudJson(this.getUserContext(), "downloaded", "", state, "", versionid);
                if ("ok".equals(UtilJson.optString(objJson, "result")) && "1".equals(state)) {
                    JSONObject data = objJson.getJSONObject("data");
                    String downloadid = UtilJson.optString(data, "downloadid");
                    pModel.setDownloadid(downloadid);
                    dao.insert(pModel);
                }
            }
            catch (Exception e) {
                model.setState("fail");
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e2) {
                    inStream = null;
                }
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (IOException e3) {
                    fs = null;
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException e) {
                inStream = null;
            }
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                fs = null;
            }
        }
    }

    public static void main(String[] args) {
        File file = new File("E:\\workaws6.0\\release\\patch\\6.2.1.1218.zip");
        file.delete();
    }
}

