/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.patch.web;

import com.actionsoft.bpms.commons.cache.iae.IAECache;
import com.actionsoft.bpms.commons.cache.iae.model.IAEModel;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.patch.dao.VersionPatchDao;
import com.actionsoft.bpms.commons.patch.model.VersionModel;
import com.actionsoft.bpms.commons.patch.web.DownloadVersion;
import com.actionsoft.bpms.server.AWSServer;
import com.actionsoft.bpms.server.CloudUpgradeInterface;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilJson;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class VersionWeb
extends ActionWeb {
    private UserContext _me;

    public VersionWeb(UserContext me) {
        this._me = me;
    }

    public String cancleDownload(UserContext me, String versionid) {
        ResponseObject json = ResponseObject.newOkResponse();
        IAEModel model = IAECache.getValue((String)versionid);
        model.setOrder("stop");
        json.put("data", model);
        json.put("state", "cancle");
        return json.toString();
    }

    public String planingInstall(UserContext me, String op, String plandate, String state, String versionid) {
        List<VersionModel> planList;
        ResponseObject json = ResponseObject.newOkResponse();
        VersionPatchDao dao = new VersionPatchDao();
        List<VersionModel> modelList = dao.queryByVersionid(versionid);
        VersionModel vModel = null;
        if (modelList == null || modelList.size() <= 0) {
            json.err();
            json.msg("\u8ba1\u5212\u5bf9\u8c61\u5728\u6570\u636e\u5e93\u4e0d\u5b58\u5728");
            return json.toString();
        }
        vModel = modelList.get(0);
        if (!"0".equals(state) && (planList = dao.getPlanningList()) != null && planList.size() > 0) {
            json.err();
            json.msg("\u6b64\u5e73\u53f0\u5df2\u7ecf\u5b58\u5728\u8ba1\u5212\u5347\u7ea7/\u964d\u7ea7\u7684\u4efb\u52a1,\u8bf7\u53d6\u6d88\u8ba1\u5212\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c");
            return json.toString();
        }
        String downloadid = dao.getDownloadid(versionid);
        if ("planning".equals(op)) {
            JSONObject paasJson;
            if (!"0".equals(state)) {
                boolean bool = this.buildBatFile(versionid, "planning");
                if (!bool) {
                    json.err();
                    json.msg("\u521b\u5efa\u65b0\u7248\u672c\u811a\u672c\u6587\u4ef6\u5931\u8d25");
                    return json.toString();
                }
            } else {
                String filepath = "../node-wrapper/upgrade.txt";
                VersionWeb.write(filepath, "0");
            }
            if (!"ok".equals(UtilJson.optString(paasJson = this.getPaasCloudJson(me, op, plandate, state, downloadid, ""), "result"))) {
                json.err();
                json.msg(UtilJson.optString(paasJson, "msg"));
            } else if (!"0".equals(state)) {
                plandate = "2".equals(state) ? UtilDate.datetimeFormat(new Date()) : String.valueOf(plandate) + " 03:00:00";
                Date planDatetime = UtilDate.parseDatetime(plandate);
                dao.updateVersionState(vModel.getId(), "planning", planDatetime);
                json.put("message", "\u5347\u7ea7\u8ba1\u5212\u5b89\u6392\u5728<B>" + plandate + "</B>\u6267\u884c");
            } else {
                dao.updateVersionState(vModel.getId(), "downloaded", null);
            }
        } else if ("deplanning".equals(op)) {
            JSONObject paasJson;
            op = "planning";
            if (!"0".equals(state)) {
                boolean bool = this.buildBatFile(versionid, "deplanning");
                if (!bool) {
                    json.err();
                    json.msg("\u521b\u5efa\u964d\u7ea7\u811a\u672c\u6587\u4ef6\u5931\u8d25");
                    return json.toString();
                }
            } else {
                String filepath = "../node-wrapper/upgrade.txt";
                VersionWeb.write(filepath, "0");
            }
            if (!"ok".equals(UtilJson.optString(paasJson = this.getPaasCloudJson(me, op, plandate, state, downloadid, ""), "result"))) {
                json.err();
                json.msg(UtilJson.optString(paasJson, "msg"));
            } else if (!"0".equals(state)) {
                plandate = "2".equals(state) ? UtilDate.datetimeFormat(new Date()) : String.valueOf(plandate) + " 03:00:00";
                Date planDatetime = UtilDate.parseDatetime(plandate);
                dao.updateVersionState(vModel.getId(), "deplanning", planDatetime);
                json.put("message", "\u964d\u7ea7\u8ba1\u5212\u5b89\u6392\u5728<B>" + plandate + "</B>\u6267\u884c");
            } else {
                dao.updateVersionState(vModel.getId(), "upgraded", null);
            }
        }
        return json.toString();
    }

    public boolean buildBatFile(String versionid, String type) {
        boolean isBuild = true;
        String filepath = "../node-wrapper/upgrade.txt";
        isBuild = VersionWeb.write(filepath, "1");
        if (!isBuild) {
            return isBuild;
        }
        try {
            if (VersionWeb.CheckOSOperate()) {
                String message = new UtilFile("../upgrade/upgrade.bat").readStr("GBK");
                if ("planning".equals(type)) {
                    message = message.replace("%1", String.valueOf(versionid) + ".upgrade");
                } else if ("deplanning".equals(type)) {
                    message = message.replace("upgrade %1", "degrade " + versionid);
                }
                UtilFile auto = new UtilFile("../upgrade/upgrade-auto.bat");
                if (auto.exists()) {
                    auto.delete();
                }
                auto.createNewFile();
                auto.write(message.getBytes("GBK"));
            } else {
                String message = new UtilFile("../upgrade/conf/upgrade-auto.tpl").readStr("UTF-8");
                if ("planning".equals(type)) {
                    message = message.replace("$filename $versionid", String.valueOf(versionid) + ".upgrade " + versionid);
                } else if ("deplanning".equals(type)) {
                    message = message.replace("upgrade $filename $versionid", "degrade " + versionid + " " + versionid);
                }
                UtilFile auto = new UtilFile("../upgrade/upgrade-auto.sh");
                if (auto.exists()) {
                    auto.delete();
                }
                auto.createNewFile();
                auto.writeUTF8(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isBuild;
    }

    public static synchronized boolean write(String filePath, String string) {
        FileOutputStream m_writer = null;
        try {
            m_writer = new FileOutputStream(filePath);
            byte[] b = string.getBytes();
            m_writer.write(b);
            m_writer.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean CheckOSOperate() {
        String os = System.getProperty("os.name");
        boolean OSWindow = true;
        OSWindow = os.startsWith("Windows");
        return OSWindow;
    }

    public JSONObject getPaasCloudJson(UserContext me, String op, String plandate, String state, String downloadid, String patchid) {
        JSONObject json = new JSONObject();
        json.put("action", (Object)"upgrade-state");
        JSONObject data = new JSONObject();
        data.put("op", (Object)op);
        data.put("state", (Object)state);
        data.put("plandate", (Object)plandate);
        data.put("downloadid", (Object)downloadid);
        data.put("patchid", (Object)patchid);
        json.put("data", (Object)data);
        return CloudUpgradeInterface.fireAction((JSONObject)json);
    }

    public String getVersionListJson(UserContext me, String versionStr) {
        VersionPatchDao dao = new VersionPatchDao();
        JSONObject jsonVersion = JSONArray.parseObject((String)versionStr);
        JSONArray jsonArray = jsonVersion.getJSONArray("data");
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonVersion.put("firstVersionShow", (Object)"../console/images/version_blue_new.gif");
            int i = 0;
            while (i < jsonArray.size()) {
                String opstate;
                JSONObject obj = (JSONObject)jsonArray.get(i);
                String versionid = UtilJson.optString(obj, "versionid");
                IAEModel model = IAECache.getValue((String)versionid);
                obj.put("opstate", (Object)"");
                obj.put("releasetypestr", (Object)("1".equals(UtilJson.optString(obj, "releasetype")) ? "\u6b63\u5f0f\u7248" : "\u9884\u89c8\u7248"));
                if (model != null) {
                    opstate = dao.getOpState(versionid);
                    if ("downloaded".equals(opstate)) {
                        obj.put("opstate", (Object)opstate);
                        obj.put("opstatestr", (Object)"\u5df2\u4e0b\u8f7d");
                        IAECache.removeValue((String)versionid);
                    } else if ("stop".equals(model.getOrder())) {
                        obj.put("opstatestr", (Object)"\u5f85\u4e0b\u8f7d");
                        IAECache.removeValue((String)versionid);
                    } else {
                        obj.put("opstate", (Object)"downloading");
                        obj.put("opstatestr", (Object)"\u4e0b\u8f7d\u4e2d");
                        obj.put("complete", (Object)model.isComplete());
                    }
                } else {
                    opstate = dao.getOpState(versionid);
                    if (opstate != null && !"".equals(opstate)) {
                        obj.put("opstate", (Object)opstate);
                        if ("planning".equals(opstate)) {
                            obj.put("opstatestr", (Object)"\u8ba1\u5212\u5347\u7ea7");
                            String opdate = dao.getOpDate(versionid);
                            opdate = UtilDate.datetimeFormat(UtilDate.parseDatetime(opdate));
                            obj.put("planmsg", (Object)("\u5347\u7ea7\u8ba1\u5212\u5b89\u6392\u5728<B>" + opdate + "</B>\u6267\u884c"));
                            jsonVersion.put("firstVersionShow", (Object)"../console/images/version_orange_planning.gif");
                        } else if ("downloaded".equals(opstate)) {
                            if ("../console/images/version_blue_new.gif".equals(UtilJson.optString(jsonVersion, "firstVersionShow"))) {
                                jsonVersion.put("firstVersionShow", (Object)"../console/images/version_blue_downloaded.png");
                            }
                            obj.put("opstatestr", (Object)"\u5df2\u4e0b\u8f7d");
                        }
                    } else {
                        obj.put("opstatestr", (Object)"\u5f85\u4e0b\u8f7d");
                    }
                }
                ++i;
            }
        } else {
            jsonVersion.put("firstVersionShow", (Object)"../console/images/version_ok.png");
        }
        List<VersionModel> modelList = dao.queryByVersionid(AWSServer.getInstance().getAWSVersion());
        VersionModel vModel = null;
        if (modelList != null && modelList.size() > 0) {
            vModel = modelList.get(0);
            JSONObject obj = new JSONObject();
            Timestamp opdate = vModel.getOpdate();
            obj.put("opdate", (Object)UtilDate.datetimeFormat(opdate));
            Calendar cc = Calendar.getInstance();
            cc.setTime(opdate);
            cc.add(5, 7);
            if (cc.getTimeInMillis() > System.currentTimeMillis() && "1".equals(vModel.getIsdegrade()) || "deplanning".equals(vModel.getOpstate())) {
                obj.put("showdegrade", (Object)true);
                obj.put("id", (Object)vModel.getId());
                obj.put("versionid", (Object)vModel.getVersionid());
                obj.put("url", (Object)"");
                obj.put("filesize", (Object)"");
                obj.put("releasedate", (Object)"");
                obj.put("releasetype", (Object)vModel.getReleasetype());
                obj.put("releasetypestr", (Object)("1".equals(vModel.getReleasetype()) ? "\u6b63\u5f0f\u7248" : "\u9884\u89c8\u7248"));
                obj.put("updatecontent", (Object)"");
                obj.put("md5digest", (Object)vModel.getMd5digest());
                obj.put("isdegrade", (Object)vModel.getIsdegrade());
                if ("deplanning".equals(vModel.getOpstate())) {
                    obj.put("opstatestr", (Object)"\u8ba1\u5212\u964d\u7ea7");
                } else {
                    obj.put("opstatestr", (Object)"\u5df2\u5347\u7ea7");
                }
                obj.put("opstate", (Object)vModel.getOpstate());
                if ("deplanning".equals(vModel.getOpstate())) {
                    String opdatestr = dao.getOpDate(vModel.getVersionid());
                    opdatestr = UtilDate.datetimeFormat(UtilDate.parseDatetime(opdatestr));
                    obj.put("planmsg", (Object)("\u964d\u7ea7\u8ba1\u5212\u5b89\u6392\u5728<B>" + opdatestr + "</B>\u6267\u884c"));
                }
                if (jsonArray == null) {
                    jsonArray = new JSONArray();
                    jsonArray.add((Object)obj);
                    jsonVersion.put("data", (Object)jsonArray);
                } else {
                    jsonArray.add((Object)obj);
                }
                jsonVersion.put("firstVersionShow", (Object)"../console/images/version_violet_degraded.gif");
            } else {
                obj.put("showdegrade", (Object)false);
            }
        }
        jsonVersion.put("id", (Object)":responseobject;");
        jsonVersion.put("nowVersion", (Object)AWSServer.getInstance().getAWSVersion());
        return jsonVersion.toString();
    }

    public String downloadVersion(UserContext me, String versionid, String filesize, String url, String md5digest, String isdegrade, String releasetype) {
        ResponseObject json = ResponseObject.newOkResponse();
        IAEModel model = IAECache.getValue((String)versionid);
        VersionPatchDao dao = new VersionPatchDao();
        if (model != null) {
            if ("stop".equals(model.getOrder()) || "success".equals(model.getState()) || "fail".equals(model.getState())) {
                json.put("data", model);
                json.put("removeCache", "remove");
                IAECache.removeValue((String)versionid);
                return json.toString();
            }
            json.msg("\u6b64\u7248\u672c\u6b63\u5728\u4e0b\u8f7d\uff0c\u8bf7\u7b49\u5f85");
            json.put("data", model);
            return json.toString();
        }
        IAEModel versionModel = new IAEModel(me);
        versionModel.setObjectId(versionid);
        versionModel.setAction("export");
        versionModel.setState("loading");
        versionModel.setFileName(url);
        DownloadVersion thread = new DownloadVersion(me, versionid, filesize, url, md5digest, isdegrade, releasetype);
        IAECache.putValue((String)versionid, (IAEModel)versionModel);
        Thread download = new Thread(thread);
        download.setName("AWS-Version-Download-" + me.getUID() + "-Versionid:" + versionid);
        download.start();
        json.put("data", versionModel);
        return json.toString();
    }
}

