/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.performer;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.plugin.profile.HumanPerformerPluginProfile;
import com.actionsoft.bpms.bpmn.engine.model.def.UserTaskModel;
import com.actionsoft.bpms.bpmn.engine.performer.HumanPerformerInterface;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSClassLoaderException;
import com.actionsoft.exception.AWSException;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.exception.AWSIllegalArgumentException;
import com.actionsoft.sdk.local.SDK;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public final class HumanPerformerManager {
    private static List<HumanPerformerPluginProfile> _list = new ArrayList<HumanPerformerPluginProfile>();

    private HumanPerformerManager() {
    }

    public static boolean registerPlugin(AppContext app, HumanPerformerPluginProfile profile) {
        for (HumanPerformerPluginProfile p : _list) {
            if (!p.getId().equals(profile.getId())) continue;
            p = profile;
            SDK.getAppAPI().err(app, "\u8def\u7531\u65b9\u6848[" + profile.getTitle() + "]\u5df2\u88ab\u6ce8\u518c");
            return false;
        }
        _list.add(profile);
        return true;
    }

    public static boolean destoryPlugin(AppContext app, HumanPerformerPluginProfile profile) {
        HumanPerformerPluginProfile p = HumanPerformerManager.getProfile(profile.getId());
        if (p != null) {
            _list.remove(p);
        }
        return true;
    }

    public static HumanPerformerPluginProfile getProfile(String id) {
        for (HumanPerformerPluginProfile p : _list) {
            if (!p.getId().equals(id)) continue;
            return p;
        }
        return null;
    }

    public static List<HumanPerformerPluginProfile> getList() {
        ArrayList<HumanPerformerPluginProfile> list = new ArrayList<HumanPerformerPluginProfile>();
        for (HumanPerformerPluginProfile p : _list) {
            if (!SDK.getAppAPI().isActive(p.getAppContext().getId())) continue;
            list.add(p);
        }
        return list;
    }

    public static HumanPerformerInterface getHumanPerformerObject(UserTaskModel userTaskModel) {
        String clazzName = userTaskModel.getRouteClazzName();
        return HumanPerformerManager.getHumanPerformerObject(clazzName);
    }

    public static HumanPerformerInterface getHumanPerformerObject(String clazzName) {
        if (UtilString.isEmpty(clazzName)) {
            throw new AWSIllegalArgumentException("\u8def\u7531\u65b9\u6848\u7c7b", "EMPT");
        }
        HumanPerformerPluginProfile profile = HumanPerformerManager.getProfile(clazzName);
        if (profile == null) {
            throw new AWSForbiddenException("\u8def\u7531\u65b9\u6848\u7c7b[" + clazzName + "]\u6ca1\u6709\u6ce8\u518c\uff0c\u64cd\u4f5c\u88ab\u62d2\u7edd\u3002");
        }
        if (!SDK.getAppAPI().isActive(profile.getAppContext().getId())) {
            throw new AWSForbiddenException("\u5e94\u7528[" + profile.getAppContext().getName() + "]\u5df2\u505c\u6b62\uff0c\u8def\u7531\u65b9\u6848[" + profile.getTitle() + "]\u6682\u4e0d\u53ef\u7528");
        }
        Constructor cons = null;
        try {
            Class[] parameterTypes = new Class[]{};
            cons = ClassReflect.getConstructor(clazzName, parameterTypes, profile.getAppContext());
            Class<?> clazz = profile.getAppContext().getBindClassLoader().loadClass(clazzName);
            HumanPerformerInterface obj = (HumanPerformerInterface)cons.newInstance(new Object[0]);
            return obj;
        }
        catch (AWSException e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw e;
        }
        catch (Exception e) {
            SDK.getAppAPI().err(profile.getAppContext(), String.valueOf(clazzName) + "--" + e.toString());
            throw new AWSClassLoaderException(e);
        }
    }
}

