/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.performer.util;

import com.actionsoft.bpms.bpmn.engine.dao.ProcessRuntimeDaoFactory;
import com.actionsoft.bpms.bpmn.engine.dao.TaskInstanceExec;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.cache.VDeptCache;
import com.actionsoft.bpms.org.cache.VUserCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.model.VDeptModel;
import com.actionsoft.bpms.org.model.VUserModel;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PerformerUtil {
    public static String getModelStr(String uid, String cid, String did, String rid) {
        return String.valueOf(uid) + "|" + cid + "|" + did + "|" + rid;
    }

    public static String getModelStr(UserMapModel umm, DepartmentModel dept) {
        return PerformerUtil.getModelStr(umm.getUID(), dept.getCompanyId(), umm.getDepartmentId(), umm.getRoleId());
    }

    public static String getModelStr(UserMapModel umm) {
        DepartmentModel dept = DepartmentCache.getModel((String)umm.getDepartmentId());
        return PerformerUtil.getModelStr(umm, dept);
    }

    public static String getModelStr(UserModel umm, DepartmentModel dept) {
        return PerformerUtil.getModelStr(umm.getUID(), dept.getCompanyId(), umm.getDepartmentId(), umm.getRoleId());
    }

    public static String getModelStr(UserModel umm) {
        DepartmentModel dept = DepartmentCache.getModel((String)umm.getDepartmentId());
        return PerformerUtil.getModelStr(umm, dept);
    }

    public static String getModelStr(VUserModel umm, VDeptModel dept) {
        return PerformerUtil.getModelStr(umm.getUID(), dept.getUnitId(), dept.getId(), umm.getRoleId());
    }

    public static String getModelStr(VUserModel umm) {
        VDeptModel dept = VDeptCache.getModel((String)umm.getDeptId());
        return PerformerUtil.getModelStr(umm, dept);
    }

    public static void buildMapByList(Set userMap, List<Object> users) {
        int i = 0;
        while (i < users.size()) {
            UserModel um;
            Object userObject = users.get(i);
            if (userObject instanceof UserModel) {
                um = (UserModel)userObject;
                if (!um.isClosed()) {
                    userMap.add(um.getUID());
                }
            } else if (userObject instanceof UserMapModel) {
                um = (UserMapModel)userObject;
                userMap.add(PerformerUtil.getModelStr((UserMapModel)um));
            } else if (userObject instanceof VUserModel) {
                um = (VUserModel)userObject;
                userMap.add(PerformerUtil.getModelStr((VUserModel)um));
            }
            ++i;
        }
    }

    public static List<Object> getUserManager(String departId, String uid, String processInstId, boolean isSupportMap) {
        return PerformerUtil.getUserManager(departId, uid, processInstId, isSupportMap, 0);
    }

    public static List<Object> getUserManager(String departId, String uid, String processInstId, boolean isSupportMap, int vande) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (!UtilString.isEmpty(uid)) {
            UserModel user = SDK.getORGAPI().getUser(uid);
            if (user == null) {
                return list;
            }
            if (!UtilString.isEmpty(user.getReportTo()) && user.getDepartmentId().equals(departId)) {
                UserModel reportTo = SDK.getORGAPI().getUser(user.getReportTo());
                if (reportTo != null) {
                    list.add(reportTo);
                }
                if (!list.isEmpty()) {
                    return list;
                }
            }
        }
        if (vande == 0 || vande == 2) {
            for (UserModel model : UserCache.getCache()) {
                if (!model.getDepartmentId().equals(departId) || !model.isManager() || model.isClosed()) continue;
                list.add(model);
            }
            if (isSupportMap) {
                List userMapModels = UserMapCache.getMapListOfDepartment((String)departId);
                int i = 0;
                while (i < userMapModels.size()) {
                    UserModel userModel;
                    UserMapModel mapModel = (UserMapModel)userMapModels.get(new Integer(i));
                    if (mapModel.isManager() && (userModel = UserCache.getModel((String)mapModel.getUID())) != null && !userModel.isClosed()) {
                        list.add(mapModel);
                        if (!UtilString.isEmpty(processInstId)) {
                            ProcessRuntimeDaoFactory.createTaskInstance();
                            TaskInstanceExec.setRouteORGMapping((String)userModel.getUID(), (String)processInstId, (String)"", (String)mapModel.getDepartmentId(), (String)mapModel.getRoleId());
                        }
                    }
                    ++i;
                }
            }
        }
        if (vande == 1 || vande == 2) {
            for (VUserModel model : VUserCache.getCache()) {
                if (!model.getDeptId().equals(departId) || !model.isManager()) continue;
                UserCache.getCache();
                UserModel um = UserCache.getModel((String)model.getUID());
                if (um == null || um.isClosed()) continue;
                list.add(model);
            }
        }
        return list;
    }
}

