/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal;

import com.actionsoft.apps.lma.LMAWeb;
import com.actionsoft.bpms.commons.addons.AddOnsWeb;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.cluster.loadbalancer.listener.NodeListener;
import com.actionsoft.bpms.commons.functionaccess.FunctionHistoryWeb;
import com.actionsoft.bpms.commons.log.sla.web.SLAWeb;
import com.actionsoft.bpms.commons.login.BPMClientPortalController;
import com.actionsoft.bpms.commons.login.ConsolePortalSkins;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.patch.web.VersionWeb;
import com.actionsoft.bpms.commons.portal.console.dashboard.web.ConsoleDashboardWeb;
import com.actionsoft.bpms.commons.session.SessionImpl;
import com.actionsoft.bpms.commons.session.model.SessionModel;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.fs.web.CloudFileWeb;
import com.actionsoft.coe.portal.web.NavigationWeb;
import com.actionsoft.exception.AWSQuotaException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.PortalAPI;
import java.util.HashMap;
import java.util.Map;

@Controller
public class SystemController {
    @Mapping(value="CLIENT_USER_BPMCLIENT_SID")
    public String getClientSessionId(UserContext me, String type) {
        ResponseObject response = ResponseObject.newOkResponse();
        SessionModel sessionModel = null;
        String uid = me.getUID();
        if (1 == me.validateSession()) {
            if ("COE".equalsIgnoreCase(type) || "PAL".equalsIgnoreCase(type)) {
                SessionImpl mySession = new SessionImpl();
                sessionModel = mySession.registerSession("C", uid, me.getClientIP(), me.getLanguage(), me.getDeviceType(), true, null);
            } else if (1 == me.validateSession()) {
                SessionImpl mySession = new SessionImpl();
                sessionModel = mySession.registerSession("P", uid, me.getClientIP(), me.getLanguage(), me.getDeviceType(), true, null);
            }
        }
        response.put("sid", sessionModel.getSessionId());
        return response.toString();
    }

    @Mapping(value="CLIENT_USER_LOGIN")
    public String loginClient(String userid, String pwd, String clientIp, String lang, String deviceType, RequestParams request) {
        HashMap params = new HashMap();
        Map webReq = request.asMap();
        for (String key : webReq.keySet()) {
            if (key.equalsIgnoreCase("userid") || key.equalsIgnoreCase("pwd") || key.equalsIgnoreCase("sid") || key.equalsIgnoreCase("lang") || key.equalsIgnoreCase("deviceType") || key.equalsIgnoreCase("cmd")) continue;
            params.put(key, webReq.get(key));
        }
        ResponseObject ro = BPMClientPortalController.getInstance().validateIdentity("P", userid, pwd, lang, clientIp, deviceType, false, params);
        if (!"cn".equals(lang)) {
            String msg = I18nRes.findValue("_bpm.platform", lang, ro.getMsg());
            ro.msg(msg);
        }
        return ro.toString();
    }

    @Mapping(value="CLIENT_USER_HOME")
    public String homeClient(UserContext me, RequestParams request) {
        return BPMClientPortalController.getInstance().getHomePage(me);
    }

    @Mapping(value="CONSOLE_ADMIN_LOGIN")
    public String loginCONSOLE(String userid, String pwd, String clientIp, String lang, RequestParams request) {
        HashMap params = new HashMap();
        Map webReq = request.asMap();
        for (String key : webReq.keySet()) {
            if (key.equalsIgnoreCase("userid") || key.equalsIgnoreCase("pwd") || key.equalsIgnoreCase("sid") || key.equalsIgnoreCase("lang") || key.equalsIgnoreCase("deviceType") || key.equalsIgnoreCase("cmd")) continue;
            params.put(key, webReq.get(key));
        }
        ConsolePortalSkins skins = new ConsolePortalSkins();
        ResponseObject ro = skins.validateIdentity(userid, pwd, lang, clientIp, params);
        if (ro.isOk() && AWSServerConf.isClusterService()) {
            String sid = (String)ro.get("sid");
            UserContext uc = UserContext.fromSessionId((String)sid);
            this.useClusterServer(uc, AWSServerConf.getInstanceName());
            ro.put("sid", uc.getSessionId());
        }
        return ro.toString();
    }

    @Mapping(value="CONSOLE_ADMIN_HOME")
    public String homeCONSOLE(UserContext me, RequestParams request) {
        ConsolePortalSkins skins = new ConsolePortalSkins();
        return skins.getHomePage(me);
    }

    @Mapping(value="CONSOLE_DASHBOARD_MAIN_PAGE")
    public String openDashboardPage(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.openDashboardPage();
    }

    @Mapping(value="CONSOLE_DASHBOARD_MAIN_INST_DATA")
    public ResponseObject getInstData(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.getInstData();
    }

    @Mapping(value="CONSOLE_DASHBOARD_MAIN_RECENT_OPERATION")
    public String getRecnetOperation(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.getRecentOperation();
    }

    @Mapping(value="CONSOLE_DASHBOARD_MAIN_DEVELOPER_NEWS")
    public String getDeveloperNews(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.getDeveloperNews();
    }

    @Mapping(value="CONSOLE_DASHBOARD_MAIN_GET_LEVEL_USER")
    public String getLevelUser(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.getLevelUser();
    }

    @Mapping(value="CONSOLE_DASHBOARD_ACTIVEUSERS")
    public String getActiveUsers(UserContext me) {
        ConsoleDashboardWeb web = new ConsoleDashboardWeb(me);
        return web.getActiveUsers();
    }

    @Mapping(value="CONSOLE_DASHBOARD_SLA")
    public String openSLADetail(UserContext me) {
        SLAWeb web = new SLAWeb();
        return web.getConsoleAlarm();
    }

    @Mapping(value="CONSOLE_DASHBOARD_SLA_DETAIL")
    public String openSLADetail(UserContext me, String id) {
        SLAWeb web = new SLAWeb();
        return web.openSLADetail(id);
    }

    @Mapping(value="CONSOLE_ADDONS_HOME_PAGE")
    public String openAddOnsHomeList(UserContext me) {
        AddOnsWeb web = new AddOnsWeb(me);
        return web.openAddOnsHomeList();
    }

    @Mapping(value="CONSOLE_ADDONS_OPEN")
    public String openAddonsMainPage(UserContext me, String id) {
        AddOnsWeb web = new AddOnsWeb(me);
        return web.openAddOnsMainPage(id);
    }

    @Mapping(value="CONSOLE_ADMIN_LOGOUT")
    public String logoutCONSOLE(UserContext me) {
        return new ConsolePortalSkins().getLogoutPage(me);
    }

    @Mapping(value="CONSOLE_ADMIN_USE_CLUSTER_SERVER")
    public String useClusterServer(UserContext me, String instId) {
        ClusterAPI.sendClusterOp((String[])new String[]{"type", NodeListener.TYPE_SID_BINDING, "sid", me.getSessionId(), "instId", instId, "clientIp", me.getClientIP()});
        return new ConsolePortalSkins().useClusterServer(me, instId);
    }

    @Mapping(value="CONSOLE_FUNCTION_HISTORY")
    public String getFunctionHistoryHome(UserContext me, String category, String filter, int pageNow, int pageSize) {
        FunctionHistoryWeb web = new FunctionHistoryWeb(me);
        return web.getFuncionHistoryHome(category, filter, pageNow, pageSize);
    }

    @Mapping(value="CONSOLE_FUNCTION_HISTORY_PAGEHTML")
    public String FunctionRecord_Load_Div(UserContext me, String category, String filter, int pageNow, int pageSize) {
        FunctionHistoryWeb web = new FunctionHistoryWeb(me);
        return web.getHistoryPanelDIVHtml(category, filter, pageNow, pageSize);
    }

    @Mapping(value="SWITCHING_COE")
    public String switchingCoe(UserContext me) {
        if (Quota.getMaxCoEPALUser() == 0 && Quota.getMaxCoEBPAUser() == 0) {
            throw new AWSQuotaException("CoE\u670d\u52a1\u672a\u8ba2\u9605\uff0c\u8bbf\u95ee\u88ab\u62d2\u7edd");
        }
        NavigationWeb web = new NavigationWeb(me);
        return web.getNavHeader();
    }

    @Mapping(value="CLIENT_UPDATE_PASSWORD")
    public String updatePassword(UserContext me, RequestParams params, String oldPassword, String password) {
        PortalAPI portalApi = SDK.getPortalAPI();
        return portalApi.changePasswd(me, oldPassword, password);
    }

    @Mapping(value="CONSOLE_ADMIN_CHECK_PLATFORM_VERSION")
    public String checkPlatformVersion(UserContext me, Boolean isPreviewPatch) {
        ConsolePortalSkins partolweb = new ConsolePortalSkins();
        VersionWeb web = new VersionWeb(me);
        String versionStr = "{}";
        try {
            versionStr = partolweb.checkPlatformVersion(isPreviewPatch.booleanValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return web.getVersionListJson(me, versionStr);
    }

    @Mapping(value="CONSOLE_ADMIN_DOWNLOAD_PLATFORM_VERSION")
    public String downloadPlatformVersion(UserContext me, String versionid, String filesize, String url, String md5digest, String isdegrade, String releasetype) {
        VersionWeb web = new VersionWeb(me);
        return web.downloadVersion(me, versionid, filesize, url, md5digest, isdegrade, releasetype);
    }

    @Mapping(value="CONSOLE_ADMIN_CANCEL_DOWNLOAD_PLATFORM_VERSION")
    public String cancelDownloadPlatformVersion(UserContext me, String versionid) {
        VersionWeb web = new VersionWeb(me);
        return web.cancleDownload(me, versionid);
    }

    @Mapping(value="CONSOLE_ADMIN_CHANGE_UPGRADE_STATE")
    public String installUpgradeState(UserContext me, String op, String plandate, String state, String versionid) {
        VersionWeb web = new VersionWeb(me);
        return web.planingInstall(me, op, plandate, state, versionid);
    }

    @Mapping(value="CLIENT_FILE_CLOUDDC_PULL_HOME_PAGE")
    public String getCloudDCPullHomePage(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boDefId, String boName, String boItemName, String boId, String processInstId, String taskInstId) {
        CloudFileWeb fileWeb = new CloudFileWeb(me);
        return fileWeb.getCloudDCPullHomePage(me, appId, groupValue, fileValue, repositoryName, boDefId, boName, boItemName, boId, processInstId, taskInstId);
    }

    @Mapping(value="CLIENT_FILE_CLOUDDC_PULL_PAGE")
    public String getCloudDCPullPage(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boDefId, String boName, String boItemName, String boId, String processInstId, String taskInstId, String cloudId, String cloudAppId) {
        CloudFileWeb fileWeb = new CloudFileWeb(me);
        return fileWeb.getCloudDCPullPage(me, appId, groupValue, fileValue, repositoryName, boDefId, boName, boItemName, boId, processInstId, taskInstId, cloudId, cloudAppId);
    }

    @Mapping(value="CLIENT_FILE_CLOUDDC_SAVE_CLOULDDC_2_UIFILE")
    public String saveCloudDC2UIFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String boName, String boItemName, String boId, String processInstId, String taskInstId, String remark, boolean isCreate, String cloudId, String cloudAppId, String files, String boDefId) {
        CloudFileWeb fileWeb = new CloudFileWeb(me);
        return fileWeb.saveCloudDC2UIFile(me, appId, groupValue, fileValue, repositoryName, boName, boItemName, boId, processInstId, taskInstId, remark, isCreate, cloudId, cloudAppId, files, boDefId);
    }

    @Mapping(value="CLIENT_FILE_IFSUPPORT_CLOUDDC")
    public String ifSupportCloudDC(UserContext me) {
        CloudFileWeb fileWeb = new CloudFileWeb(me);
        return fileWeb.ifSupportCloudDC();
    }

    @Mapping(value="CONSOLE_ADMIN_LMA_DOWNLOAD")
    public String downloadLMA(UserContext me) {
        LMAWeb web = new LMAWeb();
        return web.downloadLMA(me);
    }
}

