/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.console.dashboard.job;

import com.actionsoft.bpms.commons.portal.console.dashboard.cache.DeveloperNewsCache;
import com.actionsoft.bpms.commons.portal.console.dashboard.job.RssInfoRead;
import com.actionsoft.bpms.commons.portal.console.dashboard.model.DeveloperModel;
import com.actionsoft.bpms.schedule.IJob;
import com.rometools.rome.feed.synd.SyndCategory;
import com.rometools.rome.feed.synd.SyndEntry;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeveloperNewsJob
implements IJob {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        URL url = null;
        try {
            url = new URL("https://blog.awspaas.com/rss/");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        List<?> entries = null;
        entries = RssInfoRead.parseXml(url);
        if (entries != null) {
            int end = 20;
            if (entries.size() < 20) {
                end = entries.size();
            }
            ArrayList<DeveloperModel> datas = new ArrayList<DeveloperModel>();
            int i = 0;
            while (i < end) {
                List categoryList;
                DeveloperModel model = new DeveloperModel();
                SyndEntry entry = (SyndEntry)entries.get(i);
                String link = entry.getLink();
                String title = entry.getTitle();
                Date publishedDate = entry.getPublishedDate();
                String guid = entry.getUri();
                String author = entry.getAuthor();
                if (StringUtil.isEmpty((CharSequence)author) && (categoryList = entry.getCategories()) != null) {
                    int m = 0;
                    while (m < categoryList.size()) {
                        SyndCategory category = (SyndCategory)categoryList.get(m);
                        author = category.getName();
                        ++m;
                    }
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String publishedDateStr = "";
                if (publishedDate != null) {
                    publishedDateStr = formatter.format(publishedDate);
                }
                model.setGuid(guid);
                model.setTitle(title);
                model.setPubDate(publishedDateStr);
                model.setLink(link);
                datas.add(model);
                ++i;
            }
            DeveloperNewsCache.getCache();
            DeveloperNewsCache.addModel(datas);
        }
    }
}

