/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.console.dashboard.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppDependencyHelper;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.cc.cache.CCCache;
import com.actionsoft.bpms.cc.model.CCModel;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.cluster.loadbalancer.ClusterAPI;
import com.actionsoft.bpms.commons.database.DBPoolsManager;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.dictionary.util.XmlUtil;
import com.actionsoft.bpms.commons.htmlframework.AlertWindow;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.log.sla.sys.OSNow;
import com.actionsoft.bpms.commons.log.sla.sys.OSPerformance;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.pagination.SQLPagination;
import com.actionsoft.bpms.commons.portal.console.dashboard.cache.DeveloperNewsCache;
import com.actionsoft.bpms.commons.portal.console.dashboard.model.DeveloperModel;
import com.actionsoft.bpms.commons.portal.console.dashboard.web.DashBoardModel;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionAssnCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionListCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionAssnModel;
import com.actionsoft.bpms.commons.session.model.OnlineUserModel;
import com.actionsoft.bpms.dw.design.cache.DWCache;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.TeamCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.cache.UserMapCache;
import com.actionsoft.bpms.org.model.UserMapModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.server.monitor.ThreadMonit;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilNumber;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.emm.mdm.DeviceManager;
import com.actionsoft.exception.AWSDataAccessException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;

public class ConsoleDashboardWeb
extends ActionWeb {
    public ConsoleDashboardWeb(UserContext uc) {
        super(uc);
    }

    public ResponseObject getInstData() {
        ResponseObject r = ResponseObject.newOkResponse();
        Long activeProcess = SDK.getProcessQueryAPI().unfinished().count();
        Long finishedProcess = SDK.getProcessQueryAPI().finished().count();
        Long totalProcess = activeProcess + finishedProcess;
        r.put("totalProcess", totalProcess);
        r.put("activeProcess", activeProcess);
        r.put("finishedProcess", finishedProcess);
        Long activeTask = SDK.getTaskQueryAPI().count();
        Long finishedTask = SDK.getHistoryTaskQueryAPI().count();
        Long totalTask = activeTask + finishedTask;
        r.put("totalTask", totalTask);
        r.put("activeTask", activeTask);
        r.put("finishedTask", finishedTask);
        return r;
    }

    public String openDashboardPage() {
        HashMap<String, Object> macroLibraries;
        block14: {
            List webs;
            if (!PermAPIManager.getInstance().havingModelPermission(this.getContext().getUID(), "obj_ce318c5a66d546afbe22db8fa0c2f4eb")) {
                return AlertWindow.getAuthorityMessagePage(I18nRes.findValue("_bpm.platform", "\u5185\u5bb9\u6682\u65f6\u65e0\u6cd5\u8bbf\u95ee"), I18nRes.findValue("_bpm.platform", "\u6743\u9650\u4e0d\u591f"));
            }
            macroLibraries = new HashMap<String, Object>();
            String AWSName = AWSServerConf.getInstanceName();
            if (ClusterAPI.isCluster() && !UtilString.isEmpty(webs = ClusterAPI.getWEBS())) {
                AWSName = String.valueOf(AWSName) + "(" + UtilString.join(webs, ",") + ")";
            }
            macroLibraries.put("AWSName", AWSName);
            Map queryAppListState = AppDependencyHelper.queryAppListState((String)this.getContext().getUID());
            int activeAppSize = ((List)queryAppListState.get("ACTIVE")).size();
            int suspendAppSize = ((List)queryAppListState.get("STOPPED")).size();
            int offLineAppsSize = ((List)queryAppListState.get("OFFLINE")).size();
            int totalApps = activeAppSize + suspendAppSize + offLineAppsSize;
            macroLibraries.put("totalApps", totalApps);
            macroLibraries.put("activeAppSize", activeAppSize);
            macroLibraries.put("suspendAppSize", suspendAppSize);
            macroLibraries.put("offLineAppsSize", offLineAppsSize);
            int activePool = DBPoolsManager.getInstance().getActiveSize();
            int idlePool = DBPoolsManager.getInstance().getIdleSize();
            int totalPool = activePool + idlePool;
            macroLibraries.put("totalPool", totalPool);
            macroLibraries.put("activePool", activePool);
            macroLibraries.put("idlePool", idlePool);
            boolean isSigar = SDK.getAppAPI().getPropertyBooleanValue("_bpm.platform", "sigarService", true);
            if (isSigar) {
                Sigar sigar = null;
                try {
                    try {
                        sigar = new Sigar();
                        Mem mem = sigar.getMem();
                        double _1G = 1.073741824E9;
                        double totalMem = Double.valueOf(Long.toString(mem.getTotal())) / _1G;
                        double totalMemSize = UtilNumber.fixPoint(totalMem, 2);
                        long runtimeTotalMemory = Runtime.getRuntime().totalMemory();
                        double jvmUsedMem = Double.valueOf(Long.toString(runtimeTotalMemory)) / _1G;
                        double jvmUsedMemSize = UtilNumber.fixPoint(jvmUsedMem, 2);
                        double freeMem = Double.valueOf(Long.toString(mem.getActualFree())) / _1G;
                        double freeMemSize = UtilNumber.fixPoint(freeMem, 2);
                        double otherMem = Double.valueOf(Long.toString(mem.getActualUsed() - Runtime.getRuntime().totalMemory())) / _1G;
                        double otherMemSize = UtilNumber.fixPoint(otherMem, 2);
                        macroLibraries.put("totalMemSize", totalMemSize);
                        macroLibraries.put("usedMemSize", jvmUsedMemSize);
                        macroLibraries.put("freeMemSize", freeMemSize);
                        macroLibraries.put("otherMemSize", otherMemSize);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        macroLibraries.put("totalMemSize", 0);
                        macroLibraries.put("usedMemSize", 0);
                        macroLibraries.put("freeMemSize", 0);
                        macroLibraries.put("otherMemSize", 0);
                        if (sigar != null) {
                            sigar.close();
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    if (sigar != null) {
                        sigar.close();
                    }
                    throw throwable;
                }
                if (sigar != null) {
                    sigar.close();
                }
            } else {
                try {
                    OSPerformance per = OSNow.getPerformance().getOSPerformance();
                    double _1G = 1.073741824E9;
                    double totalMem = per.getOSTotalPhysicalMemory() / 1024.0;
                    double totalMemSize = UtilNumber.fixPoint(totalMem, 2);
                    long runtimeTotalMemory = Runtime.getRuntime().totalMemory();
                    double jvmUsedMem = Double.valueOf(Long.toString(runtimeTotalMemory)) / _1G;
                    double jvmUsedMemSize = UtilNumber.fixPoint(jvmUsedMem, 2);
                    double freeMem = (per.getOSTotalPhysicalMemory() - per.getOSPhysicalMemoryUsage()) / 1024.0;
                    double freeMemSize = UtilNumber.fixPoint(freeMem, 2);
                    double otherMem = per.getOSPhysicalMemoryUsage() / 1024.0 - (double)Runtime.getRuntime().totalMemory() / _1G;
                    double otherMemSize = UtilNumber.fixPoint(otherMem, 2);
                    macroLibraries.put("totalMemSize", totalMemSize);
                    macroLibraries.put("usedMemSize", jvmUsedMemSize);
                    macroLibraries.put("freeMemSize", freeMemSize);
                    macroLibraries.put("otherMemSize", otherMemSize);
                }
                catch (Exception e) {
                    System.err.println(e);
                    macroLibraries.put("totalMemSize", 0);
                    macroLibraries.put("usedMemSize", 0);
                    macroLibraries.put("freeMemSize", 0);
                    macroLibraries.put("otherMemSize", 0);
                }
            }
        }
        this.getResources(macroLibraries);
        this.getServices(macroLibraries);
        macroLibraries.put("sid", super.getSIDFlag());
        return HtmlPageTemplate.merge("_bpm.platform", "console.dashboard.main.htm", macroLibraries);
    }

    public String getActiveUsers() {
        int totalOnline;
        ResponseObject ro = ResponseObject.newOkResponse();
        List list = SDK.getPortalAPI().getOnlineUserList();
        int distinctOnline = totalOnline = list.size();
        int pcNum = 0;
        int tabletNum = 0;
        int mobileNum = 0;
        HashSet<String> uids = new HashSet<String>();
        for (OnlineUserModel online : list) {
            uids.add(online.getUid());
            if ("pc".equals(online.getDeviceType())) {
                ++pcNum;
                continue;
            }
            if ("tablet".equals(online.getDeviceType())) {
                ++tabletNum;
                continue;
            }
            if (!"mobile".equals(online.getDeviceType())) continue;
            ++mobileNum;
        }
        distinctOnline = uids.size();
        uids.clear();
        double pcDecimal = 0.0;
        double tabletDecimal = 0.0;
        double mobileDecimal = 0.0;
        if (pcNum == 0) {
            if (tabletNum == 0) {
                if (mobileNum != 0) {
                    mobileDecimal = 1.0;
                }
            } else {
                tabletDecimal = UtilNumber.div(tabletNum, totalOnline, 4);
                if (mobileNum == 0) {
                    if (tabletNum != 0) {
                        tabletDecimal = 1.0;
                    }
                } else {
                    mobileDecimal = UtilNumber.round(1.0 - tabletDecimal, 4);
                }
            }
        } else {
            pcDecimal = UtilNumber.div(pcNum, totalOnline, 4);
            if (tabletNum == 0) {
                if (mobileNum == 0) {
                    pcDecimal = 1.0;
                } else {
                    mobileDecimal = UtilNumber.round(1.0 - pcDecimal, 4);
                }
            } else if (mobileNum == 0) {
                tabletDecimal = UtilNumber.round(1.0 - pcDecimal, 4);
            } else {
                tabletDecimal = UtilNumber.div(tabletNum, totalOnline, 4);
                mobileDecimal = UtilNumber.round(1.0 - pcDecimal - tabletDecimal, 4);
            }
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        String pcPercent = pcDecimal == 0.0 ? "" : nf.format(pcDecimal);
        String tabletPercent = tabletDecimal == 0.0 ? "" : nf.format(tabletDecimal);
        String mobilePercent = mobileDecimal == 0.0 ? "" : nf.format(mobileDecimal);
        pcPercent = pcPercent.replace(".00", "");
        tabletPercent = tabletPercent.replace(".00", "");
        mobilePercent = mobilePercent.replace(".00", "");
        ro.put("totalOnline", distinctOnline);
        ro.put("pcNum", pcNum);
        ro.put("tabletNum", tabletNum);
        ro.put("mobileNum", mobileNum);
        ro.put("pcDecimal", pcDecimal);
        ro.put("tabletDecimal", tabletDecimal);
        ro.put("mobileDecimal", mobileDecimal);
        ro.put("pcPercent", pcPercent);
        ro.put("tabletPercent", tabletPercent);
        ro.put("mobilePercent", mobilePercent);
        ro.put("concurrent", ThreadMonit.size());
        return ro.toString();
    }

    private void getResources(Map<String, Object> macroLibraries) {
        int activeDefSize = ProcessDefCache.getInstance().getActiveDefs().size();
        macroLibraries.put("maxDefSize", Quota.getMaxprocess());
        macroLibraries.put("activeDefSize", activeDefSize);
        int formSize = FormCache.getInstance().size();
        macroLibraries.put("formSize", formSize);
        int dwSize = DWCache.getInstance().size();
        macroLibraries.put("dwSize", dwSize);
        int boSize = BOCache.getInstance().size();
        macroLibraries.put("boSize", boSize);
        int xmlDictionarySize = 0;
        int i18nSize = 0;
        List<Object> appContexts = new ArrayList();
        appContexts = AMCUtil.queryAllAppsList();
        for (AppContext appContext : appContexts) {
            i18nSize += I18nRes.getResourceMapByApp(appContext.getId()).size();
            xmlDictionarySize += XmlUtil.getFileName((String)appContext.getId(), (boolean)true).size() + XmlUtil.getFileName((String)appContext.getId(), (boolean)false).size();
        }
        macroLibraries.put("xmlDictionarySize", xmlDictionarySize);
        macroLibraries.put("i18nSize", i18nSize);
        int n = NavigationSystemCache.getCache().size();
        macroLibraries.put("menuSize", n);
        int maxUser = -1;
        if (Quota.getMaxUser() > 0) {
            maxUser = Quota.getMaxUser();
        }
        int userSize = UserCache.getActiveList().size();
        macroLibraries.put("maxUser", maxUser);
        macroLibraries.put("userSize", userSize);
        int departmentSize = DepartmentCache.getCache().size();
        macroLibraries.put("departmentSize", departmentSize);
        int rolesSize = SDK.getORGAPI().getRoles().size();
        macroLibraries.put("rolesSize", rolesSize);
        int groupSize = TeamCache.getInstance().size();
        macroLibraries.put("groupSize", groupSize);
        int permissionSize = PermissionCache.getCache().size();
        macroLibraries.put("permissionSize", permissionSize);
        int mdSize = Quota.getMaxMobileDevice();
        int mobileSize = DeviceManager.getInstance().getDeviceCountByType(1);
        int tabletSize = DeviceManager.getInstance().getDeviceCountByType(2);
        macroLibraries.put("mdSize", mdSize);
        macroLibraries.put("mobileSize", mobileSize);
        macroLibraries.put("tabletSize", tabletSize);
        if (Quota.isBYODService()) {
            macroLibraries.put("BYODService", "");
            macroLibraries.put("resourceSlaHeight1", "300px");
            macroLibraries.put("resourceSlaHeight2", "324px");
            macroLibraries.put("resourceSlaHeight3", "284px");
        } else {
            macroLibraries.put("BYODService", "none");
            macroLibraries.put("resourceSlaHeight1", "235px");
            macroLibraries.put("resourceSlaHeight2", "260px");
            macroLibraries.put("resourceSlaHeight3", "210px");
        }
    }

    private void getServices(Map<String, Object> macroLibraries) {
        Collection list = CCCache.getInstance().getList().values();
        int techCount = 0;
        int appCount = 0;
        int pollCount = 0;
        int serviceChoreCount = 0;
        int serviceSendCount = 0;
        int timeScheduleCount = AWSScheduleCache.getInstance().size();
        for (Map map : list) {
            Collection ccList = map.values();
            for (CCModel model : ccList) {
                if (model.getType().equals("jdbc")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("ws")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("http")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("vfs")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("jms")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("ftp")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("nativecall")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("login")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("ldap")) {
                    ++techCount;
                    continue;
                }
                if (model.getType().equals("sap")) {
                    ++appCount;
                    continue;
                }
                if (model.getType().equals("jde")) {
                    ++appCount;
                    continue;
                }
                if (model.getType().equals("dbpoll")) {
                    ++pollCount;
                    continue;
                }
                if (model.getType().equals("filepoll")) {
                    ++pollCount;
                    continue;
                }
                if (model.getType().equals("servicetask")) {
                    ++serviceChoreCount;
                    continue;
                }
                if (model.getType().equals("wspolicy")) {
                    ++serviceSendCount;
                    continue;
                }
                if (!model.getType().equals("wsprovider")) continue;
                ++serviceSendCount;
            }
        }
        macroLibraries.put("techCount", techCount);
        macroLibraries.put("appCount", appCount);
        macroLibraries.put("pollCount", pollCount);
        macroLibraries.put("serviceChoreCount", serviceChoreCount);
        macroLibraries.put("serviceSendCount", serviceSendCount);
        macroLibraries.put("timeScheduleCount", timeScheduleCount);
    }

    private Set<String> getUids() {
        Map<String, String> list = PermissionListCache.getPermissionsByResourceId("obj_ed721d4f4b5e468caa6fb5e0438c9918");
        List<PermissionAssnModel> t = PermissionAssnCache.getListByPermission(list.keySet());
        HashSet<String> users = new HashSet<String>();
        for (PermissionAssnModel p : t) {
            if ("user".equals(p.getAssignmentType())) {
                users.add(p.getAssignmentId());
                continue;
            }
            if (!"role".equals(p.getAssignmentType())) continue;
            String roleId = p.getAssignmentId();
            List us = UserCache.getUserListOfRole((String)roleId);
            for (UserModel u : us) {
                users.add(u.getUID());
            }
            List ums = UserMapCache.getMapListOfRole((String)roleId);
            for (UserMapModel um : ums) {
                users.add(um.getUID());
            }
        }
        return users;
    }

    public String getLevelUser() {
        JSONArray consoleArray = new JSONArray();
        ResponseObject ro = ResponseObject.newOkResponse();
        for (String uid : this.getUids()) {
            UserModel um;
            List teams = AppPlatformConfig.getAppTeamsByMember((String)uid);
            if (teams.size() == 0) continue;
            boolean isAllValid = true;
            for (AppTeam appTeam : teams) {
                if (appTeam.isValid()) continue;
                isAllValid = false;
                break;
            }
            if (!isAllValid || (um = UserCache.getModel((String)uid)) == null || um.isClosed()) continue;
            JSONObject object = new JSONObject();
            String name = um.getUserName();
            String url = "../commons/img/photo.png";
            object.put("name", (Object)name);
            object.put("uid", (Object)um.getUID());
            object.put("url", (Object)url);
            consoleArray.add((Object)object);
        }
        ro.put("consoleJson", consoleArray);
        List list = AppPlatformConfig.getTeams();
        JSONArray groupArray = new JSONArray();
        for (AppTeam appTeam : list) {
            JSONObject object = new JSONObject();
            String name = appTeam.getName();
            int count = appTeam.getMembers().size();
            object.put("name", (Object)name);
            object.put("count", (Object)count);
            groupArray.add((Object)object);
        }
        ro.put("groupJson", groupArray);
        return ro.toString();
    }

    public String getRecentOperation() {
        List<DashBoardModel> list;
        ResponseObject ro;
        block6: {
            ro = ResponseObject.newOkResponse();
            list = null;
            Connection conn = null;
            try {
                try {
                    conn = DBSql.open();
                    String patchsql = "SELECT * FROM SYS_PATCH ORDER BY OPDATE DESC";
                    patchsql = SQLPagination.getPaginitionSQL(patchsql, 0, 5);
                    List<DashBoardModel> plist = DBSql.query(conn, patchsql, new RowMapper<DashBoardModel>(){

                        public DashBoardModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                            DashBoardModel mybean = new DashBoardModel();
                            String opp = rs.getString("OPSTATE");
                            String versionid = rs.getString("VERSIONID");
                            int releasetype = rs.getInt("RELEASETYPE");
                            String text = "";
                            if (Quota.isPaasCloud()) {
                                if (1 == releasetype) {
                                    text = "[" + I18nRes.findValue("_bpm.platform", "\u6b63\u5f0f\u7248") + "]";
                                } else if (2 == releasetype) {
                                    text = "[" + I18nRes.findValue("_bpm.platform", "\u9884\u89c8\u7248") + "]";
                                }
                            }
                            String operate = "";
                            if (!UtilString.isEmpty(opp)) {
                                if (opp.equals("downloading")) {
                                    mybean.setOperate(operate);
                                    operate = I18nRes.findValue("_bpm.platform", "AWS_MAIN_\u4e0b\u8f7d\u4e2d");
                                } else if (opp.equals("downloaded")) {
                                    operate = I18nRes.findValue("_bpm.platform", "AWS_MAIN_\u4e0b\u8f7d\u5b8c\u6210");
                                } else if (opp.equals("downloaded")) {
                                    operate = I18nRes.findValue("_bpm.platform", "AWS_MAIN_\u8ba1\u5212\u5b89\u88c5");
                                } else if (opp.equals("upgrading")) {
                                    operate = I18nRes.findValue("_bpm.platform", "AWS_MAIN_\u5347\u7ea7\u4e2d");
                                } else if (opp.equals("upgraded")) {
                                    operate = I18nRes.findValue("_bpm.platform", "\u5347\u7ea7");
                                } else if (opp.equals("degraded")) {
                                    operate = I18nRes.findValue("_bpm.platform", "\u964d\u7ea7");
                                }
                            }
                            String datetime = UtilDate.datetimeFormat(rs.getTimestamp("OPDATE"));
                            mybean.setOperate(operate);
                            mybean.setAppName(String.valueOf(versionid) + text);
                            mybean.setId(rs.getString("ID"));
                            mybean.setOpeDate(String.valueOf(datetime) + "#" + UtilDate.getAliasDate(rs.getString("OPDATE")));
                            return mybean;
                        }
                    }, new Object[0]);
                    String databasesql = "SELECT * FROM SYS_PATCH_BOOTSTRAP ORDER BY BEGINTIME DESC";
                    databasesql = SQLPagination.getPaginitionSQL(databasesql, 0, 5);
                    List<DashBoardModel> dlist = DBSql.query(conn, databasesql, new RowMapper<DashBoardModel>(){

                        public DashBoardModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                            DashBoardModel mybean = new DashBoardModel();
                            mybean.setOperate(I18nRes.findValue("_bpm.platform", "\u8865\u4e01"));
                            mybean.setAppName(rs.getString("PATCHNAME").toUpperCase());
                            mybean.setId(rs.getString("ID"));
                            String datetime = UtilDate.datetimeFormat(rs.getTimestamp("BEGINTIME"));
                            mybean.setOpeDate(String.valueOf(datetime) + "#" + UtilDate.getAliasDate(rs.getString("BEGINTIME")));
                            return mybean;
                        }
                    }, new Object[0]);
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(2, -1);
                    String sql = "SELECT * FROM SYS_AUDIT_LOG where LOG_CATALOG='amc' AND OP_TIME>? ORDER BY OP_TIME DESC";
                    int limit = 10;
                    if (plist.size() < 10) {
                        limit = 20 - plist.size() - dlist.size();
                    }
                    sql = SQLPagination.getPaginitionSQL(sql, 0, limit);
                    list = DBSql.query(conn, sql, new RowMapper<DashBoardModel>(){

                        public DashBoardModel mapRow(ResultSet rs, int rowNum) throws SQLException {
                            int indx;
                            DashBoardModel mybean = new DashBoardModel();
                            String op = rs.getString("OP");
                            if ("upgrade".equals(op)) {
                                op = I18nRes.findValue("_bpm.platform", "\u5347\u7ea7");
                            } else if ("install".equals(op)) {
                                op = I18nRes.findValue("_bpm.platform", "\u5b89\u88c5");
                            } else if ("uninstall".equals(op)) {
                                op = I18nRes.findValue("_bpm.platform", "\u5378\u8f7d");
                            } else if ("delete".equals(op)) {
                                op = I18nRes.findValue("_bpm.platform", "\u5220\u9664");
                            } else if ("restore".equals(op)) {
                                op = I18nRes.findValue("_bpm.platform", "\u8fd8\u539f1");
                            }
                            mybean.setOperate(op);
                            String logObj = rs.getString("LOG_OBJECT");
                            if (UtilString.isEmpty(logObj)) {
                                logObj = "a/a";
                            }
                            if ((indx = logObj.indexOf("/")) > 0) {
                                mybean.setAppName(logObj.substring(indx + 1));
                                mybean.setAppId(logObj.substring(0, indx));
                            } else {
                                mybean.setAppId(logObj);
                                mybean.setAppName(rs.getString("OP_INFO"));
                            }
                            mybean.setId(rs.getString("ID"));
                            String datetime = UtilDate.datetimeFormat(rs.getTimestamp("OP_TIME"));
                            mybean.setOpeDate(String.valueOf(datetime) + "#" + UtilDate.getAliasDate(rs.getString("OP_TIME")));
                            return mybean;
                        }
                    }, new Timestamp(calendar.getTimeInMillis()));
                    list.addAll(plist);
                    list.addAll(dlist);
                    Collections.sort(list, new Comparator<DashBoardModel>(){

                        @Override
                        public int compare(DashBoardModel o1, DashBoardModel o2) {
                            String d1 = o1.getOpeDate();
                            String d2 = o2.getOpeDate();
                            String s1 = d1.substring(0, d1.indexOf("#"));
                            String s2 = d2.substring(0, d2.indexOf("#"));
                            return s2.compareTo(s1);
                        }
                    });
                }
                catch (AWSDataAccessException e) {
                    e.printStackTrace();
                    DBSql.close(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBSql.close(conn);
                throw throwable;
            }
            DBSql.close(conn);
        }
        ro.put("list", list);
        return ro.toString();
    }

    public String getDeveloperNews() {
        ArrayList<DeveloperModel> list = new ArrayList<DeveloperModel>();
        ResponseObject ro = ResponseObject.newOkResponse();
        DeveloperNewsCache.getCache();
        Iterator<DeveloperModel> it = DeveloperNewsCache.getListOfDeveloperNews();
        while (it.hasNext()) {
            DeveloperModel model = it.next();
            String date = model.getPubDate();
            String time2 = date.split(" ")[1];
            time2 = time2.substring(0, time2.lastIndexOf(":"));
            String time1 = UtilDate.getAliasDate(date);
            model.setPar2(time2);
            model.setPar1(time1);
            list.add(model);
        }
        Collections.sort(list, new Comparator<DeveloperModel>(){

            @Override
            public int compare(DeveloperModel o1, DeveloperModel o2) {
                Collator myCollator = Collator.getInstance(Locale.CHINA);
                int i = myCollator.compare(o2.getPubDate(), o1.getPubDate());
                return i;
            }
        });
        ro.put("list", list);
        return ro.toString();
    }
}

