/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation;

import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.web.DesignNavigationWeb;
import com.actionsoft.bpms.commons.portal.navigation.web.FunctionDeployWeb;
import com.actionsoft.bpms.server.RequestParams;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

@Controller
public class NavigationController {
    @Mapping(value="CONSOLE_COMMON_NAVIGATION_DESIGN_DEPLOY_OPEN")
    public String Navigation_Design_Deploy_Open(UserContext me, String url, String functionName) {
        FunctionDeployWeb web = new FunctionDeployWeb(me);
        NavigationFunctionModelImpl model = new NavigationFunctionModelImpl();
        model.setLinkUrl(url);
        try {
            model.setFunctionName(URLDecoder.decode(functionName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return web.getWeb(model);
    }

    @Mapping(value="CLIENT_COMMON_NAVIGATION_DESIGN_DEPLOY_OPEN")
    public String Navigation_Design_Deploy_Open_Client(UserContext me, String url, String functionName) {
        return this.Navigation_Design_Deploy_Open(me, url, functionName);
    }

    @Mapping(value="CLIENT_COMMON_NAVIGATION_DESIGN_DEPLOY_DIRECTORYOFSYS_HTML")
    public String Navigation_Design_Deploy_DirectoryOfSys(UserContext me, String systemId) {
        FunctionDeployWeb web = new FunctionDeployWeb(me);
        return web.getMenuBySystemId(systemId);
    }

    @Mapping(value="CLIENT_COMMON_NAVIGATION_DESIGN_DEPLOY_SAVE")
    public String Navigation_Design_Deploy_Save(UserContext me, RequestParams params) {
        FunctionDeployWeb web = new FunctionDeployWeb(me);
        NavigationFunctionModelImpl model = new NavigationFunctionModelImpl();
        String systemId = params.get("systemId");
        model.setDirectoryId(params.get("directoryId"));
        model.setId(params.get("functionId"));
        model.setLinkUrl(params.get("functionUrl"));
        model.setLinkTarget(params.get("workTarget"));
        model.setFunctionName(params.get("functionName"));
        model.setNavDesc(params.get("navDesc") == null ? "" : params.get("navDesc"));
        model.setIcon16(params.get("navIcon"));
        boolean isCreateSys = params.getBoolean("isCreateSys");
        boolean isCreateDir = params.getBoolean("isCreateDir");
        return web.deploy(model, isCreateSys, isCreateDir);
    }

    @Mapping(value="CONSOLE_P_NAV_MAIN_PAGE")
    public String getMainDesignConsole(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        return web.getMainDesignConsole();
    }

    @Mapping(value="CONSOLE_P_NAV_REQUEST_GRIDDATA")
    public String getGridData(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String tid = params.get("tid");
        return web.getGridData(tid);
    }

    @Mapping(value="CONSOLE_P_NAV_EXPORT_NAVS")
    public String exportNavs(UserContext me) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        return web.exportNavs();
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_SYSTEM_OPEN")
    public String getForm(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String systemId = params.get("systemId");
        if (systemId == null || systemId.equals("")) {
            systemId = "0";
        }
        return web.getForm(systemId, false, "0".equals(systemId));
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_DIRECTORY_OPEN")
    public String getDirectoryForm(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String systemId = params.get("systemId");
        String directoryId = params.get("directoryId");
        if (directoryId == null || directoryId.equals("")) {
            directoryId = "0";
        }
        return web.getForm(systemId, directoryId, false, "0".equals(directoryId));
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_FUNCTION_OPEN")
    public String getFunctionForm(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String systemId = params.get("systemId");
        String directoryId = params.get("directoryId");
        String functionId = params.get("functionId");
        if (functionId == null || functionId.equals("functionId")) {
            functionId = "0";
        }
        return web.getForm(systemId, directoryId, functionId, false, "0".equals(functionId));
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_FUNCTION_SAVE")
    public String saveNavigationFunction(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String id = params.get("functionId");
        NavigationFunctionModelImpl model = UtilString.isEmpty(id) ? new NavigationFunctionModelImpl() : (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(id);
        model.setDirectoryId(params.get("directoryId"));
        model.setId(params.get("functionId"));
        model.setLinkUrl(params.get("functionUrl"));
        model.setLinkTarget(params.get("workTarget"));
        model.setActivity("1".equals(params.get("isActivity")));
        model.setFunctionName(params.get("functionName"));
        model.setNavDesc(params.get("navDesc"));
        model.setIcon16(params.get("icon16"));
        model.setIcon64(params.get("icon64"));
        model.setIcon96(params.get("icon96"));
        String sidebarWidth = params.get("sidebarWidth");
        String ext2Str = model.getExt2();
        try {
            JSONObject ext2 = UtilString.isEmpty(ext2Str) ? new JSONObject() : JSONObject.parseObject((String)ext2Str);
            ext2.put("sidebarWidth", (Object)sidebarWidth);
            model.setExt2(ext2.toString());
        }
        catch (Exception ext2) {
            // empty catch block
        }
        String appId = params.get("appid");
        model.setAppId(appId == null ? "" : appId);
        model.setNotifier(params.get("notifier"));
        int orderIndex = Integer.valueOf(params.get("orderIndex"));
        int initOrderIndex = model.getOrderIndex();
        if (orderIndex != initOrderIndex) {
            NavigationFunctionModelImpl modelSql = (NavigationFunctionModelImpl)NavigationDaoFactory.createNavigationFunction().queryBy("ORDERINDEX=? AND DIRECTORYID=?", orderIndex, model.getDirectoryId());
            if (modelSql != null) {
                NavigationFunctionModelImpl modelCache = (NavigationFunctionModelImpl)NavigationFunctionCache.getModel(modelSql.getId());
                modelCache.setOrderIndex(initOrderIndex);
                web.saveNavigationFunction(modelCache);
            }
            model.setOrderIndex(orderIndex);
        }
        return web.saveNavigationFunction(model);
    }

    @Mapping(value="CLIENT_P_NAV_DESIGN_DIRECTORY_SAVE")
    public String _Navigation_Design_Directory_Save(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String id = params.get("directoryId");
        NavigationDirectoryModelImpl model = UtilString.isEmpty(id) ? new NavigationDirectoryModelImpl() : (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(id);
        model.setSystemId(params.get("systemId"));
        model.setId(params.get("directoryId"));
        model.setLinkTarget(params.get("directoryTarget"));
        model.setActivity("1".equals(params.get("isActivity")));
        model.setDirectoryName(params.get("directoryName"));
        model.setLinkUrl(params.get("directoryUrl"));
        model.setNavDesc(params.get("navDesc"));
        model.setIcon16(params.get("icon16"));
        model.setIcon64(params.get("icon64"));
        model.setIcon96(params.get("icon96"));
        String sidebarWidth = params.get("sidebarWidth");
        String ext2Str = model.getExt2();
        try {
            JSONObject ext2 = UtilString.isEmpty(ext2Str) ? new JSONObject() : JSONObject.parseObject((String)ext2Str);
            ext2.put("sidebarWidth", (Object)sidebarWidth);
            model.setExt2(ext2.toString());
        }
        catch (Exception ext2) {
            // empty catch block
        }
        model.setNotifier(params.get("notifier"));
        String appId = model.getAppId();
        model.setAppId(appId == null ? "" : appId);
        int orderIndex = Integer.valueOf(UtilString.isEmpty(params.get("orderIndex")) ? "0" : params.get("orderIndex"));
        int initOrderIndex = model.getOrderIndex();
        if (orderIndex != initOrderIndex) {
            NavigationDirectoryModelImpl modelSql = (NavigationDirectoryModelImpl)NavigationDaoFactory.createNavigationDirectory().queryBy("ORDERINDEX=? AND SYSTEMID=?", orderIndex, model.getSystemId());
            if (modelSql != null) {
                NavigationDirectoryModelImpl modelCache = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(modelSql.getId());
                modelCache.setOrderIndex(initOrderIndex);
                web.saveNavigationDirectory(modelCache);
            }
            model.setOrderIndex(orderIndex);
        }
        return web.saveNavigationDirectory(model);
    }

    @Mapping(value="CLIENT_P_NAV_DESIGN_SYSTEM_SAVE")
    public String saveNavigationSystem(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String id = params.get("id");
        NavigationSystemModelImpl model = UtilString.isEmpty(id) ? new NavigationSystemModelImpl() : (NavigationSystemModelImpl)NavigationSystemCache.getModel(id);
        model.setId(params.get("id"));
        model.setIcon16(params.get("icon16"));
        model.setIcon64(params.get("icon64"));
        model.setIcon96(params.get("icon96"));
        String linkUrl = params.get("linkUrl");
        model.setLinkUrl(linkUrl);
        model.setLinkTarget(params.get("workTarget"));
        model.setHidden("1".equals(params.get("isHidden")));
        model.setActivity("1".equals(params.get("isActivity")));
        String systemName = params.get("systemName");
        model.setSystemName(systemName);
        model.setNavDesc(params.get("navDesc"));
        String appId = params.get("appid");
        model.setAppId(appId == null ? "" : appId);
        model.setNotifier(params.get("notifier"));
        int orderIndex = Integer.valueOf(UtilString.isEmpty(params.get("orderIndex")) ? "0" : params.get("orderIndex"));
        int initOrderIndex = model.getOrderIndex();
        if (orderIndex != initOrderIndex) {
            NavigationSystemModelImpl modelSql = (NavigationSystemModelImpl)NavigationDaoFactory.createNavigationSystem().queryBy("ORDERINDEX=?", orderIndex);
            if (modelSql != null) {
                NavigationSystemModelImpl modelCache = (NavigationSystemModelImpl)NavigationSystemCache.getModel(modelSql.getId());
                modelCache.setOrderIndex(initOrderIndex);
                web.saveNavigationSystem(modelCache);
            }
            model.setOrderIndex(orderIndex);
        }
        return web.saveNavigationSystem(model);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_TREENODE_CHECKDD")
    public String navigationCheckDD(UserContext me, RequestParams params) {
        String sNode = params.get("sNode");
        String tNode = params.get("tNode");
        String point = params.get("point");
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        return web.navigationCheckDD(sNode, tNode, point);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_TREENODE_DD")
    public String navigationObjectDD(UserContext me, RequestParams params) {
        String sNode = params.get("sNode");
        String tNode = params.get("tNode");
        String point = params.get("point");
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        return web.navigationObjectDD(sNode, tNode, point);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_TREE_GETDATA")
    public String _Navigation_Design_Tree_GetData(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String tid = params.get("node");
        return web.getNavigationTreeNodes(tid);
    }

    @Mapping(value="CONSOLE_NAV_DESIGN_SEARCH_JSON")
    public String _getSearcherJson(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        int currentPage = params.getInt("currentPage");
        int limit = params.getInt("limit");
        String searchKey = params.get("query");
        return web.getSearcherJson(currentPage, limit, searchKey);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_DELETE")
    public String _Navigation_Design_Delete(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String deleteId = params.get("naviid");
        return web.deleteNavigationObject(deleteId);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_OPENGRAPH")
    public String _Navigation_Design_OpenGraph(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String nodeId = params.get("naviid");
        return web.openNavGraph(nodeId);
    }

    @Mapping(value="CONSOLE_P_NAV_DESIGN_TREENODE_SAVE_ORDERINDEX")
    public String navigationSaveOrderIndex(UserContext me, RequestParams params) {
        DesignNavigationWeb web = new DesignNavigationWeb(me);
        String navIndexArr = params.get("navIndexArr");
        return web.navigationSaveOrderIndex(navIndexArr);
    }
}

