/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavDirIndex;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.Comparator;
import java.util.List;

public class NavigationDirectoryCache
extends Cache<String, NavigationDirectoryModel> {
    private static Comparator<NavigationDirectoryModel> SORT_ORDERINDEX = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return 0;
        }
        return o1.getOrderIndex() - o2.getOrderIndex();
    };

    public NavigationDirectoryCache(CachePluginProfile configuration) {
        super(configuration);
        this.registeIndex(NavDirIndex.class, new NavDirIndex());
    }

    public static void putModel(NavigationDirectoryModel model) {
        NavigationDirectoryCache.getCache().put(model.getId(), model);
    }

    public static void updateModel(NavigationDirectoryModel model) {
        NavigationDirectoryCache.putModel(model);
    }

    public static void removeModel(String id) {
        NavigationDirectoryCache.getCache().remove(id);
    }

    public static NavigationDirectoryModel getModel(String id) {
        return (NavigationDirectoryModel)NavigationDirectoryCache.getCache().get(id);
    }

    public static List<NavigationDirectoryModel> getListOfSystem(String systemId) {
        return NavigationDirectoryCache.iteratorToList(NavigationDirectoryCache.getCache().getByIndex(NavDirIndex.class, systemId, SORT_ORDERINDEX));
    }

    public static NavigationDirectoryCache getCache() {
        return CacheManager.getCache(NavigationDirectoryCache.class);
    }

    @Override
    public void load() {
        String msg = "Cache\u52a0\u8f7d\u83dc\u5355\u76ee\u5f55\u5bfc\u822a\u5bf9\u8c61\u5b9e\u4f8b";
        List<NavigationDirectoryModelImpl> _list = NavigationDaoFactory.createNavigationDirectory().getModelList();
        if (_list != null) {
            for (NavigationDirectoryModel navigationDirectoryModel : _list) {
                NavigationDirectoryCache.getCache().put(navigationDirectoryModel.getId(), navigationDirectoryModel, false);
            }
        }
        msg = String.valueOf(msg) + " [" + _list.size() + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(msg);
    }
}

