/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavFunIndex;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class NavigationFunctionCache
extends Cache<String, NavigationFunctionModel> {
    private static Comparator<NavigationFunctionModel> SORT_ORDERINDEX = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return 0;
        }
        return o1.getOrderIndex() - o2.getOrderIndex();
    };

    public NavigationFunctionCache(CachePluginProfile configuration) {
        super(configuration);
        this.registeIndex(NavFunIndex.class, new NavFunIndex());
    }

    public static void putModel(NavigationFunctionModel model) {
        NavigationFunctionCache.getCache().put(model.getId(), model);
    }

    public static void updateModel(NavigationFunctionModel model) {
        NavigationFunctionCache.putModel(model);
    }

    public static void removeModel(String id) {
        NavigationFunctionCache.getCache().remove(id);
    }

    public static List<NavigationFunctionModel> getListOfDirectory(String directoryId) {
        return NavigationFunctionCache.iteratorToList(NavigationFunctionCache.getCache().getByIndex(NavFunIndex.class, directoryId, SORT_ORDERINDEX));
    }

    public static List<NavigationFunctionModel> getListOfAppId(String appId) {
        ArrayList<NavigationFunctionModel> list = new ArrayList<NavigationFunctionModel>();
        Iterator<NavigationFunctionModel> it = NavigationFunctionCache.getCache().iteratorSorted(SORT_ORDERINDEX);
        while (it.hasNext()) {
            NavigationFunctionModel model = it.next();
            if (!model.getAppId().equals(appId)) continue;
            list.add(model);
        }
        return list;
    }

    public static NavigationFunctionModel getModel(String id) {
        return (NavigationFunctionModel)NavigationFunctionCache.getCache().get(id);
    }

    public static NavigationFunctionModel getModelByURL(String url) {
        return (NavigationFunctionModel)NavigationFunctionCache.getCache().get(NavigationFunctionCache.getNavigationId(url));
    }

    public static String getNavigationId(String url) {
        Iterator h = NavigationFunctionCache.getCache().iterator();
        while (h.hasNext()) {
            NavigationFunctionModel nf = (NavigationFunctionModel)h.next();
            if (!nf.getLinkUrl().equals(url)) continue;
            return nf.getId();
        }
        return "";
    }

    @Override
    public void load() {
        String msg = "Cache\u52a0\u8f7d\u529f\u80fd\u6a21\u5757\u5bfc\u822a\u5bf9\u8c61\u5b9e\u4f8b";
        List<NavigationFunctionModel> _list = NavigationDaoFactory.createNavigationFunction().getModelList();
        if (_list != null) {
            for (NavigationFunctionModel model : _list) {
                NavigationFunctionCache.getCache().put(model.getId(), model, false);
            }
        }
        msg = String.valueOf(msg) + " [" + _list.size() + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(msg);
    }

    public static NavigationFunctionCache getCache() {
        return CacheManager.getCache(NavigationFunctionCache.class);
    }
}

