/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.cache;

import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.util.Comparator;
import java.util.List;

public class NavigationSystemCache
extends Cache<String, NavigationSystemModel> {
    public static Comparator<NavigationSystemModel> SORT_ORDERINDEX = (o1, o2) -> {
        if (o1 == null || o2 == null) {
            return 0;
        }
        return o1.getOrderIndex() - o2.getOrderIndex();
    };

    public NavigationSystemCache(CachePluginProfile configuration) {
        super(configuration);
    }

    public static void putModel(NavigationSystemModel model) {
        NavigationSystemCache.getCache().put(model.getId(), model);
    }

    public static void updateModel(NavigationSystemModel model) {
        NavigationSystemCache.putModel(model);
    }

    public static void removeModel(String id) {
        NavigationSystemCache.getCache().remove(id);
    }

    public static NavigationSystemModel getModel(String id) {
        return (NavigationSystemModel)NavigationSystemCache.getCache().get(id);
    }

    @Override
    public void load() {
        String msg = "Cache\u52a0\u8f7d\u7cfb\u7edf\u5b50\u7cfb\u7edf\u5bfc\u822a\u5bf9\u8c61\u5b9e\u4f8b";
        List<NavigationSystemModelImpl> list = NavigationDaoFactory.createNavigationSystem().getModelList();
        if (list != null) {
            for (NavigationSystemModel navigationSystemModel : list) {
                NavigationSystemCache.getCache().put(navigationSystemModel.getId(), navigationSystemModel, false);
            }
        }
        msg = String.valueOf(msg) + " [" + list.size() + "\u4e2a][\u6210\u529f]";
        ConsolePrinter.info(msg);
    }

    public static NavigationSystemCache getCache() {
        return CacheManager.getCache(NavigationSystemCache.class);
    }
}

