/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.dao;

import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDirectoryModelMapper;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class NavigationDirectory
extends DaoObject<NavigationDirectoryModelImpl> {
    @Override
    public int insert(NavigationDirectoryModelImpl model) {
        if (model.getId() == null || "".equals(model.getId())) {
            model.setId(UUIDGener.getObjectId());
        }
        if (model.getOrderIndex() == 0) {
            model.setOrderIndex(this.getMaxIndex(model.getSystemId()));
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("SYSTEMID", model.getSystemId());
        paramsMap.put("DIRECTORYNAME", model.getDirectoryName());
        paramsMap.put("ORDERINDEX", model.getOrderIndex());
        paramsMap.put("LINKURL", model.getLinkUrl());
        paramsMap.put("LINKTARGET", model.getLinkTarget());
        paramsMap.put("ICON16", model.getIcon16());
        paramsMap.put("ICON64", model.getIcon64());
        paramsMap.put("ICON96", model.getIcon96());
        paramsMap.put("NAVDESC", model.getNavDesc());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("ISACTIVITY", model.isActivity() ? 1 : 0);
        paramsMap.put("EXT1", model.getExt1());
        paramsMap.put("EXT2", model.getExt2());
        paramsMap.put("NOTIFIER", model.getNotifier());
        paramsMap.put("CREATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        int r = DBSql.update(DBSql.getInsertStatement(this.entityName(), paramsMap), paramsMap);
        NavigationDirectoryCache.putModel(model);
        return r;
    }

    @Override
    public int update(NavigationDirectoryModelImpl model) {
        int r;
        NavigationDirectoryModel oldModel = NavigationDirectoryCache.getModel(model.getId());
        if (!model.getSystemId().equals(oldModel.getSystemId())) {
            model.setOrderIndex(this.getMaxIndex(model.getSystemId()));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.entityName()).append(" SET ");
        sql.append("SYSTEMID").append("=:").append("SYSTEMID").append(",");
        sql.append("DIRECTORYNAME").append("=:").append("DIRECTORYNAME").append(",");
        sql.append("ORDERINDEX").append("=:").append("ORDERINDEX").append(",");
        sql.append("LINKURL").append("=:").append("LINKURL").append(",");
        sql.append("LINKTARGET").append("=:").append("LINKTARGET").append(",");
        sql.append("ICON16").append("=:").append("ICON16").append(",");
        sql.append("ICON64").append("=:").append("ICON64").append(",");
        sql.append("ICON96").append("=:").append("ICON96").append(",");
        sql.append("NAVDESC").append("=:").append("NAVDESC").append(",");
        sql.append("APPID").append("=:").append("APPID").append(",");
        sql.append("ISACTIVITY").append("=:").append("ISACTIVITY").append(",");
        sql.append("EXT1").append("=:").append("EXT1").append(",");
        sql.append("EXT2").append("=:").append("EXT2").append(",");
        sql.append("UPDATEDATE").append("=:").append("UPDATEDATE").append(",");
        sql.append("NOTIFIER").append("=:").append("NOTIFIER");
        sql.append(" WHERE ");
        sql.append("ID").append("=:").append("ID");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("SYSTEMID", model.getSystemId());
        paramsMap.put("DIRECTORYNAME", model.getDirectoryName());
        paramsMap.put("ORDERINDEX", model.getOrderIndex());
        paramsMap.put("LINKURL", model.getLinkUrl());
        paramsMap.put("LINKTARGET", model.getLinkTarget());
        paramsMap.put("ICON16", model.getIcon16());
        paramsMap.put("ICON64", model.getIcon64());
        paramsMap.put("ICON96", model.getIcon96());
        paramsMap.put("NAVDESC", model.getNavDesc());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("ISACTIVITY", model.isActivity() ? 1 : 0);
        paramsMap.put("EXT1", model.getExt1());
        paramsMap.put("EXT2", model.getExt2());
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("NOTIFIER", model.getNotifier());
        try {
            r = DBSql.update(sql.toString(), paramsMap);
        }
        finally {
            NavigationDirectoryCache.updateModel(this.getModel(model.getId()));
        }
        return r;
    }

    @Override
    public int delete(Object oid) {
        String id = (String)oid;
        int r = super.delete(id);
        NavigationDirectoryCache.removeModel(id);
        PermissionDaoFactory.createPermissionList().removeByResource(id);
        NavigationDaoFactory.createNavigationFunction().removeByDirectory(id);
        return r;
    }

    public void removeBySystem(String systemId) {
        List<NavigationDirectoryModel> h = NavigationDirectoryCache.getListOfSystem(systemId);
        for (NavigationDirectoryModel model : h) {
            this.delete(model.getId());
        }
    }

    public NavigationDirectoryModel getModel(String id) {
        return (NavigationDirectoryModel)this.queryById(id);
    }

    public List<NavigationDirectoryModelImpl> getModelList() {
        return this.query().list();
    }

    private int getMaxIndex(String systemId) {
        Stream stream = NavigationDirectoryCache.getCache().stream();
        Optional<Integer> maxOrderIndex = stream.filter(model -> systemId.equals(model.getSystemId())).map(NavigationDirectoryModel::getOrderIndex).max(Integer::compareTo);
        return maxOrderIndex.map(i -> i + 1).orElse(1);
    }

    @Override
    public String entityName() {
        return "SYS_NAV_DIRECTORY";
    }

    @Override
    public RowMapper<NavigationDirectoryModelImpl> rowMapper() {
        return new NavigationDirectoryModelMapper();
    }
}

