/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.portal.navigation.dao;

import com.actionsoft.bpms.cc.TongESB;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationFunctionModelMapper;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.logging.model.Level;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.sdk.local.SDK;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NavigationFunction
extends DaoObject<NavigationFunctionModelImpl> {
    @Override
    public int insert(NavigationFunctionModelImpl obj) {
        if (obj.getId() == null || "".equals(obj.getId())) {
            obj.setId(UUIDGener.getObjectId());
        }
        if (obj.getOrderIndex() == 0) {
            obj.setOrderIndex(this.getMaxIndex(obj.getDirectoryId()));
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", obj.getId());
        paramsMap.put("DIRECTORYID", obj.getDirectoryId());
        paramsMap.put("FUNCTIONNAME", obj.getFunctionName());
        paramsMap.put("ORDERINDEX", obj.getOrderIndex());
        paramsMap.put("LINKURL", obj.getLinkUrl());
        paramsMap.put("LINKTARGET", obj.getLinkTarget());
        paramsMap.put("ICON16", obj.getIcon16());
        paramsMap.put("ICON64", obj.getIcon64());
        paramsMap.put("ICON96", obj.getIcon96());
        paramsMap.put("NAVDESC", obj.getNavDesc());
        paramsMap.put("APPID", obj.getAppId());
        paramsMap.put("ISACTIVITY", obj.isActivity() ? 1 : 0);
        paramsMap.put("EXT1", obj.getExt1());
        paramsMap.put("EXT2", obj.getExt2());
        paramsMap.put("NOTIFIER", obj.getNotifier());
        paramsMap.put("CREATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        int r = DBSql.update(DBSql.getInsertStatement(this.entityName(), paramsMap), paramsMap);
        NavigationFunctionCache.putModel(obj);
        return r;
    }

    @Override
    public int update(NavigationFunctionModelImpl model) {
        int r;
        NavigationFunctionModel oldModel = NavigationFunctionCache.getModel(model.getId());
        if (!model.getDirectoryId().equals(oldModel.getDirectoryId())) {
            model.setOrderIndex(this.getMaxIndex(model.getDirectoryId()));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.entityName()).append(" SET ");
        sql.append("DIRECTORYID").append("=:").append("DIRECTORYID").append(",");
        sql.append("FUNCTIONNAME").append("=:").append("FUNCTIONNAME").append(",");
        sql.append("ORDERINDEX").append("=:").append("ORDERINDEX").append(",");
        sql.append("LINKURL").append("=:").append("LINKURL").append(",");
        sql.append("LINKTARGET").append("=:").append("LINKTARGET").append(",");
        sql.append("ICON16").append("=:").append("ICON16").append(",");
        sql.append("ICON64").append("=:").append("ICON64").append(",");
        sql.append("ICON96").append("=:").append("ICON96").append(",");
        sql.append("NAVDESC").append("=:").append("NAVDESC").append(",");
        sql.append("APPID").append("=:").append("APPID").append(",");
        sql.append("ISACTIVITY").append("=:").append("ISACTIVITY").append(",");
        sql.append("EXT1").append("=:").append("EXT1").append(",");
        sql.append("EXT2").append("=:").append("EXT2").append(",");
        sql.append("UPDATEDATE").append("=:").append("UPDATEDATE").append(",");
        sql.append("NOTIFIER").append("=:").append("NOTIFIER");
        sql.append(" WHERE ");
        sql.append("ID").append("=:").append("ID");
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("DIRECTORYID", model.getDirectoryId());
        paramsMap.put("FUNCTIONNAME", model.getFunctionName());
        paramsMap.put("ORDERINDEX", model.getOrderIndex());
        paramsMap.put("LINKURL", model.getLinkUrl());
        paramsMap.put("LINKTARGET", model.getLinkTarget());
        paramsMap.put("ICON16", model.getIcon16());
        paramsMap.put("ICON64", model.getIcon64());
        paramsMap.put("ICON96", model.getIcon96());
        paramsMap.put("NAVDESC", model.getNavDesc());
        paramsMap.put("APPID", model.getAppId());
        paramsMap.put("ISACTIVITY", model.isActivity() ? 1 : 0);
        paramsMap.put("EXT1", model.getExt1());
        paramsMap.put("EXT2", model.getExt2());
        paramsMap.put("UPDATEDATE", new Timestamp(System.currentTimeMillis()));
        paramsMap.put("NOTIFIER", model.getNotifier());
        try {
            r = DBSql.update(sql.toString(), paramsMap);
        }
        finally {
            NavigationFunctionCache.updateModel(this.getModel(model.getId()));
        }
        return r;
    }

    @Override
    public int delete(Object oid) {
        String id = (String)oid;
        int r = super.delete(id);
        NavigationFunctionCache.removeModel(id);
        PermissionDaoFactory.createPermissionList().removeByResource(id);
        return r;
    }

    public void removeByDirectory(String directoryId) {
        List<NavigationFunctionModel> h = NavigationFunctionCache.getListOfDirectory(directoryId);
        StringBuilder a = new StringBuilder();
        if (h != null) {
            for (NavigationFunctionModel nf : h) {
                a.append(nf.getId()).append(" ");
                this.delete(nf.getId());
            }
        }
        if (DispatcherRequest.getContext() != null && DispatcherRequest.getUserContext() != null) {
            SDK.getLogAPI().audit("SYSTEM", "nav", DispatcherRequest.getUserContext().getUID(), "delete", directoryId, "\u5ba2\u4f53\u4e3a\u76ee\u5f55ID\uff0c\u901a\u8fc7\u5bfc\u822a\u83dc\u5355\u7684\u76ee\u5f55\u5220\u9664\u4e86\u529f\u80fd\u83dc\u5355\uff1a" + a.toString(), DispatcherRequest.getContext().getIp(), Level.INFO);
        }
    }

    public void removeProcessDataWindow(String processGroupId) {
        String sql;
        int r;
        if (DispatcherRequest.getContext() != null && DispatcherRequest.getUserContext() != null) {
            SDK.getLogAPI().audit("SYSTEM", "nav", DispatcherRequest.getUserContext().getUID(), "delete", processGroupId, "\u5220\u9664\u4e86\u6d41\u7a0b\u7ec4\u5bf9\u5e94\u7684DW\u83dc\u5355", DispatcherRequest.getContext().getIp(), Level.INFO);
        }
        if ((r = DBSql.update(sql = "DELETE FROM SYS_NAV_FUNCTION where LINKURL like  '%CLIENT_DW_PORTAL%" + processGroupId + "%'")) > 0) {
            NavigationFunctionCache.getCache().reload();
        }
    }

    public NavigationFunctionModel getModel(String id) {
        return (NavigationFunctionModel)this.queryById(id);
    }

    public List<NavigationFunctionModel> getModelList() {
        List list = this.query().list();
        return list.stream().filter(model -> {
            if (!Quota.isCCService() && model.getLinkUrl().indexOf("cmd=CONSOLE_I_CC_CONNECTIONCENTER_MAIN") > 0) {
                return false;
            }
            return Quota.isXBusService() && !TongESB.isActive() || model.getLinkUrl().indexOf("cmd=CONSOLE_I_DI_MAIN_OPEN") <= 0;
        }).collect(Collectors.toList());
    }

    private int getMaxIndex(String directoryId) {
        Stream stream = NavigationFunctionCache.getCache().stream();
        Optional<Integer> maxOrderIndex = stream.filter(model -> directoryId.equals(model.getDirectoryId())).map(NavigationFunctionModel::getOrderIndex).max(Integer::compareTo);
        return maxOrderIndex.map(i -> i + 1).orElse(1);
    }

    @Override
    public String entityName() {
        return "SYS_NAV_FUNCTION";
    }

    @Override
    public RowMapper<NavigationFunctionModelImpl> rowMapper() {
        return new NavigationFunctionModelMapper();
    }

    public List<NavigationFunctionModel> getFunModelByLinkUrl(String linkUrl) {
        Stream stream = NavigationFunctionCache.getCache().stream();
        return stream.filter(functionModel -> functionModel.getLinkUrl().contains(linkUrl)).collect(Collectors.toList());
    }
}

